/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.shared;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.tycho.core.shared.BuildProperties;

public class BuildPropertiesImpl
implements BuildProperties {
    private String javacSource;
    private String javacTarget;
    private String jreCompilationProfile;
    private String forceContextQualifier;
    private boolean rootFilesUseDefaultExcludes;
    private List<String> binIncludes;
    private List<String> binExcludes;
    private List<String> sourceIncludes;
    private List<String> sourceExcludes;
    private List<String> jarsExtraClasspath;
    private List<String> jarsCompileOrder;
    private Map<String, List<String>> jarToSourceFolderMap;
    private Map<String, List<String>> jarToExtraClasspathMap;
    private Map<String, String> jarToJavacDefaultEncodingMap;
    private Map<String, String> jarToOutputFolderMap;
    private Map<String, String> jarToManifestMap;
    private Map<String, String> rootEntries;

    public BuildPropertiesImpl(Properties properties) {
        this.javacSource = BuildPropertiesImpl.safeTrimValue("javacSource", properties);
        this.javacTarget = BuildPropertiesImpl.safeTrimValue("javacTarget", properties);
        this.forceContextQualifier = BuildPropertiesImpl.safeTrimValue("forceContextQualifier", properties);
        this.jreCompilationProfile = BuildPropertiesImpl.safeTrimValue("jre.compilation.profile", properties);
        this.rootFilesUseDefaultExcludes = Boolean.parseBoolean(properties.getProperty("rootFiles.useDefaultExcludes", "true"));
        this.sourceIncludes = BuildPropertiesImpl.splitAndTrimCommaSeparated(properties.getProperty("src.includes"));
        this.sourceExcludes = BuildPropertiesImpl.splitAndTrimCommaSeparated(properties.getProperty("src.excludes"));
        this.binIncludes = BuildPropertiesImpl.splitAndTrimCommaSeparated(properties.getProperty("bin.includes"));
        this.binExcludes = BuildPropertiesImpl.splitAndTrimCommaSeparated(properties.getProperty("bin.excludes"));
        this.jarsExtraClasspath = BuildPropertiesImpl.splitAndTrimCommaSeparated(properties.getProperty("jars.extra.classpath"));
        this.jarsCompileOrder = BuildPropertiesImpl.splitAndTrimCommaSeparated(properties.getProperty("jars.compile.order"));
        HashMap<String, List<String>> jarTosourceFolderTmp = new HashMap<String, List<String>>();
        HashMap<String, List<String>> jarToExtraClasspathTmp = new HashMap<String, List<String>>();
        HashMap<String, String> jarToJavacDefaultEncodingTmp = new HashMap<String, String>();
        HashMap<String, String> jarToOutputFolderMapTmp = new HashMap<String, String>();
        HashMap<String, String> jarToManifestMapTmp = new HashMap<String, String>();
        HashMap<String, String> rootEntriesTmp = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String jarName;
            String key = ((String)entry.getKey()).trim();
            String value = ((String)entry.getValue()).trim();
            if (key.startsWith("source.")) {
                jarName = key.substring("source.".length());
                jarTosourceFolderTmp.put(jarName, BuildPropertiesImpl.splitAndTrimCommaSeparated(value));
                continue;
            }
            if (key.startsWith("extra.")) {
                jarName = key.substring("extra.".length());
                jarToExtraClasspathTmp.put(jarName, BuildPropertiesImpl.splitAndTrimCommaSeparated(value));
                continue;
            }
            if (key.startsWith("javacDefaultEncoding.")) {
                jarName = key.substring("javacDefaultEncoding.".length());
                jarToJavacDefaultEncodingTmp.put(jarName, value);
                continue;
            }
            if (key.startsWith("output.")) {
                jarName = key.substring("output.".length());
                jarToOutputFolderMapTmp.put(jarName, value);
                continue;
            }
            if (key.startsWith("manifest.")) {
                jarName = key.substring("manifest.".length());
                jarToManifestMapTmp.put(jarName, value);
                continue;
            }
            if (!key.startsWith("root.") && !key.equals("root")) continue;
            rootEntriesTmp.put(key, value);
        }
        this.jarToSourceFolderMap = BuildPropertiesImpl.unmodifiableMap(jarTosourceFolderTmp);
        this.jarToExtraClasspathMap = BuildPropertiesImpl.unmodifiableMap(jarToExtraClasspathTmp);
        this.jarToJavacDefaultEncodingMap = BuildPropertiesImpl.unmodifiableMap(jarToJavacDefaultEncodingTmp);
        this.jarToOutputFolderMap = BuildPropertiesImpl.unmodifiableMap(jarToOutputFolderMapTmp);
        this.jarToManifestMap = BuildPropertiesImpl.unmodifiableMap(jarToManifestMapTmp);
        this.rootEntries = BuildPropertiesImpl.unmodifiableMap(rootEntriesTmp);
    }

    private static Map unmodifiableMap(Map map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }

    private static String safeTrimValue(String key, Properties buildProperties) {
        String value = buildProperties.getProperty(key);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    private static List<String> splitAndTrimCommaSeparated(String rawValue) {
        ArrayList<String> result = new ArrayList<String>();
        if (rawValue != null) {
            String[] stringArray = rawValue.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                result.add(element.trim());
                ++n2;
            }
        }
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<String> getBinIncludes() {
        return this.binIncludes;
    }

    @Override
    public List<String> getBinExcludes() {
        return this.binExcludes;
    }

    @Override
    public List<String> getSourceIncludes() {
        return this.sourceIncludes;
    }

    @Override
    public List<String> getSourceExcludes() {
        return this.sourceExcludes;
    }

    @Override
    public Map<String, List<String>> getJarToSourceFolderMap() {
        return this.jarToSourceFolderMap;
    }

    @Override
    public List<String> getJarsExtraClasspath() {
        return this.jarsExtraClasspath;
    }

    @Override
    public String getJavacSource() {
        return this.javacSource;
    }

    @Override
    public String getJavacTarget() {
        return this.javacTarget;
    }

    @Override
    public List<String> getJarsCompileOrder() {
        return this.jarsCompileOrder;
    }

    @Override
    public Map<String, List<String>> getJarToExtraClasspathMap() {
        return this.jarToExtraClasspathMap;
    }

    @Override
    public Map<String, String> getJarToJavacDefaultEncodingMap() {
        return this.jarToJavacDefaultEncodingMap;
    }

    @Override
    public Map<String, String> getJarToOutputFolderMap() {
        return this.jarToOutputFolderMap;
    }

    @Override
    public Map<String, String> getJarToManifestMap() {
        return this.jarToManifestMap;
    }

    @Override
    public String getJreCompilationProfile() {
        return this.jreCompilationProfile;
    }

    @Override
    public String getForceContextQualifier() {
        return this.forceContextQualifier;
    }

    @Override
    public boolean isRootFilesUseDefaultExcludes() {
        return this.rootFilesUseDefaultExcludes;
    }

    @Override
    public Map<String, String> getRootEntries() {
        return this.rootEntries;
    }
}

