/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.tiering;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.ehcache.config.ResourceType;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.collections.ConcurrentWeakIdentityHashMap;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.tiering.CachingTier;
import org.ehcache.core.spi.store.tiering.HigherCachingTier;
import org.ehcache.core.spi.store.tiering.LowerCachingTier;
import org.ehcache.spi.resilience.StoreAccessException;
import org.ehcache.spi.service.OptionalServiceDependencies;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompoundCachingTier<K, V>
implements CachingTier<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompoundCachingTier.class);
    private final HigherCachingTier<K, V> higher;
    private final LowerCachingTier<K, V> lower;
    private volatile CachingTier.InvalidationListener<K, V> invalidationListener;

    public CompoundCachingTier(HigherCachingTier<K, V> higher, LowerCachingTier<K, V> lower) {
        this.higher = higher;
        this.lower = lower;
        this.higher.setInvalidationListener((key, valueHolder) -> {
            try {
                this.lower.installMapping(key, k -> valueHolder);
            }
            catch (StoreAccessException cae) {
                this.notifyInvalidation(key, valueHolder);
                LOGGER.warn("Error overflowing '{}' into lower caching tier {}", new Object[]{key, lower, cae});
            }
        });
    }

    private void notifyInvalidation(K key, Store.ValueHolder<V> p) {
        CachingTier.InvalidationListener<K, V> invalidationListener = this.invalidationListener;
        if (invalidationListener != null) {
            invalidationListener.onInvalidation(key, p);
        }
    }

    @Override
    public Store.ValueHolder<V> getOrComputeIfAbsent(K key, Function<K, Store.ValueHolder<V>> source) throws StoreAccessException {
        try {
            return this.higher.getOrComputeIfAbsent(key, keyParam -> {
                try {
                    Store.ValueHolder<V> valueHolder = this.lower.getAndRemove(keyParam);
                    if (valueHolder != null) {
                        return valueHolder;
                    }
                    return (Store.ValueHolder)source.apply(keyParam);
                }
                catch (StoreAccessException cae) {
                    throw new ComputationException(cae);
                }
            });
        }
        catch (ComputationException ce) {
            throw ce.getStoreAccessException();
        }
    }

    @Override
    public Store.ValueHolder<V> getOrDefault(K key, Function<K, Store.ValueHolder<V>> source) throws StoreAccessException {
        try {
            return this.higher.getOrDefault(key, keyParam -> {
                try {
                    Store.ValueHolder<V> valueHolder = this.lower.get(keyParam);
                    if (valueHolder != null) {
                        return valueHolder;
                    }
                    return (Store.ValueHolder)source.apply(keyParam);
                }
                catch (StoreAccessException cae) {
                    throw new ComputationException(cae);
                }
            });
        }
        catch (ComputationException ce) {
            throw ce.getStoreAccessException();
        }
    }

    @Override
    public void invalidate(K key) throws StoreAccessException {
        try {
            this.higher.silentInvalidate(key, mappedValue -> {
                try {
                    if (mappedValue != null) {
                        this.notifyInvalidation(key, (Store.ValueHolder<V>)mappedValue);
                    } else {
                        this.lower.invalidate(key);
                    }
                }
                catch (StoreAccessException cae) {
                    throw new ComputationException(cae);
                }
                return null;
            });
        }
        catch (ComputationException ce) {
            throw ce.getStoreAccessException();
        }
    }

    @Override
    public void invalidateAll() throws StoreAccessException {
        try {
            this.higher.silentInvalidateAll((key, mappedValue) -> {
                if (mappedValue != null) {
                    this.notifyInvalidation((K)key, (Store.ValueHolder<V>)mappedValue);
                }
                return null;
            });
        }
        finally {
            this.lower.invalidateAll();
        }
    }

    @Override
    public void invalidateAllWithHash(long hash) throws StoreAccessException {
        try {
            this.higher.silentInvalidateAllWithHash(hash, (key, mappedValue) -> {
                if (mappedValue != null) {
                    this.notifyInvalidation((K)key, (Store.ValueHolder<V>)mappedValue);
                }
                return null;
            });
        }
        finally {
            this.lower.invalidateAllWithHash(hash);
        }
    }

    @Override
    public void clear() throws StoreAccessException {
        try {
            this.higher.clear();
        }
        finally {
            this.lower.clear();
        }
    }

    @Override
    public void setInvalidationListener(CachingTier.InvalidationListener<K, V> invalidationListener) {
        this.invalidationListener = invalidationListener;
        this.lower.setInvalidationListener(invalidationListener);
    }

    @Override
    public Map<K, Store.ValueHolder<V>> bulkGetOrComputeIfAbsent(Iterable<? extends K> keys, Function<Set<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends Store.ValueHolder<V>>>> mappingFunction) throws StoreAccessException {
        try {
            return this.higher.bulkGetOrComputeIfAbsent(keys, keyParam -> {
                try {
                    HashMap<Object, Store.ValueHolder<V>> result = new HashMap<Object, Store.ValueHolder<V>>();
                    HashSet missingKeys = new HashSet();
                    for (Object key : keys) {
                        Store.ValueHolder<V> cachingFetch = this.lower.getAndRemove(key);
                        if (null == cachingFetch) {
                            missingKeys.add(key);
                            continue;
                        }
                        result.put(key, cachingFetch);
                    }
                    Iterable fetchedEntries = (Iterable)mappingFunction.apply(missingKeys);
                    for (Map.Entry entry : fetchedEntries) {
                        result.put(entry.getKey(), (Store.ValueHolder<V>)entry.getValue());
                    }
                    return result.entrySet();
                }
                catch (StoreAccessException cae) {
                    throw new ComputationException(cae);
                }
            });
        }
        catch (ComputationException ce) {
            throw ce.getStoreAccessException();
        }
    }

    @Override
    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        ArrayList<CacheConfigurationChangeListener> listeners = new ArrayList<CacheConfigurationChangeListener>();
        listeners.addAll(this.higher.getConfigurationChangeListeners());
        listeners.addAll(this.lower.getConfigurationChangeListeners());
        return listeners;
    }

    @ServiceDependencies(value={HigherCachingTier.Provider.class, LowerCachingTier.Provider.class})
    @OptionalServiceDependencies(value={"org.ehcache.core.spi.service.StatisticsService"})
    public static class Provider
    implements CachingTier.Provider {
        private volatile ServiceProvider<Service> serviceProvider;
        private final ConcurrentMap<CachingTier<?, ?>, Map.Entry<HigherCachingTier.Provider, LowerCachingTier.Provider>> providersMap = new ConcurrentWeakIdentityHashMap();

        @Override
        public <K, V> CachingTier<K, V> createCachingTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?, ?> ... serviceConfigs) {
            if (this.serviceProvider == null) {
                throw new RuntimeException("ServiceProvider is null.");
            }
            Collection<HigherCachingTier.Provider> higherProviders = this.serviceProvider.getServicesOfType(HigherCachingTier.Provider.class);
            if (higherProviders.size() != 1) {
                throw new IllegalStateException("Cannot handle multiple higher tier providers");
            }
            HigherCachingTier.Provider higherProvider = higherProviders.iterator().next();
            HigherCachingTier<K, V> higherCachingTier = higherProvider.createHigherCachingTier(storeConfig, serviceConfigs);
            Collection<LowerCachingTier.Provider> lowerProviders = this.serviceProvider.getServicesOfType(LowerCachingTier.Provider.class);
            if (lowerProviders.size() != 1) {
                throw new IllegalStateException("Cannot handle multiple lower tier providers");
            }
            LowerCachingTier.Provider lowerProvider = lowerProviders.iterator().next();
            LowerCachingTier<K, V> lowerCachingTier = lowerProvider.createCachingTier(storeConfig, serviceConfigs);
            CompoundCachingTier<K, V> compoundCachingTier = new CompoundCachingTier<K, V>(higherCachingTier, lowerCachingTier);
            StatisticsService statisticsService = this.serviceProvider.getService(StatisticsService.class);
            if (statisticsService != null) {
                statisticsService.registerWithParent(higherCachingTier, compoundCachingTier);
                statisticsService.registerWithParent(lowerCachingTier, compoundCachingTier);
            }
            this.providersMap.put(compoundCachingTier, new AbstractMap.SimpleEntry<HigherCachingTier.Provider, LowerCachingTier.Provider>(higherProvider, lowerProvider));
            return compoundCachingTier;
        }

        @Override
        public void releaseCachingTier(CachingTier<?, ?> resource) {
            if (!this.providersMap.containsKey(resource)) {
                throw new IllegalArgumentException("Given caching tier is not managed by this provider : " + resource);
            }
            CompoundCachingTier compoundCachingTier = (CompoundCachingTier)resource;
            Map.Entry entry = (Map.Entry)this.providersMap.get(resource);
            ((HigherCachingTier.Provider)entry.getKey()).releaseHigherCachingTier(compoundCachingTier.higher);
            ((LowerCachingTier.Provider)entry.getValue()).releaseCachingTier(compoundCachingTier.lower);
        }

        @Override
        public void initCachingTier(CachingTier<?, ?> resource) {
            if (!this.providersMap.containsKey(resource)) {
                throw new IllegalArgumentException("Given caching tier is not managed by this provider : " + resource);
            }
            CompoundCachingTier compoundCachingTier = (CompoundCachingTier)resource;
            Map.Entry entry = (Map.Entry)this.providersMap.get(resource);
            ((LowerCachingTier.Provider)entry.getValue()).initCachingTier(compoundCachingTier.lower);
            ((HigherCachingTier.Provider)entry.getKey()).initHigherCachingTier(compoundCachingTier.higher);
        }

        @Override
        public int rankCachingTier(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?, ?>> serviceConfigs) {
            return resourceTypes.equals(Collections.unmodifiableSet(EnumSet.of(ResourceType.Core.HEAP, ResourceType.Core.OFFHEAP))) ? 2 : 0;
        }

        @Override
        public void start(ServiceProvider<Service> serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        @Override
        public void stop() {
            this.serviceProvider = null;
            this.providersMap.clear();
        }
    }

    static class ComputationException
    extends RuntimeException {
        private static final long serialVersionUID = 6832417052348277644L;

        public ComputationException(StoreAccessException cause) {
            super(cause);
        }

        public StoreAccessException getStoreAccessException() {
            return (StoreAccessException)this.getCause();
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

