/*
 * Licensed to ElasticSearch and Shay Banon under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. ElasticSearch licenses this
 * file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.elasticsearch.common.lucene.all;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Field;
import org.elasticsearch.ElasticSearchException;

import java.io.IOException;
import java.io.Reader;

/**
 *
 */
public class AllField extends AbstractField {

    private final AllEntries allEntries;

    private final Analyzer analyzer;

    public AllField(String name, Field.Store store, Field.TermVector termVector, AllEntries allEntries, Analyzer analyzer) {
        super(name, store, Field.Index.ANALYZED, termVector);

        this.allEntries = allEntries;
        this.analyzer = analyzer;
    }

    @Override
    public String stringValue() {
        if (isStored()) {
            return allEntries.buildText();
        }
        return null;
    }

    @Override
    public Reader readerValue() {
        return null;
    }

    @Override
    public TokenStream tokenStreamValue() {
        try {
            allEntries.reset(); // reset the all entries, just in case it was read already
            return AllTokenStream.allTokenStream(name, allEntries, analyzer);
        } catch (IOException e) {
            throw new ElasticSearchException("Failed to create token stream");
        }
    }
}
