/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.merge;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class MergeStats
implements Streamable,
ToXContent {
    private long total;
    private long totalTimeInMillis;
    private long totalNumDocs;
    private long totalSizeInBytes;
    private long current;
    private long currentNumDocs;
    private long currentSizeInBytes;
    private long totalStoppedTimeInMillis;
    private long totalThrottledTimeInMillis;
    private long totalBytesPerSecAutoThrottle;

    public void add(long totalMerges, long totalMergeTime, long totalNumDocs, long totalSizeInBytes, long currentMerges, long currentNumDocs, long currentSizeInBytes, long stoppedTimeMillis, long throttledTimeMillis, double mbPerSecAutoThrottle) {
        this.total += totalMerges;
        this.totalTimeInMillis += totalMergeTime;
        this.totalNumDocs += totalNumDocs;
        this.totalSizeInBytes += totalSizeInBytes;
        this.current += currentMerges;
        this.currentNumDocs += currentNumDocs;
        this.currentSizeInBytes += currentSizeInBytes;
        this.totalStoppedTimeInMillis += stoppedTimeMillis;
        this.totalThrottledTimeInMillis += throttledTimeMillis;
        long bytesPerSecAutoThrottle = (long)(mbPerSecAutoThrottle * 1024.0 * 1024.0);
        this.totalBytesPerSecAutoThrottle = this.totalBytesPerSecAutoThrottle == Long.MAX_VALUE || bytesPerSecAutoThrottle == Long.MAX_VALUE ? Long.MAX_VALUE : (this.totalBytesPerSecAutoThrottle += bytesPerSecAutoThrottle);
    }

    public void add(MergeStats mergeStats) {
        if (mergeStats == null) {
            return;
        }
        this.current += mergeStats.current;
        this.currentNumDocs += mergeStats.currentNumDocs;
        this.currentSizeInBytes += mergeStats.currentSizeInBytes;
        this.addTotals(mergeStats);
    }

    public void addTotals(MergeStats mergeStats) {
        if (mergeStats == null) {
            return;
        }
        this.total += mergeStats.total;
        this.totalTimeInMillis += mergeStats.totalTimeInMillis;
        this.totalNumDocs += mergeStats.totalNumDocs;
        this.totalSizeInBytes += mergeStats.totalSizeInBytes;
        this.totalStoppedTimeInMillis += mergeStats.totalStoppedTimeInMillis;
        this.totalThrottledTimeInMillis += mergeStats.totalThrottledTimeInMillis;
        this.totalBytesPerSecAutoThrottle = this.totalBytesPerSecAutoThrottle == Long.MAX_VALUE || mergeStats.totalBytesPerSecAutoThrottle == Long.MAX_VALUE ? Long.MAX_VALUE : (this.totalBytesPerSecAutoThrottle += mergeStats.totalBytesPerSecAutoThrottle);
    }

    public long getTotal() {
        return this.total;
    }

    public long getTotalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    public long getTotalStoppedTimeInMillis() {
        return this.totalStoppedTimeInMillis;
    }

    public TimeValue getTotalStoppedTime() {
        return new TimeValue(this.totalStoppedTimeInMillis);
    }

    public long getTotalThrottledTimeInMillis() {
        return this.totalThrottledTimeInMillis;
    }

    public TimeValue getTotalThrottledTime() {
        return new TimeValue(this.totalThrottledTimeInMillis);
    }

    public TimeValue getTotalTime() {
        return new TimeValue(this.totalTimeInMillis);
    }

    public long getTotalNumDocs() {
        return this.totalNumDocs;
    }

    public long getTotalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public ByteSizeValue getTotalSize() {
        return new ByteSizeValue(this.totalSizeInBytes);
    }

    public long getTotalBytesPerSecAutoThrottle() {
        return this.totalBytesPerSecAutoThrottle;
    }

    public long getCurrent() {
        return this.current;
    }

    public long getCurrentNumDocs() {
        return this.currentNumDocs;
    }

    public long getCurrentSizeInBytes() {
        return this.currentSizeInBytes;
    }

    public ByteSizeValue getCurrentSize() {
        return new ByteSizeValue(this.currentSizeInBytes);
    }

    public static MergeStats readMergeStats(StreamInput in) throws IOException {
        MergeStats stats = new MergeStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.MERGES);
        builder.field(Fields.CURRENT, this.current);
        builder.field(Fields.CURRENT_DOCS, this.currentNumDocs);
        builder.byteSizeField(Fields.CURRENT_SIZE_IN_BYTES, Fields.CURRENT_SIZE, this.currentSizeInBytes);
        builder.field(Fields.TOTAL, this.total);
        builder.timeValueField(Fields.TOTAL_TIME_IN_MILLIS, Fields.TOTAL_TIME, this.totalTimeInMillis);
        builder.field(Fields.TOTAL_DOCS, this.totalNumDocs);
        builder.byteSizeField(Fields.TOTAL_SIZE_IN_BYTES, Fields.TOTAL_SIZE, this.totalSizeInBytes);
        builder.timeValueField(Fields.TOTAL_STOPPED_TIME_IN_MILLIS, Fields.TOTAL_STOPPED_TIME, this.totalStoppedTimeInMillis);
        builder.timeValueField(Fields.TOTAL_THROTTLED_TIME_IN_MILLIS, Fields.TOTAL_THROTTLED_TIME, this.totalThrottledTimeInMillis);
        builder.byteSizeField(Fields.TOTAL_THROTTLE_BYTES_PER_SEC_IN_BYTES, Fields.TOTAL_THROTTLE_BYTES_PER_SEC, this.totalBytesPerSecAutoThrottle);
        builder.endObject();
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.total = in.readVLong();
        this.totalTimeInMillis = in.readVLong();
        this.totalNumDocs = in.readVLong();
        this.totalSizeInBytes = in.readVLong();
        this.current = in.readVLong();
        this.currentNumDocs = in.readVLong();
        this.currentSizeInBytes = in.readVLong();
        this.totalStoppedTimeInMillis = in.readVLong();
        this.totalThrottledTimeInMillis = in.readVLong();
        this.totalBytesPerSecAutoThrottle = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.total);
        out.writeVLong(this.totalTimeInMillis);
        out.writeVLong(this.totalNumDocs);
        out.writeVLong(this.totalSizeInBytes);
        out.writeVLong(this.current);
        out.writeVLong(this.currentNumDocs);
        out.writeVLong(this.currentSizeInBytes);
        out.writeVLong(this.totalStoppedTimeInMillis);
        out.writeVLong(this.totalThrottledTimeInMillis);
        out.writeVLong(this.totalBytesPerSecAutoThrottle);
    }

    static final class Fields {
        static final XContentBuilderString MERGES = new XContentBuilderString("merges");
        static final XContentBuilderString CURRENT = new XContentBuilderString("current");
        static final XContentBuilderString CURRENT_DOCS = new XContentBuilderString("current_docs");
        static final XContentBuilderString CURRENT_SIZE = new XContentBuilderString("current_size");
        static final XContentBuilderString CURRENT_SIZE_IN_BYTES = new XContentBuilderString("current_size_in_bytes");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString TOTAL_TIME = new XContentBuilderString("total_time");
        static final XContentBuilderString TOTAL_TIME_IN_MILLIS = new XContentBuilderString("total_time_in_millis");
        static final XContentBuilderString TOTAL_STOPPED_TIME = new XContentBuilderString("total_stopped_time");
        static final XContentBuilderString TOTAL_STOPPED_TIME_IN_MILLIS = new XContentBuilderString("total_stopped_time_in_millis");
        static final XContentBuilderString TOTAL_THROTTLED_TIME = new XContentBuilderString("total_throttled_time");
        static final XContentBuilderString TOTAL_THROTTLED_TIME_IN_MILLIS = new XContentBuilderString("total_throttled_time_in_millis");
        static final XContentBuilderString TOTAL_DOCS = new XContentBuilderString("total_docs");
        static final XContentBuilderString TOTAL_SIZE = new XContentBuilderString("total_size");
        static final XContentBuilderString TOTAL_SIZE_IN_BYTES = new XContentBuilderString("total_size_in_bytes");
        static final XContentBuilderString TOTAL_THROTTLE_BYTES_PER_SEC_IN_BYTES = new XContentBuilderString("total_auto_throttle_in_bytes");
        static final XContentBuilderString TOTAL_THROTTLE_BYTES_PER_SEC = new XContentBuilderString("total_auto_throttle");

        Fields() {
        }
    }
}

