/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.aggregations.InternalAggregation;

public class AggregationStreams {
    private static ImmutableMap<BytesReference, Stream> streams = ImmutableMap.of();

    public static synchronized void registerStream(Stream stream, BytesReference ... types) {
        MapBuilder<BytesReference, Stream> uStreams = MapBuilder.newMapBuilder(streams);
        for (BytesReference type : types) {
            uStreams.put(type, stream);
        }
        streams = uStreams.immutableMap();
    }

    public static Stream stream(BytesReference type) {
        return (Stream)streams.get((Object)type);
    }

    public static interface Stream {
        public InternalAggregation readResult(StreamInput var1) throws IOException;
    }
}

