/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.TimeValue;

public class XContentMapValues {
    private static final int MAX_DETERMINIZED_STATES = 50000;

    public static List<Object> extractRawValues(String path, Map<String, Object> map) {
        ArrayList<Object> values = new ArrayList<Object>();
        String[] pathElements = path.split("\\.");
        if (pathElements.length == 0) {
            return values;
        }
        XContentMapValues.extractRawValues(values, map, pathElements, 0);
        return values;
    }

    private static void extractRawValues(List values, Map<String, Object> part, String[] pathElements, int index) {
        if (index == pathElements.length) {
            return;
        }
        String key = pathElements[index];
        int nextIndex = index + 1;
        while (true) {
            Object currentValue;
            if ((currentValue = part.get(key)) != null) {
                if (currentValue instanceof Map) {
                    XContentMapValues.extractRawValues(values, (Map)currentValue, pathElements, nextIndex);
                } else if (currentValue instanceof List) {
                    XContentMapValues.extractRawValues(values, (List)currentValue, pathElements, nextIndex);
                } else if (nextIndex == pathElements.length) {
                    values.add(currentValue);
                }
            }
            if (nextIndex == pathElements.length) {
                return;
            }
            key = key + "." + pathElements[nextIndex];
            ++nextIndex;
        }
    }

    private static void extractRawValues(List values, List<Object> part, String[] pathElements, int index) {
        for (Object value : part) {
            if (value == null) continue;
            if (value instanceof Map) {
                XContentMapValues.extractRawValues(values, (Map)value, pathElements, index);
                continue;
            }
            if (value instanceof List) {
                XContentMapValues.extractRawValues(values, (List)value, pathElements, index);
                continue;
            }
            if (index != pathElements.length) continue;
            values.add(value);
        }
    }

    public static Object extractValue(String path, Map<?, ?> map) {
        return XContentMapValues.extractValue(map, path.split("\\."));
    }

    public static Object extractValue(Map<?, ?> map, String ... pathElements) {
        if (pathElements.length == 0) {
            return null;
        }
        return XContentMapValues.extractValue(pathElements, 0, map, null);
    }

    public static List<Map<?, ?>> extractNestedSources(String nestedPath, Map<?, ?> map) {
        Object extractedValue = XContentMapValues.extractValue(nestedPath, map);
        List nestedParsedSource = null;
        if (extractedValue != null) {
            if (extractedValue instanceof List) {
                nestedParsedSource = (List)extractedValue;
            } else {
                if (extractedValue instanceof Map) {
                    return Collections.singletonList((Map)extractedValue);
                }
                throw new IllegalStateException("Cannot extract nested source from path [" + nestedPath + "]: got [" + extractedValue + "]");
            }
        }
        if (nestedParsedSource == null) {
            return null;
        }
        ArrayList flattenedSource = new ArrayList();
        XContentMapValues.extractObjects(nestedParsedSource, flattenedSource);
        return flattenedSource;
    }

    private static void extractObjects(List<?> source, List<Map<?, ?>> extracted) {
        for (Object object : source) {
            if (object instanceof Map) {
                extracted.add((Map)object);
                continue;
            }
            if (!(object instanceof List)) continue;
            XContentMapValues.extractObjects((List)object, extracted);
        }
    }

    public static Object extractValue(String path, Map<?, ?> map, Object nullValue) {
        String[] pathElements = path.split("\\.");
        if (pathElements.length == 0) {
            return null;
        }
        return XContentMapValues.extractValue(pathElements, 0, map, nullValue);
    }

    private static Object extractValue(String[] pathElements, int index, Object currentValue, Object nullValue) {
        if (currentValue instanceof List) {
            List valueList = (List)currentValue;
            ArrayList<Object> newList = new ArrayList<Object>(valueList.size());
            for (Object o : valueList) {
                Object listValue = XContentMapValues.extractValue(pathElements, index, o, nullValue);
                if (listValue == null) continue;
                newList.add(listValue);
            }
            return newList;
        }
        if (index == pathElements.length) {
            return currentValue != null ? currentValue : nullValue;
        }
        if (currentValue instanceof Map) {
            Map map = (Map)currentValue;
            String key = pathElements[index];
            int nextIndex = index + 1;
            ArrayList<Object> extractedValues = new ArrayList<Object>();
            while (true) {
                if (map.containsKey(key)) {
                    Object mapValue = map.get(key);
                    if (mapValue == null) {
                        extractedValues.add(nullValue);
                    } else {
                        Object val = XContentMapValues.extractValue(pathElements, nextIndex, mapValue, nullValue);
                        if (val != null) {
                            extractedValues.add(val);
                        }
                    }
                }
                if (nextIndex == pathElements.length) {
                    if (extractedValues.size() == 0) {
                        return null;
                    }
                    if (extractedValues.size() == 1) {
                        return extractedValues.get(0);
                    }
                    return extractedValues;
                }
                key = key + "." + pathElements[nextIndex];
                ++nextIndex;
            }
        }
        return null;
    }

    public static Map<String, Object> filter(Map<String, ?> map, String[] includes, String[] excludes) {
        return XContentMapValues.filter(includes, excludes).apply(map);
    }

    public static Function<Map<String, ?>, Map<String, Object>> filter(String[] includes, String[] excludes) {
        Automaton excludeA;
        CharacterRunAutomaton include;
        CharacterRunAutomaton matchAllAutomaton = new CharacterRunAutomaton(Automata.makeAnyString());
        if (includes == null || includes.length == 0) {
            include = matchAllAutomaton;
        } else {
            Automaton includeA = Regex.simpleMatchToAutomaton(includes);
            includeA = XContentMapValues.makeMatchDotsInFieldNames(includeA);
            include = new CharacterRunAutomaton(includeA, 50000);
        }
        if (excludes == null || excludes.length == 0) {
            excludeA = Automata.makeEmpty();
        } else {
            excludeA = Regex.simpleMatchToAutomaton(excludes);
            excludeA = XContentMapValues.makeMatchDotsInFieldNames(excludeA);
        }
        CharacterRunAutomaton exclude = new CharacterRunAutomaton(excludeA, 50000);
        return map -> XContentMapValues.filter(map, include, 0, exclude, 0, matchAllAutomaton);
    }

    private static Automaton makeMatchDotsInFieldNames(Automaton automaton) {
        Automaton tail = Operations.union((Automaton)Automata.makeEmptyString(), (Automaton)Operations.concatenate((Automaton)Automata.makeChar((int)46), (Automaton)Automata.makeAnyString()));
        return Operations.concatenate((Automaton)automaton, (Automaton)tail);
    }

    private static int step(CharacterRunAutomaton automaton, String key, int state) {
        for (int i = 0; state != -1 && i < key.length(); ++i) {
            state = automaton.step(state, (int)key.charAt(i));
        }
        return state;
    }

    private static Map<String, Object> filter(Map<String, ?> map, CharacterRunAutomaton includeAutomaton, int initialIncludeState, CharacterRunAutomaton excludeAutomaton, int initialExcludeState, CharacterRunAutomaton matchAllAutomaton) {
        HashMap<String, Object> filtered = new HashMap<String, Object>();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            int excludeState;
            String key = entry.getKey();
            int includeState = XContentMapValues.step(includeAutomaton, key, initialIncludeState);
            if (includeState == -1 || (excludeState = XContentMapValues.step(excludeAutomaton, key, initialExcludeState)) != -1 && excludeAutomaton.isAccept(excludeState)) continue;
            Object value = entry.getValue();
            CharacterRunAutomaton subIncludeAutomaton = includeAutomaton;
            int subIncludeState = includeState;
            if (includeAutomaton.isAccept(includeState)) {
                if (excludeState == -1 || excludeAutomaton.step(excludeState, 46) == -1) {
                    filtered.put(key, value);
                    continue;
                }
                subIncludeAutomaton = matchAllAutomaton;
                subIncludeState = 0;
            }
            if (value instanceof Map) {
                if ((subIncludeState = subIncludeAutomaton.step(subIncludeState, 46)) == -1) continue;
                if (excludeState != -1) {
                    excludeState = excludeAutomaton.step(excludeState, 46);
                }
                Map valueAsMap = (Map)value;
                Map<String, Object> filteredValue = XContentMapValues.filter(valueAsMap, subIncludeAutomaton, subIncludeState, excludeAutomaton, excludeState, matchAllAutomaton);
                if (!includeAutomaton.isAccept(includeState) && filteredValue.isEmpty()) continue;
                filtered.put(key, filteredValue);
                continue;
            }
            if (value instanceof Iterable) {
                List<Object> filteredValue = XContentMapValues.filter((Iterable)value, subIncludeAutomaton, subIncludeState, excludeAutomaton, excludeState, matchAllAutomaton);
                if (!includeAutomaton.isAccept(includeState) && filteredValue.isEmpty()) continue;
                filtered.put(key, filteredValue);
                continue;
            }
            if (!includeAutomaton.isAccept(includeState) || excludeState != -1 && excludeAutomaton.isAccept(excludeState)) continue;
            filtered.put(key, value);
        }
        return filtered;
    }

    private static List<Object> filter(Iterable<?> iterable, CharacterRunAutomaton includeAutomaton, int initialIncludeState, CharacterRunAutomaton excludeAutomaton, int initialExcludeState, CharacterRunAutomaton matchAllAutomaton) {
        ArrayList<Object> filtered = new ArrayList<Object>();
        boolean isInclude = includeAutomaton.isAccept(initialIncludeState);
        for (Object value : iterable) {
            if (value instanceof Map) {
                Map<String, Object> filteredValue;
                int includeState = includeAutomaton.step(initialIncludeState, 46);
                int excludeState = initialExcludeState;
                if (excludeState != -1) {
                    excludeState = excludeAutomaton.step(excludeState, 46);
                }
                if ((filteredValue = XContentMapValues.filter((Map)value, includeAutomaton, includeState, excludeAutomaton, excludeState, matchAllAutomaton)).isEmpty()) continue;
                filtered.add(filteredValue);
                continue;
            }
            if (value instanceof Iterable) {
                List<Object> filteredValue = XContentMapValues.filter((Iterable)value, includeAutomaton, initialIncludeState, excludeAutomaton, initialExcludeState, matchAllAutomaton);
                if (filteredValue.isEmpty()) continue;
                filtered.add(filteredValue);
                continue;
            }
            if (!isInclude) continue;
            filtered.add(value);
        }
        return filtered;
    }

    public static boolean isObject(Object node) {
        return node instanceof Map;
    }

    public static boolean isArray(Object node) {
        return node instanceof List;
    }

    public static String nodeStringValue(Object node, String defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return node.toString();
    }

    public static String nodeStringValue(Object node) {
        if (node == null) {
            return null;
        }
        return node.toString();
    }

    public static float nodeFloatValue(Object node, float defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeFloatValue(node);
    }

    public static float nodeFloatValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).floatValue();
        }
        return Float.parseFloat(node.toString());
    }

    public static double nodeDoubleValue(Object node, double defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeDoubleValue(node);
    }

    public static double nodeDoubleValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).doubleValue();
        }
        return Double.parseDouble(node.toString());
    }

    public static int nodeIntegerValue(Object node) {
        if (node instanceof Number) {
            return Numbers.toIntExact((Number)node);
        }
        return Integer.parseInt(node.toString());
    }

    public static int nodeIntegerValue(Object node, int defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeIntegerValue(node);
    }

    public static short nodeShortValue(Object node, short defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeShortValue(node);
    }

    public static short nodeShortValue(Object node) {
        if (node instanceof Number) {
            return Numbers.toShortExact((Number)node);
        }
        return Short.parseShort(node.toString());
    }

    public static byte nodeByteValue(Object node, byte defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeByteValue(node);
    }

    public static byte nodeByteValue(Object node) {
        if (node instanceof Number) {
            return Numbers.toByteExact((Number)node);
        }
        return Byte.parseByte(node.toString());
    }

    public static long nodeLongValue(Object node, long defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeLongValue(node);
    }

    public static long nodeLongValue(Object node) {
        if (node instanceof Number) {
            return Numbers.toLongExact((Number)node);
        }
        return Long.parseLong(node.toString());
    }

    public static boolean nodeBooleanValue(Object node, String name, boolean defaultValue) {
        try {
            return XContentMapValues.nodeBooleanValue(node, defaultValue);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Could not convert [" + name + "] to boolean", ex);
        }
    }

    public static boolean nodeBooleanValue(Object node, boolean defaultValue) {
        String nodeValue = node == null ? null : node.toString();
        return Booleans.parseBoolean((String)nodeValue, (boolean)defaultValue);
    }

    public static boolean nodeBooleanValue(Object node, String name) {
        try {
            return XContentMapValues.nodeBooleanValue(node);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Could not convert [" + name + "] to boolean", ex);
        }
    }

    public static boolean nodeBooleanValue(Object node) {
        return Booleans.parseBoolean((String)node.toString());
    }

    public static TimeValue nodeTimeValue(Object node, TimeValue defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeTimeValue(node);
    }

    public static TimeValue nodeTimeValue(Object node) {
        if (node instanceof Number) {
            return TimeValue.timeValueMillis((long)((Number)node).longValue());
        }
        return TimeValue.parseTimeValue((String)node.toString(), null, (String)(XContentMapValues.class.getSimpleName() + ".nodeTimeValue"));
    }

    public static Map<String, Object> nodeMapValue(Object node, String desc) {
        if (node instanceof Map) {
            return (Map)node;
        }
        throw new ElasticsearchParseException(desc + " should be a hash but was of type: " + node.getClass(), new Object[0]);
    }

    public static String[] nodeStringArrayValue(Object node) {
        if (XContentMapValues.isArray(node)) {
            List list = (List)node;
            String[] arr = new String[list.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = XContentMapValues.nodeStringValue(list.get(i), null);
            }
            return arr;
        }
        return Strings.splitStringByCommaToArray(node.toString());
    }
}

