/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.text.NumberFormat;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.IndexSortSortedNumericDocValuesRangeQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.common.util.LocaleUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.DateRangeIncludingNowQuery;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.DateFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.lookup.FieldValues;
import org.elasticsearch.search.lookup.SearchLookup;

public final class DateFieldMapper
extends FieldMapper {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(DateFieldMapper.class);
    public static final String CONTENT_TYPE = "date";
    public static final String DATE_NANOS_CONTENT_TYPE = "date_nanos";
    public static final DateFormatter DEFAULT_DATE_TIME_FORMATTER = DateFormatter.forPattern("strict_date_optional_time||epoch_millis");
    public static final DateFormatter DEFAULT_DATE_TIME_NANOS_FORMATTER = DateFormatter.forPattern("strict_date_optional_time_nanos||epoch_millis");
    public static final FieldMapper.TypeParser MILLIS_PARSER = new FieldMapper.TypeParser((n, c) -> {
        boolean ignoreMalformedByDefault = (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings());
        return new Builder((String)n, Resolution.MILLISECONDS, c.getDateFormatter(), c.scriptCompiler(), ignoreMalformedByDefault, c.indexVersionCreated());
    });
    public static final FieldMapper.TypeParser NANOS_PARSER = new FieldMapper.TypeParser((n, c) -> {
        boolean ignoreMalformedByDefault = (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings());
        return new Builder((String)n, Resolution.NANOSECONDS, c.getDateFormatter(), c.scriptCompiler(), ignoreMalformedByDefault, c.indexVersionCreated());
    });
    private final boolean store;
    private final boolean indexed;
    private final boolean hasDocValues;
    private final Locale locale;
    private final String format;
    private final boolean ignoreMalformed;
    private final Long nullValue;
    private final String nullValueAsString;
    private final Resolution resolution;
    private final boolean ignoreMalformedByDefault;
    private final Version indexCreatedVersion;
    private final Script script;
    private final ScriptCompiler scriptCompiler;
    private final FieldValues<Long> scriptValues;

    private static DateFieldMapper toType(FieldMapper in) {
        return (DateFieldMapper)in;
    }

    private DateFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Long nullValue, Resolution resolution, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo, builder.script.get() != null, (String)builder.onScriptError.get());
        this.store = (Boolean)builder.store.getValue();
        this.indexed = (Boolean)builder.index.getValue();
        this.hasDocValues = (Boolean)builder.docValues.getValue();
        this.locale = (Locale)builder.locale.getValue();
        this.format = (String)builder.format.getValue();
        this.ignoreMalformed = (Boolean)builder.ignoreMalformed.getValue();
        this.nullValueAsString = (String)builder.nullValue.getValue();
        this.nullValue = nullValue;
        this.resolution = resolution;
        this.ignoreMalformedByDefault = (Boolean)builder.ignoreMalformed.getDefaultValue();
        this.indexCreatedVersion = builder.indexCreatedVersion;
        this.script = (Script)builder.script.get();
        this.scriptCompiler = builder.scriptCompiler;
        this.scriptValues = builder.scriptValues();
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.resolution, null, this.scriptCompiler, this.ignoreMalformedByDefault, this.indexCreatedVersion).init(this);
    }

    @Override
    public DateFieldType fieldType() {
        return (DateFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType().resolution.type();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        long timestamp;
        String dateAsString = context.parser().textOrNull();
        if (dateAsString == null) {
            if (this.nullValue == null) {
                return;
            }
            timestamp = this.nullValue;
        } else {
            try {
                timestamp = this.fieldType().parse(dateAsString);
            }
            catch (ArithmeticException | IllegalArgumentException | DateTimeException | ElasticsearchParseException e) {
                if (this.ignoreMalformed) {
                    context.addIgnoredField(this.mappedFieldType.name());
                    return;
                }
                throw e;
            }
        }
        this.indexValue(context, timestamp);
    }

    private void indexValue(ParseContext context, long timestamp) {
        if (this.indexed) {
            context.doc().add((IndexableField)new LongPoint(this.fieldType().name(), new long[]{timestamp}));
        }
        if (this.hasDocValues) {
            context.doc().add((IndexableField)new SortedNumericDocValuesField(this.fieldType().name(), timestamp));
        } else if (this.store || this.indexed) {
            context.addToFieldNames(this.fieldType().name());
        }
        if (this.store) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), timestamp));
        }
    }

    @Override
    protected void indexScriptValues(SearchLookup searchLookup, LeafReaderContext readerContext, int doc, ParseContext parseContext) {
        this.scriptValues.valuesForDoc(searchLookup, readerContext, doc, v -> this.indexValue(parseContext, (long)v));
    }

    public boolean getIgnoreMalformed() {
        return this.ignoreMalformed;
    }

    public Long getNullValue() {
        return this.nullValue;
    }

    public static enum Resolution {
        MILLISECONDS("date", IndexNumericFieldData.NumericType.DATE){

            @Override
            public long convert(Instant instant) {
                return instant.toEpochMilli();
            }

            @Override
            public Instant toInstant(long value) {
                return Instant.ofEpochMilli(value);
            }

            @Override
            public Instant clampToValidRange(Instant instant) {
                return instant;
            }

            @Override
            public long parsePointAsMillis(byte[] value) {
                return LongPoint.decodeDimension((byte[])value, (int)0);
            }

            @Override
            public long roundDownToMillis(long value) {
                return value;
            }

            @Override
            public long roundUpToMillis(long value) {
                return value;
            }

            @Override
            protected Query distanceFeatureQuery(String field, float boost, long origin, TimeValue pivot) {
                return LongPoint.newDistanceFeatureQuery((String)field, (float)boost, (long)origin, (long)pivot.getMillis());
            }
        }
        ,
        NANOSECONDS("date_nanos", IndexNumericFieldData.NumericType.DATE_NANOSECONDS){

            @Override
            public long convert(Instant instant) {
                return DateUtils.toLong(instant);
            }

            @Override
            public Instant toInstant(long value) {
                return DateUtils.toInstant(value);
            }

            @Override
            public Instant clampToValidRange(Instant instant) {
                return DateUtils.clampToNanosRange(instant);
            }

            @Override
            public long parsePointAsMillis(byte[] value) {
                return this.roundDownToMillis(LongPoint.decodeDimension((byte[])value, (int)0));
            }

            @Override
            public long roundDownToMillis(long value) {
                return DateUtils.toMilliSeconds(value);
            }

            @Override
            public long roundUpToMillis(long value) {
                if (value <= 0L) {
                    return DateUtils.toMilliSeconds(value);
                }
                return DateUtils.toMilliSeconds(value - 1L) + 1L;
            }

            @Override
            protected Query distanceFeatureQuery(String field, float boost, long origin, TimeValue pivot) {
                return LongPoint.newDistanceFeatureQuery((String)field, (float)boost, (long)origin, (long)pivot.getNanos());
            }
        };

        private final String type;
        private final IndexNumericFieldData.NumericType numericType;

        private Resolution(String type, IndexNumericFieldData.NumericType numericType) {
            this.type = type;
            this.numericType = numericType;
        }

        public String type() {
            return this.type;
        }

        IndexNumericFieldData.NumericType numericType() {
            return this.numericType;
        }

        public abstract long convert(Instant var1);

        public abstract Instant toInstant(long var1);

        public abstract Instant clampToValidRange(Instant var1);

        public abstract long parsePointAsMillis(byte[] var1);

        public abstract long roundDownToMillis(long var1);

        public abstract long roundUpToMillis(long var1);

        public static Resolution ofOrdinal(int ord) {
            for (Resolution resolution : Resolution.values()) {
                if (ord != resolution.ordinal()) continue;
                return resolution;
            }
            throw new IllegalArgumentException("unknown resolution ordinal [" + ord + "]");
        }

        protected abstract Query distanceFeatureQuery(String var1, float var2, long var3, TimeValue var5);
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> index = FieldMapper.Parameter.indexParam(m -> DateFieldMapper.access$1100(DateFieldMapper.toType(m)), true);
        private final FieldMapper.Parameter<Boolean> docValues = FieldMapper.Parameter.docValuesParam(m -> DateFieldMapper.access$1000(DateFieldMapper.toType(m)), true);
        private final FieldMapper.Parameter<Boolean> store = FieldMapper.Parameter.storeParam(m -> DateFieldMapper.access$900(DateFieldMapper.toType(m)), false);
        private final FieldMapper.Parameter<Float> boost = FieldMapper.Parameter.boostParam();
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final FieldMapper.Parameter<String> format;
        private final FieldMapper.Parameter<Locale> locale = new FieldMapper.Parameter<Locale>("locale", false, () -> Locale.ROOT, (n, c, o) -> LocaleUtils.parse(o.toString()), m -> DateFieldMapper.access$800(DateFieldMapper.toType(m)));
        private final FieldMapper.Parameter<String> nullValue = FieldMapper.Parameter.stringParam("null_value", false, m -> DateFieldMapper.access$700(DateFieldMapper.toType(m)), null).acceptsNull();
        private final FieldMapper.Parameter<Boolean> ignoreMalformed;
        private final FieldMapper.Parameter<Script> script = FieldMapper.Parameter.scriptParam(m -> DateFieldMapper.access$600(DateFieldMapper.toType(m)));
        private final FieldMapper.Parameter<String> onScriptError = FieldMapper.Parameter.onScriptErrorParam(m -> DateFieldMapper.toType((FieldMapper)m).onScriptError, this.script);
        private final Resolution resolution;
        private final Version indexCreatedVersion;
        private final ScriptCompiler scriptCompiler;

        public Builder(String name, Resolution resolution, DateFormatter dateFormatter, ScriptCompiler scriptCompiler, boolean ignoreMalformedByDefault, Version indexCreatedVersion) {
            super(name);
            this.resolution = resolution;
            this.indexCreatedVersion = indexCreatedVersion;
            this.scriptCompiler = Objects.requireNonNull(scriptCompiler);
            this.ignoreMalformed = FieldMapper.Parameter.boolParam("ignore_malformed", true, m -> DateFieldMapper.toType(m).ignoreMalformed, ignoreMalformedByDefault);
            DateFormatter defaultFormat = resolution == Resolution.NANOSECONDS && indexCreatedVersion.onOrAfter(Version.V_7_0_0) ? DEFAULT_DATE_TIME_NANOS_FORMATTER : DEFAULT_DATE_TIME_FORMATTER;
            this.script.precludesParameters(this.nullValue, this.ignoreMalformed);
            this.addScriptValidation(this.script, this.index, this.docValues);
            this.format = FieldMapper.Parameter.stringParam("format", false, m -> DateFieldMapper.toType(m).format, defaultFormat.pattern());
            if (dateFormatter != null) {
                this.format.setValue(dateFormatter.pattern());
                this.locale.setValue(dateFormatter.locale());
            }
        }

        private DateFormatter buildFormatter() {
            try {
                if (Joda.isJodaPattern(this.indexCreatedVersion, this.format.getValue())) {
                    return Joda.forPattern(this.format.getValue()).withLocale(this.locale.getValue());
                }
                return DateFormatter.forPattern(this.format.getValue()).withLocale(this.locale.getValue());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Error parsing [format] on field [" + this.name() + "]: " + e.getMessage(), e);
            }
        }

        private FieldValues<Long> scriptValues() {
            if (this.script.get() == null) {
                return null;
            }
            DateFieldScript.Factory factory = this.scriptCompiler.compile(this.script.get(), DateFieldScript.CONTEXT);
            return factory == null ? null : (lookup, ctx, doc, consumer) -> factory.newFactory(this.name, this.script.get().getParams(), lookup, this.buildFormatter()).newInstance(ctx).runForDoc(doc, consumer::accept);
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.index, this.docValues, this.store, this.format, this.locale, this.nullValue, this.ignoreMalformed, this.script, this.onScriptError, this.boost, this.meta);
        }

        private Long parseNullValue(DateFieldType fieldType) {
            if (this.nullValue.getValue() == null) {
                return null;
            }
            try {
                return fieldType.parse(this.nullValue.getValue());
            }
            catch (Exception e) {
                DEPRECATION_LOGGER.deprecate(DeprecationCategory.MAPPINGS, "date_mapper_null_field", "Error parsing [" + this.nullValue.getValue() + "] as date in [null_value] on field [" + this.name() + "]); [null_value] will be ignored", new Object[0]);
                return null;
            }
        }

        @Override
        public DateFieldMapper build(ContentPath contentPath) {
            DateFieldType ft = new DateFieldType(this.buildFullName(contentPath), this.index.getValue(), this.store.getValue(), this.docValues.getValue(), this.buildFormatter(), this.resolution, this.nullValue.getValue(), this.scriptValues(), this.meta.getValue());
            ft.setBoost(this.boost.getValue().floatValue());
            Long nullTimestamp = this.parseNullValue(ft);
            return new DateFieldMapper(this.name, ft, this.multiFieldsBuilder.build(this, contentPath), this.copyTo.build(), nullTimestamp, this.resolution, this);
        }
    }

    public static final class DateFieldType
    extends MappedFieldType {
        protected final DateFormatter dateTimeFormatter;
        protected final DateMathParser dateMathParser;
        protected final Resolution resolution;
        protected final String nullValue;
        protected final FieldValues<Long> scriptValues;
        private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance(Locale.ROOT);

        public DateFieldType(String name, boolean isSearchable, boolean isStored, boolean hasDocValues, DateFormatter dateTimeFormatter, Resolution resolution, String nullValue, FieldValues<Long> scriptValues, Map<String, String> meta) {
            super(name, isSearchable, isStored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, meta);
            this.dateTimeFormatter = dateTimeFormatter;
            this.dateMathParser = dateTimeFormatter.toDateMathParser();
            this.resolution = resolution;
            this.nullValue = nullValue;
            this.scriptValues = scriptValues;
        }

        public DateFieldType(String name) {
            this(name, true, false, true, DEFAULT_DATE_TIME_FORMATTER, Resolution.MILLISECONDS, null, null, Collections.emptyMap());
        }

        public DateFieldType(String name, DateFormatter dateFormatter) {
            this(name, true, false, true, dateFormatter, Resolution.MILLISECONDS, null, null, Collections.emptyMap());
        }

        public DateFieldType(String name, Resolution resolution) {
            this(name, true, false, true, DEFAULT_DATE_TIME_FORMATTER, resolution, null, null, Collections.emptyMap());
        }

        public DateFieldType(String name, Resolution resolution, DateFormatter dateFormatter) {
            this(name, true, false, true, dateFormatter, resolution, null, null, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return this.resolution.type();
        }

        public DateFormatter dateTimeFormatter() {
            return this.dateTimeFormatter;
        }

        public Resolution resolution() {
            return this.resolution;
        }

        protected DateMathParser dateMathParser() {
            return this.dateMathParser;
        }

        public long parse(String value) {
            return this.resolution.convert(DateFormatters.from(this.dateTimeFormatter().parse(value), this.dateTimeFormatter().locale()).toInstant());
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            DateFormatter formatter;
            DateFormatter defaultFormatter = this.dateTimeFormatter();
            DateFormatter dateFormatter = formatter = format != null ? DateFormatter.forPattern(format).withLocale(defaultFormatter.locale()) : defaultFormatter;
            if (this.scriptValues != null) {
                return FieldValues.valueFetcher(this.scriptValues, v -> this.format((Long)v, formatter), context);
            }
            return new SourceValueFetcher(this.name(), context, this.nullValue){

                @Override
                public String parseSourceValue(Object value) {
                    String date = value instanceof Number ? NUMBER_FORMAT.format(value) : value.toString();
                    return this.format(this.parse(date), formatter);
                }
            };
        }

        private String format(long timestamp, DateFormatter formatter) {
            ZonedDateTime dateTime = this.resolution().toInstant(timestamp).atZone(ZoneOffset.UTC);
            return formatter.format(dateTime);
        }

        @Override
        public Query termQuery(Object value, @Nullable SearchExecutionContext context) {
            Query query = this.rangeQuery(value, value, true, true, ShapeRelation.INTERSECTS, null, null, context);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, @Nullable ZoneId timeZone, @Nullable DateMathParser forcedDateParser, SearchExecutionContext context) {
            this.failIfNotIndexed();
            if (relation == ShapeRelation.DISJOINT) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support DISJOINT ranges");
            }
            DateMathParser parser = forcedDateParser == null ? this.dateMathParser : forcedDateParser;
            return DateFieldType.dateRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, timeZone, parser, context, this.resolution, (l, u) -> {
                Query query = LongPoint.newRangeQuery((String)this.name(), (long)l, (long)u);
                if (this.hasDocValues()) {
                    Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery((String)this.name(), (long)l, (long)u);
                    query = new IndexOrDocValuesQuery(query, dvQuery);
                    if (context.indexSortedOnField(this.name())) {
                        query = new IndexSortSortedNumericDocValuesRangeQuery(this.name(), l.longValue(), u.longValue(), query);
                    }
                }
                return query;
            });
        }

        public static Query dateRangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable ZoneId timeZone, DateMathParser parser, SearchExecutionContext context, Resolution resolution, BiFunction<Long, Long, Query> builder) {
            return DateFieldType.handleNow(context, nowSupplier -> {
                long u;
                long l;
                if (lowerTerm == null) {
                    l = Long.MIN_VALUE;
                } else {
                    l = DateFieldType.parseToLong(lowerTerm, !includeLower, timeZone, parser, nowSupplier, resolution);
                    if (!includeLower) {
                        ++l;
                    }
                }
                if (upperTerm == null) {
                    u = Long.MAX_VALUE;
                } else {
                    u = DateFieldType.parseToLong(upperTerm, includeUpper, timeZone, parser, nowSupplier, resolution);
                    if (!includeUpper) {
                        --u;
                    }
                }
                return (Query)builder.apply(l, u);
            });
        }

        public static Query handleNow(SearchExecutionContext context, Function<LongSupplier, Query> builder) {
            boolean[] nowUsed = new boolean[1];
            LongSupplier nowSupplier = () -> {
                nowUsed[0] = true;
                return context.nowInMillis();
            };
            Query query = builder.apply(nowSupplier);
            return nowUsed[0] ? new DateRangeIncludingNowQuery(query) : query;
        }

        public long parseToLong(Object value, boolean roundUp, @Nullable ZoneId zone, DateMathParser dateParser, LongSupplier now) {
            dateParser = dateParser == null ? this.dateMathParser() : dateParser;
            return DateFieldType.parseToLong(value, roundUp, zone, dateParser, now, this.resolution);
        }

        public static long parseToLong(Object value, boolean roundUp, @Nullable ZoneId zone, DateMathParser dateParser, LongSupplier now, Resolution resolution) {
            return resolution.convert(dateParser.parse(BytesRefs.toString(value), now, roundUp, zone));
        }

        @Override
        public Query distanceFeatureQuery(Object origin, String pivot, SearchExecutionContext context) {
            long originLong = this.parseToLong(origin, true, null, null, context::nowInMillis);
            TimeValue pivotTime = TimeValue.parseTimeValue((String)pivot, (String)"distance_feature.pivot");
            return this.resolution.distanceFeatureQuery(this.name(), 1.0f, originLong, pivotTime);
        }

        @Override
        public MappedFieldType.Relation isFieldWithinQuery(IndexReader reader, Object from, Object to, boolean includeLower, boolean includeUpper, ZoneId timeZone, DateMathParser dateParser, QueryRewriteContext context) throws IOException {
            if (PointValues.size((IndexReader)reader, (String)this.name()) == 0L) {
                return MappedFieldType.Relation.DISJOINT;
            }
            long minValue = LongPoint.decodeDimension((byte[])PointValues.getMinPackedValue((IndexReader)reader, (String)this.name()), (int)0);
            long maxValue = LongPoint.decodeDimension((byte[])PointValues.getMaxPackedValue((IndexReader)reader, (String)this.name()), (int)0);
            return this.isFieldWithinQuery(minValue, maxValue, from, to, includeLower, includeUpper, timeZone, dateParser, context);
        }

        public MappedFieldType.Relation isFieldWithinQuery(long minValue, long maxValue, Object from, Object to, boolean includeLower, boolean includeUpper, ZoneId timeZone, DateMathParser dateParser, QueryRewriteContext context) throws IOException {
            if (dateParser == null) {
                dateParser = this.dateMathParser;
            }
            long fromInclusive = Long.MIN_VALUE;
            if (from != null) {
                fromInclusive = DateFieldType.parseToLong(from, !includeLower, timeZone, dateParser, context::nowInMillis, this.resolution);
                if (!includeLower) {
                    if (fromInclusive == Long.MAX_VALUE) {
                        return MappedFieldType.Relation.DISJOINT;
                    }
                    ++fromInclusive;
                }
            }
            long toInclusive = Long.MAX_VALUE;
            if (to != null) {
                toInclusive = DateFieldType.parseToLong(to, includeUpper, timeZone, dateParser, context::nowInMillis, this.resolution);
                if (!includeUpper) {
                    if (toInclusive == Long.MIN_VALUE) {
                        return MappedFieldType.Relation.DISJOINT;
                    }
                    --toInclusive;
                }
            }
            if (minValue >= fromInclusive && maxValue <= toInclusive) {
                return MappedFieldType.Relation.WITHIN;
            }
            if (maxValue < fromInclusive || minValue > toInclusive) {
                return MappedFieldType.Relation.DISJOINT;
            }
            return MappedFieldType.Relation.INTERSECTS;
        }

        @Override
        public Function<byte[], Number> pointReaderIfPossible() {
            if (this.isSearchable()) {
                return this.resolution()::parsePointAsMillis;
            }
            return null;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedNumericIndexFieldData.Builder(this.name(), this.resolution.numericType());
        }

        @Override
        public Object valueForDisplay(Object value) {
            Long val = (Long)value;
            if (val == null) {
                return null;
            }
            return this.dateTimeFormatter().format(this.resolution.toInstant(val).atZone(ZoneOffset.UTC));
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
            DateFormatter dateTimeFormatter = this.dateTimeFormatter;
            if (format != null) {
                dateTimeFormatter = DateFormatter.forPattern(format).withLocale(dateTimeFormatter.locale());
            }
            if (timeZone == null) {
                timeZone = ZoneOffset.UTC;
            }
            return new DocValueFormat.DateTime(dateTimeFormatter, timeZone, Resolution.MILLISECONDS);
        }

        static {
            NUMBER_FORMAT.setGroupingUsed(false);
            NUMBER_FORMAT.setMaximumFractionDigits(6);
        }
    }
}

