/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.function.LongUnaryOperator;
import java.util.function.ToLongFunction;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.bucket.composite.PointsSortedDocsProducer;
import org.elasticsearch.search.aggregations.bucket.composite.SingleDimensionValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.SortedDocsProducer;

class LongValuesSource
extends SingleDimensionValuesSource<Long> {
    private final BigArrays bigArrays;
    private final CheckedFunction<LeafReaderContext, SortedNumericDocValues, IOException> docValuesFunc;
    private final LongUnaryOperator rounding;
    private BitArray bits;
    private LongArray values;
    private long currentValue;
    private boolean missingCurrentValue;

    LongValuesSource(BigArrays bigArrays, MappedFieldType fieldType, CheckedFunction<LeafReaderContext, SortedNumericDocValues, IOException> docValuesFunc, LongUnaryOperator rounding, DocValueFormat format, boolean missingBucket, int size, int reverseMul) {
        super(bigArrays, format, fieldType, missingBucket, size, reverseMul);
        this.bigArrays = bigArrays;
        this.docValuesFunc = docValuesFunc;
        this.rounding = rounding;
        this.bits = missingBucket ? new BitArray(Math.min(size, 100), bigArrays) : null;
        this.values = bigArrays.newLongArray(Math.min(size, 100), false);
    }

    @Override
    void copyCurrent(int slot) {
        this.values = this.bigArrays.grow(this.values, (long)(slot + 1));
        if (this.missingBucket && this.missingCurrentValue) {
            this.bits.clear(slot);
        } else {
            assert (!this.missingCurrentValue);
            if (this.missingBucket) {
                this.bits.set(slot);
            }
            this.values.set(slot, this.currentValue);
        }
    }

    @Override
    int compare(int from, int to) {
        if (this.missingBucket) {
            if (!this.bits.get(from)) {
                return this.bits.get(to) ? -1 * this.reverseMul : 0;
            }
            if (!this.bits.get(to)) {
                return this.reverseMul;
            }
        }
        return this.compareValues(this.values.get(from), this.values.get(to));
    }

    @Override
    int compareCurrent(int slot) {
        if (this.missingBucket) {
            if (this.missingCurrentValue) {
                return this.bits.get(slot) ? -1 * this.reverseMul : 0;
            }
            if (!this.bits.get(slot)) {
                return this.reverseMul;
            }
        }
        return this.compareValues(this.currentValue, this.values.get(slot));
    }

    @Override
    int compareCurrentWithAfter() {
        if (this.missingBucket) {
            if (this.missingCurrentValue) {
                return this.afterValue != null ? -1 * this.reverseMul : 0;
            }
            if (this.afterValue == null) {
                return this.reverseMul;
            }
        }
        return this.compareValues(this.currentValue, (Long)this.afterValue);
    }

    @Override
    int hashCode(int slot) {
        if (this.missingBucket && !this.bits.get(slot)) {
            return 0;
        }
        return Long.hashCode(this.values.get(slot));
    }

    @Override
    int hashCodeCurrent() {
        if (this.missingCurrentValue) {
            return 0;
        }
        return Long.hashCode(this.currentValue);
    }

    private int compareValues(long v1, long v2) {
        return Long.compare(v1, v2) * this.reverseMul;
    }

    @Override
    void setAfter(Comparable value) {
        this.afterValue = this.missingBucket && value == null ? null : Long.valueOf(this.format.parseLong(value.toString(), false, () -> {
            throw new IllegalArgumentException("now() is not supported in [after] key");
        }));
    }

    @Override
    Long toComparable(int slot) {
        if (this.missingBucket && !this.bits.get(slot)) {
            return null;
        }
        return this.values.get(slot);
    }

    @Override
    LeafBucketCollector getLeafCollector(LeafReaderContext context, final LeafBucketCollector next) throws IOException {
        final SortedNumericDocValues dvs = (SortedNumericDocValues)this.docValuesFunc.apply((Object)context);
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (dvs.advanceExact(doc)) {
                    int num = dvs.docValueCount();
                    for (int i = 0; i < num; ++i) {
                        LongValuesSource.this.currentValue = dvs.nextValue();
                        LongValuesSource.this.missingCurrentValue = false;
                        next.collect(doc, bucket);
                    }
                } else if (LongValuesSource.this.missingBucket) {
                    LongValuesSource.this.missingCurrentValue = true;
                    next.collect(doc, bucket);
                }
            }
        };
    }

    @Override
    LeafBucketCollector getLeafCollector(Comparable value, LeafReaderContext context, final LeafBucketCollector next) {
        if (value.getClass() != Long.class) {
            throw new IllegalArgumentException("Expected Long, got " + value.getClass());
        }
        this.currentValue = (Long)value;
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                next.collect(doc, bucket);
            }
        };
    }

    private static Query extractQuery(Query query) {
        if (query instanceof BoostQuery) {
            return LongValuesSource.extractQuery(((BoostQuery)query).getQuery());
        }
        if (query instanceof IndexOrDocValuesQuery) {
            return LongValuesSource.extractQuery(((IndexOrDocValuesQuery)query).getIndexQuery());
        }
        if (query instanceof ConstantScoreQuery) {
            return LongValuesSource.extractQuery(((ConstantScoreQuery)query).getQuery());
        }
        return query;
    }

    private static boolean checkMatchAllOrRangeQuery(Query query, String fieldName) {
        if (query == null) {
            return true;
        }
        if (query.getClass() == MatchAllDocsQuery.class) {
            return true;
        }
        if (query instanceof PointRangeQuery) {
            PointRangeQuery pointQuery = (PointRangeQuery)query;
            return fieldName.equals(pointQuery.getField());
        }
        if (query instanceof DocValuesFieldExistsQuery) {
            DocValuesFieldExistsQuery existsQuery = (DocValuesFieldExistsQuery)query;
            return fieldName.equals(existsQuery.getField());
        }
        return false;
    }

    @Override
    SortedDocsProducer createSortedDocsProducerOrNull(IndexReader reader, Query query) {
        byte[] upperPoint;
        byte[] lowerPoint;
        query = LongValuesSource.extractQuery(query);
        if (!this.checkIfSortedDocsIsApplicable(reader, this.fieldType) || !LongValuesSource.checkMatchAllOrRangeQuery(query, this.fieldType.name())) {
            return null;
        }
        if (query instanceof PointRangeQuery) {
            PointRangeQuery rangeQuery = (PointRangeQuery)query;
            lowerPoint = rangeQuery.getLowerPoint();
            upperPoint = rangeQuery.getUpperPoint();
        } else {
            lowerPoint = null;
            upperPoint = null;
        }
        if (this.fieldType instanceof NumberFieldMapper.NumberFieldType) {
            ToLongFunction<byte[]> toBucketFunction;
            NumberFieldMapper.NumberFieldType ft = (NumberFieldMapper.NumberFieldType)this.fieldType;
            switch (ft.typeName()) {
                case "long": {
                    toBucketFunction = value -> this.rounding.applyAsLong(LongPoint.decodeDimension((byte[])value, (int)0));
                    break;
                }
                case "int": 
                case "short": 
                case "byte": {
                    toBucketFunction = value -> this.rounding.applyAsLong(IntPoint.decodeDimension((byte[])value, (int)0));
                    break;
                }
                default: {
                    return null;
                }
            }
            return new PointsSortedDocsProducer(this.fieldType.name(), toBucketFunction, lowerPoint, upperPoint);
        }
        if (this.fieldType instanceof DateFieldMapper.DateFieldType) {
            ToLongFunction<byte[]> decode = ((DateFieldMapper.DateFieldType)this.fieldType).resolution()::parsePointAsMillis;
            ToLongFunction<byte[]> toBucketFunction = value -> this.rounding.applyAsLong(decode.applyAsLong((byte[])value));
            return new PointsSortedDocsProducer(this.fieldType.name(), toBucketFunction, lowerPoint, upperPoint);
        }
        return null;
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.values, this.bits});
    }
}

