/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.stream.Collectors;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.metrics.ParsedPercentiles;
import org.elasticsearch.search.aggregations.metrics.Percentiles;

public class ParsedHDRPercentiles
extends ParsedPercentiles
implements Percentiles {
    private static final ObjectParser<ParsedHDRPercentiles, Void> PARSER = new ObjectParser(ParsedHDRPercentiles.class.getSimpleName(), true, ParsedHDRPercentiles::new);

    @Override
    public String getType() {
        return "hdr_percentiles";
    }

    @Override
    public double percentile(double percent) {
        return this.getPercentile(percent);
    }

    @Override
    public String percentileAsString(double percent) {
        return this.getPercentileAsString(percent);
    }

    public static ParsedHDRPercentiles fromXContent(XContentParser parser, String name) throws IOException {
        ParsedHDRPercentiles aggregation = (ParsedHDRPercentiles)PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    @Override
    public double value(String name) {
        return this.percentile(Double.parseDouble(name));
    }

    @Override
    public Iterable<String> valueNames() {
        return this.percentiles.keySet().stream().map(d -> d.toString()).collect(Collectors.toList());
    }

    static {
        ParsedPercentiles.declarePercentilesFields(PARSER);
    }
}

