/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter;

import java.util.Objects;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.ConversionHelper;
import org.flowable.cmmn.converter.PlanItemDefinitionXmlConverter;
import org.flowable.cmmn.model.CasePageTask;
import org.flowable.cmmn.model.CmmnElement;
import org.flowable.cmmn.model.ExternalWorkerServiceTask;
import org.flowable.cmmn.model.HttpServiceTask;
import org.flowable.cmmn.model.ScriptServiceTask;
import org.flowable.cmmn.model.SendEventServiceTask;
import org.flowable.cmmn.model.ServiceTask;
import org.flowable.cmmn.model.Task;

public class TaskXmlConverter
extends PlanItemDefinitionXmlConverter {
    @Override
    public String getXMLElementName() {
        return "task";
    }

    @Override
    public boolean hasChildElements() {
        return true;
    }

    protected CmmnElement convert(XMLStreamReader xtr, ConversionHelper conversionHelper) {
        Task task = null;
        String type = xtr.getAttributeValue("http://flowable.org/cmmn", "type");
        String className = xtr.getAttributeValue("http://flowable.org/cmmn", "class");
        task = type != null ? (Objects.equals(type, "java") ? this.convertToJavaServiceTask(xtr, className) : (Objects.equals(type, "http") ? this.convertToHttpTask(xtr, className) : (Objects.equals(type, "mail") ? this.convertToMailTask() : (Objects.equals(type, "script") ? this.convertToScriptTask(xtr) : (Objects.equals(type, "casePage") ? this.convertToCasePageTask(xtr) : (Objects.equals(type, "external-worker") ? this.convertToExternalWorkerServiceTask(xtr) : (Objects.equals(type, "send-event") ? this.convertToSendEventTask(xtr) : new Task()))))))) : new Task();
        this.convertCommonTaskAttributes(xtr, task);
        return task;
    }

    protected Task convertToJavaServiceTask(XMLStreamReader xtr, String className) {
        ServiceTask serviceTask = new ServiceTask();
        serviceTask.setType("java");
        String expression = xtr.getAttributeValue("http://flowable.org/cmmn", "expression");
        String delegateExpression = xtr.getAttributeValue("http://flowable.org/cmmn", "delegateExpression");
        if (StringUtils.isNotBlank((CharSequence)className)) {
            serviceTask.setImplementation(className);
            serviceTask.setImplementationType("class");
        } else if (StringUtils.isNotBlank((CharSequence)expression)) {
            serviceTask.setImplementation(expression);
            serviceTask.setImplementationType("expression");
        } else if (StringUtils.isNotBlank((CharSequence)delegateExpression)) {
            serviceTask.setImplementation(delegateExpression);
            serviceTask.setImplementationType("delegateExpression");
        }
        serviceTask.setResultVariableName(xtr.getAttributeValue("http://flowable.org/cmmn", "resultVariableName"));
        serviceTask.setStoreResultVariableAsTransient(Boolean.parseBoolean(xtr.getAttributeValue("http://flowable.org/cmmn", "storeResultVariableAsTransient")));
        return serviceTask;
    }

    protected Task convertToHttpTask(XMLStreamReader xtr, String className) {
        String parallelInSameTransaction;
        HttpServiceTask httpServiceTask = new HttpServiceTask();
        if (StringUtils.isNotBlank((CharSequence)className)) {
            httpServiceTask.setImplementation(className);
        }
        if (StringUtils.isNotEmpty((CharSequence)(parallelInSameTransaction = xtr.getAttributeValue("http://flowable.org/cmmn", "parallelInSameTransaction")))) {
            httpServiceTask.setParallelInSameTransaction(Boolean.valueOf(Boolean.parseBoolean(parallelInSameTransaction)));
        }
        return httpServiceTask;
    }

    protected Task convertToMailTask() {
        ServiceTask serviceTask = new ServiceTask();
        serviceTask.setType("mail");
        return serviceTask;
    }

    protected Task convertToCasePageTask(XMLStreamReader xtr) {
        String candidateGroupsString;
        String candidateUsersString;
        String owner;
        String assignee;
        String icon;
        String label;
        String sameDeploymentAttribute;
        CasePageTask casePageTask = new CasePageTask();
        String formKey = xtr.getAttributeValue("http://flowable.org/cmmn", "formKey");
        if (formKey != null) {
            casePageTask.setFormKey(formKey);
        }
        if ("false".equalsIgnoreCase(sameDeploymentAttribute = xtr.getAttributeValue("http://flowable.org/cmmn", "sameDeployment"))) {
            casePageTask.setSameDeployment(false);
        }
        if ((label = xtr.getAttributeValue("http://flowable.org/cmmn", "label")) != null) {
            casePageTask.setLabel(label);
        }
        if ((icon = xtr.getAttributeValue("http://flowable.org/cmmn", "icon")) != null) {
            casePageTask.setIcon(icon);
        }
        if ((assignee = xtr.getAttributeValue("http://flowable.org/cmmn", "assignee")) != null) {
            casePageTask.setAssignee(assignee);
        }
        if ((owner = xtr.getAttributeValue("http://flowable.org/cmmn", "owner")) != null) {
            casePageTask.setOwner(owner);
        }
        if (StringUtils.isNotEmpty((CharSequence)(candidateUsersString = xtr.getAttributeValue("http://flowable.org/cmmn", "candidateUsers")))) {
            String[] candidateUsers;
            for (String candidateUser : candidateUsers = candidateUsersString.split(",")) {
                casePageTask.getCandidateUsers().add(candidateUser);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(candidateGroupsString = xtr.getAttributeValue("http://flowable.org/cmmn", "candidateGroups")))) {
            String[] candidateGroups;
            for (String candidateGroup : candidateGroups = candidateGroupsString.split(",")) {
                casePageTask.getCandidateGroups().add(candidateGroup);
            }
        }
        return casePageTask;
    }

    protected Task convertToScriptTask(XMLStreamReader xtr) {
        String autoStoreVariables;
        String resVarName;
        ScriptServiceTask scriptTask = new ScriptServiceTask();
        String scriptFormat = xtr.getAttributeValue("http://flowable.org/cmmn", "scriptFormat");
        if (StringUtils.isNotBlank((CharSequence)scriptFormat)) {
            scriptTask.setScriptFormat(scriptFormat.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)(resVarName = xtr.getAttributeValue("http://flowable.org/cmmn", "resultVariableName")))) {
            scriptTask.setResultVariableName(resVarName.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)(autoStoreVariables = xtr.getAttributeValue("http://flowable.org/cmmn", "autoStoreVariables")))) {
            scriptTask.setAutoStoreVariables(Boolean.valueOf(autoStoreVariables).booleanValue());
        }
        return scriptTask;
    }

    protected Task convertToExternalWorkerServiceTask(XMLStreamReader xtr) {
        ExternalWorkerServiceTask externalWorkerTask = new ExternalWorkerServiceTask();
        String topic = xtr.getAttributeValue("http://flowable.org/cmmn", "topic");
        if (topic != null) {
            externalWorkerTask.setTopic(topic);
        }
        return externalWorkerTask;
    }

    protected Task convertToSendEventTask(XMLStreamReader xmlStreamReader) {
        return new SendEventServiceTask();
    }

    protected void convertCommonTaskAttributes(XMLStreamReader xtr, Task task) {
        String isAsyncLeaveString;
        String isExclusiveString;
        String isAsyncString;
        String isBlockingExpressionString;
        task.setName(xtr.getAttributeValue(null, "name"));
        String isBlockingString = xtr.getAttributeValue(null, "isBlocking");
        if (StringUtils.isNotEmpty((CharSequence)isBlockingString)) {
            task.setBlocking(Boolean.valueOf(isBlockingString).booleanValue());
        }
        if (StringUtils.isNotEmpty((CharSequence)(isBlockingExpressionString = xtr.getAttributeValue("http://flowable.org/cmmn", "isBlockingExpression")))) {
            task.setBlockingExpression(isBlockingExpressionString);
        }
        if (StringUtils.isNotEmpty((CharSequence)(isAsyncString = xtr.getAttributeValue("http://flowable.org/cmmn", "async")))) {
            task.setAsync(Boolean.valueOf(isAsyncString.toLowerCase()).booleanValue());
        }
        if (StringUtils.isNotEmpty((CharSequence)(isExclusiveString = xtr.getAttributeValue("http://flowable.org/cmmn", "exclusive")))) {
            task.setExclusive(Boolean.valueOf(isExclusiveString).booleanValue());
        }
        if (StringUtils.isNotEmpty((CharSequence)(isAsyncLeaveString = xtr.getAttributeValue("http://flowable.org/cmmn", "asyncLeave")))) {
            task.setAsyncLeave(Boolean.valueOf(isAsyncLeaveString.toLowerCase()).booleanValue());
        }
    }
}

