/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractChangePlanItemInstanceStateOperation;
import org.flowable.cmmn.engine.impl.listener.PlanItemLifeCycleListenerUtil;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.runtime.StateTransition;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public abstract class AbstractDeletePlanItemInstanceOperation
extends AbstractChangePlanItemInstanceStateOperation {
    public AbstractDeletePlanItemInstanceOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        super(commandContext, planItemInstanceEntity);
    }

    @Override
    public void run() {
        super.run();
        boolean isRepeating = this.isRepeatingOnDelete();
        if (isRepeating) {
            PlanItemInstanceEntity newPlanItemInstanceEntity = this.copyAndInsertPlanItemInstance(this.commandContext, this.planItemInstanceEntity, true);
            String oldState = newPlanItemInstanceEntity.getState();
            String newState = "wait_repetition";
            newPlanItemInstanceEntity.setState(newState);
            PlanItemLifeCycleListenerUtil.callLifeCycleListeners(this.commandContext, (PlanItemInstance)newPlanItemInstanceEntity, oldState, newState);
            CommandContextUtil.getAgenda(this.commandContext).planCreatePlanItemInstanceForRepetitionOperation(newPlanItemInstanceEntity);
            CommandContextUtil.getAgenda(this.commandContext).planActivatePlanItemInstanceOperation(newPlanItemInstanceEntity);
        }
        this.deleteSentryPartInstances();
        CommandContextUtil.getPlanItemInstanceEntityManager(this.commandContext).delete(this.planItemInstanceEntity);
    }

    @Override
    protected abstract void internalExecute();

    protected boolean isRepeatingOnDelete() {
        PlanItem planItem = this.planItemInstanceEntity.getPlanItem();
        if (this.isEvaluateRepetitionRule() && this.isPlanItemRepeatableOnComplete(planItem)) {
            return this.evaluateRepetitionRule(this.planItemInstanceEntity);
        }
        return false;
    }

    protected void exitChildPlanItemInstances() {
        for (PlanItemInstanceEntity child : this.planItemInstanceEntity.getChildPlanItemInstances()) {
            if (!StateTransition.isPossible((PlanItemInstance)child, "exit")) continue;
            CommandContextUtil.getAgenda(this.commandContext).planExitPlanItemInstanceOperation(child);
        }
    }

    protected abstract boolean isEvaluateRepetitionRule();
}

