/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.listener;

import java.util.List;
import java.util.Objects;
import org.flowable.cmmn.api.listener.PlanItemInstanceLifeCycleListener;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class PlanItemLifeCycleListenerUtil {
    public static void callLifeCycleListeners(CommandContext commandContext, PlanItemInstance planItemInstance, String oldState, String newState) {
        if (Objects.equals(oldState, newState)) {
            return;
        }
        List<PlanItemInstanceLifeCycleListener> planItemInstanceLifeCycleListeners = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getPlanItemInstanceLifeCycleListeners();
        if (planItemInstanceLifeCycleListeners != null && !planItemInstanceLifeCycleListeners.isEmpty()) {
            for (PlanItemInstanceLifeCycleListener lifeCycleListener : planItemInstanceLifeCycleListeners) {
                if (!PlanItemLifeCycleListenerUtil.lifeCycleListenerMatches(lifeCycleListener, planItemInstance, oldState, newState)) continue;
                lifeCycleListener.stateChanged(planItemInstance, oldState, newState);
            }
        }
    }

    protected static boolean lifeCycleListenerMatches(PlanItemInstanceLifeCycleListener lifeCycleListener, PlanItemInstance planItemInstance, String oldState, String newState) {
        return PlanItemLifeCycleListenerUtil.itemDefinitionTypeMatches(planItemInstance, lifeCycleListener.getItemDefinitionTypes()) && PlanItemLifeCycleListenerUtil.stateMatches(lifeCycleListener.getSourceState(), oldState) && PlanItemLifeCycleListenerUtil.stateMatches(lifeCycleListener.getTargetState(), newState);
    }

    protected static boolean itemDefinitionTypeMatches(PlanItemInstance planItemInstance, List<String> itemDefinitionTypes) {
        return itemDefinitionTypes == null || itemDefinitionTypes.isEmpty() || itemDefinitionTypes.contains(planItemInstance.getPlanItemDefinitionType());
    }

    protected static boolean stateMatches(String listenerExpectedState, String actualState) {
        return listenerExpectedState == null || Objects.equals(actualState, listenerExpectedState);
    }
}

