/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.el.function;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.el.function.AbstractFlowableShortHandExpressionFunction;
import org.flowable.variable.api.delegate.VariableScope;

public abstract class AbstractFlowableVariableExpressionFunction
extends AbstractFlowableShortHandExpressionFunction {
    private static final List<String> FUNCTION_PREFIXES = Arrays.asList("variables", "vars", "var");
    private static final String FINAL_FUNCTION_PREFIX = "variables";

    public AbstractFlowableVariableExpressionFunction(String variableScopeName, String functionName) {
        this(variableScopeName, Collections.singletonList(functionName), functionName);
    }

    public AbstractFlowableVariableExpressionFunction(String variableScopeName, List<String> functionNameOptions, String functionName) {
        super(variableScopeName, functionNameOptions, functionName);
    }

    @Override
    protected List<String> getFunctionPrefixOptions() {
        return FUNCTION_PREFIXES;
    }

    @Override
    protected String getFinalFunctionPrefix() {
        return FINAL_FUNCTION_PREFIX;
    }

    @Override
    protected boolean isMultiParameterFunction() {
        return true;
    }

    @Override
    public String prefix() {
        return FINAL_FUNCTION_PREFIX;
    }

    protected static Object getVariableValue(VariableScope variableScope, String variableName) {
        if (variableName == null) {
            throw new FlowableIllegalArgumentException("Variable name passed is null");
        }
        return variableScope.getVariable(variableName);
    }

    protected static boolean valuesAreNumbers(Object variableValue, Object actualValue) {
        return actualValue instanceof Number && variableValue instanceof Number;
    }
}

