/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.spring.kafka;

import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.api.InboundEvent;
import org.flowable.eventregistry.model.InboundChannelModel;
import org.flowable.eventregistry.spring.kafka.KafkaConsumerRecordInboundEvent;
import org.springframework.kafka.listener.AcknowledgingConsumerAwareMessageListener;
import org.springframework.kafka.support.Acknowledgment;

public class KafkaChannelMessageListenerAdapter
implements AcknowledgingConsumerAwareMessageListener<Object, Object> {
    protected EventRegistry eventRegistry;
    protected InboundChannelModel inboundChannelModel;

    public KafkaChannelMessageListenerAdapter(EventRegistry eventRegistry, InboundChannelModel inboundChannelModel) {
        this.eventRegistry = eventRegistry;
        this.inboundChannelModel = inboundChannelModel;
    }

    public void onMessage(ConsumerRecord<Object, Object> data, Acknowledgment acknowledgment, Consumer<?, ?> consumer) {
        this.eventRegistry.eventReceived(this.inboundChannelModel, (InboundEvent)new KafkaConsumerRecordInboundEvent(data));
        if (acknowledgment != null) {
            acknowledgment.acknowledge();
        }
    }

    public EventRegistry getEventRegistry() {
        return this.eventRegistry;
    }

    public void setEventRegistry(EventRegistry eventRegistry) {
        this.eventRegistry = eventRegistry;
    }

    public InboundChannelModel getInboundChannelModel() {
        return this.inboundChannelModel;
    }

    public void setInboundChannelModel(InboundChannelModel inboundChannelModel) {
        this.inboundChannelModel = inboundChannelModel;
    }
}

