/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.idm.api.User;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.domain.AppDefinition;
import org.flowable.ui.modeler.domain.AppModelDefinition;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.domain.ModelHistory;
import org.flowable.ui.modeler.model.AppDefinitionRepresentation;
import org.flowable.ui.modeler.model.AppDefinitionSaveRepresentation;
import org.flowable.ui.modeler.model.AppDefinitionUpdateResultRepresentation;
import org.flowable.ui.modeler.repository.ModelHistoryRepository;
import org.flowable.ui.modeler.repository.ModelRepository;
import org.flowable.ui.modeler.service.AppDefinitionPublishService;
import org.flowable.ui.modeler.serviceapi.AppDefinitionService;
import org.flowable.ui.modeler.serviceapi.AppDefinitionServiceRepresentation;
import org.flowable.ui.modeler.serviceapi.ModelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AppDefinitionServiceImpl
implements AppDefinitionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppDefinitionServiceImpl.class);
    @Autowired
    protected AppDefinitionPublishService appDefinitionPublishService;
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected ModelRepository modelRepository;
    @Autowired
    protected ModelHistoryRepository modelHistoryRepository;
    @Autowired
    protected ObjectMapper objectMapper;

    @Override
    public AppDefinitionRepresentation getAppDefinition(String modelId) {
        Model model = this.modelService.getModel(modelId);
        return this.createAppDefinitionRepresentation(model);
    }

    @Override
    public AppDefinitionRepresentation getAppDefinitionHistory(String modelId, String modelHistoryId) {
        ModelHistory model = this.modelService.getModelHistory(modelId, modelHistoryId);
        return this.createAppDefinitionRepresentation(model);
    }

    @Override
    public List<AppDefinitionServiceRepresentation> getAppDefinitions() {
        HashMap<String, Model> modelMap = new HashMap<String, Model>();
        ArrayList<AppDefinitionServiceRepresentation> resultList = new ArrayList<AppDefinitionServiceRepresentation>();
        List<Model> createdByModels = this.modelRepository.findByModelType(3, "nameAsc");
        for (AbstractModel model : createdByModels) {
            modelMap.put(model.getId(), (Model)model);
        }
        for (AbstractModel model : modelMap.values()) {
            resultList.add(this.createAppDefinition(model));
        }
        return resultList;
    }

    @Override
    public List<AppDefinitionServiceRepresentation> getDeployableAppDefinitions(User user) {
        HashMap<String, ModelHistory> modelMap = new HashMap<String, ModelHistory>();
        ArrayList<AppDefinitionServiceRepresentation> resultList = new ArrayList<AppDefinitionServiceRepresentation>();
        List<ModelHistory> createdByModels = this.modelHistoryRepository.findByModelTypAndCreatedBy(user.getId(), 3);
        for (ModelHistory modelHistory : createdByModels) {
            if (modelMap.containsKey(modelHistory.getModelId())) {
                if (modelHistory.getVersion() <= ((ModelHistory)modelMap.get(modelHistory.getModelId())).getVersion()) continue;
                modelMap.put(modelHistory.getModelId(), modelHistory);
                continue;
            }
            modelMap.put(modelHistory.getModelId(), modelHistory);
        }
        for (ModelHistory model : modelMap.values()) {
            Model latestModel = this.modelRepository.get(model.getModelId());
            if (latestModel == null) continue;
            resultList.add(this.createAppDefinition(model));
        }
        return resultList;
    }

    @Override
    public AppDefinitionUpdateResultRepresentation updateAppDefinition(String modelId, AppDefinitionSaveRepresentation updatedModel) {
        AppDefinitionUpdateResultRepresentation result = new AppDefinitionUpdateResultRepresentation();
        User user = SecurityUtils.getCurrentUserObject();
        Model model = this.modelService.getModel(modelId);
        model.setName(updatedModel.getAppDefinition().getName());
        model.setKey(updatedModel.getAppDefinition().getKey());
        model.setDescription(updatedModel.getAppDefinition().getDescription());
        String editorJson = null;
        try {
            editorJson = this.objectMapper.writeValueAsString((Object)updatedModel.getAppDefinition().getDefinition());
        }
        catch (Exception e) {
            LOGGER.error("Error while processing app definition json {}", (Object)modelId, (Object)e);
            throw new InternalServerErrorException("App definition could not be saved " + modelId);
        }
        model = this.modelService.saveModel(model, editorJson, null, false, null, user);
        AppDefinitionRepresentation appDefinition = this.createAppDefinitionRepresentation(model);
        if (updatedModel.isPublish()) {
            this.appDefinitionPublishService.publishAppDefinition(null, model, user);
        } else {
            appDefinition.setDefinition(updatedModel.getAppDefinition().getDefinition());
        }
        result.setAppDefinition(appDefinition);
        return result;
    }

    protected AppDefinitionServiceRepresentation createAppDefinition(AbstractModel model) {
        AppDefinitionServiceRepresentation resultInfo = new AppDefinitionServiceRepresentation();
        if (model instanceof ModelHistory) {
            resultInfo.setId(((ModelHistory)model).getModelId());
        } else {
            resultInfo.setId(model.getId());
        }
        resultInfo.setName(model.getName());
        resultInfo.setDescription(model.getDescription());
        resultInfo.setVersion(model.getVersion());
        resultInfo.setDefinition(model.getModelEditorJson());
        AppDefinition appDefinition = null;
        try {
            appDefinition = (AppDefinition)this.objectMapper.readValue(model.getModelEditorJson(), AppDefinition.class);
        }
        catch (Exception e) {
            LOGGER.error("Error deserializing app {}", (Object)model.getId(), (Object)e);
            throw new InternalServerErrorException("Could not deserialize app definition");
        }
        if (appDefinition != null) {
            resultInfo.setTheme(appDefinition.getTheme());
            resultInfo.setIcon(appDefinition.getIcon());
            List<AppModelDefinition> models = appDefinition.getModels();
            if (CollectionUtils.isNotEmpty(models)) {
                ArrayList<String> modelIds = new ArrayList<String>();
                for (AppModelDefinition appModelDef : models) {
                    modelIds.add(appModelDef.getId());
                }
                resultInfo.setModels(modelIds);
            }
        }
        return resultInfo;
    }

    protected AppDefinitionRepresentation createAppDefinitionRepresentation(AbstractModel model) {
        AppDefinition appDefinition = null;
        try {
            appDefinition = (AppDefinition)this.objectMapper.readValue(model.getModelEditorJson(), AppDefinition.class);
        }
        catch (Exception e) {
            LOGGER.error("Error deserializing app {}", (Object)model.getId(), (Object)e);
            throw new InternalServerErrorException("Could not deserialize app definition");
        }
        AppDefinitionRepresentation result = new AppDefinitionRepresentation(model);
        result.setDefinition(appDefinition);
        return result;
    }
}

