/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class ServiceParameters {
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    protected Set<String> validParameterNames;

    public void addParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public void addValidParameter(String name, Object value) {
        this.parameters.put(name, value);
        this.validParameterNames.add(name);
    }

    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    public boolean isParameterSet(String name) {
        return this.parameters.containsKey(name);
    }

    public void addValidParameterNames(String[] validParameters) {
        if (this.validParameterNames == null) {
            this.validParameterNames = new HashSet<String>();
        }
        this.validParameterNames.addAll(Arrays.asList(validParameters));
    }

    public Map<String, Object> getValidParameterMap() {
        if (this.validParameterNames == null) {
            return Collections.unmodifiableMap(this.parameters);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> parameter : this.parameters.entrySet()) {
            if (!this.validParameterNames.contains(parameter.getKey())) continue;
            result.put(parameter.getKey(), parameter.getValue());
        }
        return result;
    }

    public static ServiceParameters fromHttpRequest(HttpServletRequest request) {
        ServiceParameters parameters = new ServiceParameters();
        String value = null;
        String name = null;
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            name = (String)params.nextElement();
            value = request.getParameter(name);
            if (value == null || !StringUtils.isNotEmpty((CharSequence)value)) continue;
            parameters.addParameter(name, value);
        }
        return parameters;
    }

    public static ServiceParameters fromObjectNode(ObjectNode node) {
        ServiceParameters parameters = new ServiceParameters();
        Iterator ir = node.fieldNames();
        String name = null;
        JsonNode value = null;
        while (ir.hasNext()) {
            name = (String)ir.next();
            value = node.get(name);
            if (value == null) continue;
            if (value.isNumber()) {
                parameters.addParameter(name, value.numberValue());
                continue;
            }
            if (value.isBoolean()) {
                parameters.addParameter(name, value.booleanValue());
                continue;
            }
            if (!value.isTextual()) continue;
            parameters.addParameter(name, value.textValue());
        }
        return parameters;
    }
}

