/*
 * Copyright (c) 1997, 2020 Oracle and/or its affiliates.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0, or the Eclipse Distribution License
 * v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License v2.0
 * w/Classpath exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause OR GPL-2.0 WITH
 * Classpath-exception-2.0
 */

package org.omg.CORBA;


/**
* Interfaces derived from the <tt>Current</tt> interface enable ORB and CORBA
* services to provide access to information (context) associated with
* the thread of execution in which they are running. This information 
* is accessed in a structured manner using interfaces derived from the
* <tt>Current</tt> interface defined in the CORBA module.
*
* <P>Each ORB or CORBA service that needs its own context derives an
* interface from the CORBA module's <tt>Current</tt>. Users of the
* service can obtain an instance of the appropriate <tt>Current</tt>
* interface by invoking <tt>ORB::resolve_initial_references</tt>.<P>
*
* org/omg/CORBA/Current.java
* Generated by the IDL-to-Java compiler (portable), version "3.0"
* from ../../../../../src/share/classes/org/omg/PortableServer/corba.idl
* Saturday, July 17, 1999 12:26:21 AM PDT.
*/

public interface Current extends CurrentOperations, org.omg.CORBA.Object, org.omg.CORBA.portable.IDLEntity 
{
} // interface Current
