/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.impl;

import com.sun.enterprise.module.common_impl.FlattenEnumeration;
import com.sun.enterprise.module.impl.ClassLoaderFacade;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;

public class ClassLoaderProxy
extends URLClassLoader {
    private final List<ClassLoader> surrogates = new CopyOnWriteArrayList<ClassLoader>();
    private final List<ClassLoaderFacade> facadeSurrogates = new CopyOnWriteArrayList<ClassLoaderFacade>();

    public ClassLoaderProxy(URL[] shared, ClassLoader parent) {
        super(shared, parent);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.stop();
    }

    protected Class<?> loadClass(String name, boolean resolve, boolean followImports) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                if (this.getParent() != null) {
                    c = this.getParent().loadClass(name);
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (c == null) {
                c = this.findClass(name, followImports);
            }
            if (resolve) {
                this.resolveClass(c);
            }
        } else {
            if (c.getClassLoader() == this) {
                return c;
            }
            throw new ClassNotFoundException(name);
        }
        return c;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.findClass(name, true);
    }

    protected Class<?> findClass(String name, boolean followImports) throws ClassNotFoundException {
        try {
            return this.findClassDirect(name);
        }
        catch (ClassNotFoundException cfne) {
            if (followImports) {
                Class<?> c = null;
                for (ClassLoaderFacade classLoaderFacade : this.facadeSurrogates) {
                    try {
                        c = classLoaderFacade.getClass(name);
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                    if (c == null) continue;
                    return c;
                }
                for (ClassLoader classLoader : this.surrogates) {
                    try {
                        c = classLoader.loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                    if (c == null) continue;
                    return c;
                }
            }
            throw cfne;
        }
    }

    synchronized Class findClassDirect(String name) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        try {
            return super.findClass(name);
        }
        catch (NoClassDefFoundError e) {
            throw new ClassNotFoundException(e.getMessage());
        }
    }

    @Override
    public URL findResource(String name) {
        URL url = super.findResource(name);
        if (url != null) {
            return url;
        }
        for (ClassLoaderFacade classLoaderFacade : this.facadeSurrogates) {
            url = classLoaderFacade.findResourceDirect(name);
            if (url == null) continue;
            return url;
        }
        for (ClassLoader classLoader : this.surrogates) {
            url = classLoader.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public URL findResourceDirect(String name) {
        return super.findResource(name);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Vector<Enumeration<URL>> sources = new Vector<Enumeration<URL>>();
        Enumeration<URL> enumerat = super.findResources(name);
        if (enumerat != null && enumerat.hasMoreElements()) {
            sources.add(enumerat);
        }
        for (ClassLoaderFacade classLoaderFacade : this.facadeSurrogates) {
            enumerat = classLoaderFacade.getResources(name);
            if (enumerat == null || !enumerat.hasMoreElements()) continue;
            sources.add(enumerat);
        }
        for (ClassLoader classLoader : this.surrogates) {
            enumerat = classLoader.getResources(name);
            if (enumerat == null || !enumerat.hasMoreElements()) continue;
            sources.add(enumerat);
        }
        return new FlattenEnumeration<URL>(sources.elements());
    }

    public void addDelegate(ClassLoader cl) {
        if (cl instanceof ClassLoaderFacade) {
            this.facadeSurrogates.add((ClassLoaderFacade)cl);
        } else {
            this.surrogates.add(cl);
        }
    }

    public void removeDelegate(ClassLoader cl) {
        if (cl instanceof ClassLoaderFacade) {
            this.facadeSurrogates.remove(cl);
        } else {
            this.surrogates.remove(cl);
        }
    }

    public Collection<ClassLoader> getDelegates() {
        return new ArrayList<ClassLoader>(this.surrogates);
    }

    public void stop() {
        this.surrogates.clear();
        this.facadeSurrogates.clear();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(",URls[]=");
        for (URL url : this.getURLs()) {
            s.append(url).append(",");
        }
        s.append(")");
        for (ClassLoader surrogate : this.surrogates) {
            s.append("\n ref : ").append(surrogate.toString());
        }
        return s.toString();
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }
}

