/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import org.jeasy.random.ArrayPopulator;
import org.jeasy.random.CollectionPopulator;
import org.jeasy.random.EasyRandom;
import org.jeasy.random.MapPopulator;
import org.jeasy.random.ObjectCreationException;
import org.jeasy.random.OptionalPopulator;
import org.jeasy.random.RandomizationContext;
import org.jeasy.random.RandomizationContextStackItem;
import org.jeasy.random.api.ContextAwareRandomizer;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.api.RandomizerProvider;
import org.jeasy.random.randomizers.misc.SkipRandomizer;
import org.jeasy.random.util.ReflectionUtils;

class FieldPopulator {
    private final EasyRandom easyRandom;
    private final ArrayPopulator arrayPopulator;
    private final CollectionPopulator collectionPopulator;
    private final MapPopulator mapPopulator;
    private final OptionalPopulator optionalPopulator;
    private final RandomizerProvider randomizerProvider;

    FieldPopulator(EasyRandom easyRandom, RandomizerProvider randomizerProvider, ArrayPopulator arrayPopulator, CollectionPopulator collectionPopulator, MapPopulator mapPopulator, OptionalPopulator optionalPopulator) {
        this.easyRandom = easyRandom;
        this.randomizerProvider = randomizerProvider;
        this.arrayPopulator = arrayPopulator;
        this.collectionPopulator = collectionPopulator;
        this.mapPopulator = mapPopulator;
        this.optionalPopulator = optionalPopulator;
    }

    void populateField(Object target, Field field, RandomizationContext context) throws IllegalAccessException {
        Randomizer<?> randomizer = this.getRandomizer(field, context);
        if (randomizer instanceof SkipRandomizer) {
            return;
        }
        context.pushStackItem(new RandomizationContextStackItem(target, field));
        if (randomizer instanceof ContextAwareRandomizer) {
            ((ContextAwareRandomizer)randomizer).setRandomizerContext(context);
        }
        if (!context.hasExceededRandomizationDepth()) {
            Object value;
            if (randomizer != null) {
                value = randomizer.getRandomValue();
            } else {
                try {
                    value = this.generateRandomValue(field, context);
                }
                catch (ObjectCreationException e) {
                    String exceptionMessage = String.format("Unable to create type: %s for field: %s of class: %s", field.getType().getName(), field.getName(), target.getClass().getName());
                    throw new ObjectCreationException(exceptionMessage, e);
                }
            }
            if (context.getParameters().isBypassSetters()) {
                ReflectionUtils.setFieldValue(target, field, value);
            } else {
                try {
                    ReflectionUtils.setProperty(target, field, value);
                }
                catch (InvocationTargetException e) {
                    String exceptionMessage = String.format("Unable to invoke setter for field %s of class %s", field.getName(), target.getClass().getName());
                    throw new ObjectCreationException(exceptionMessage, e.getCause());
                }
            }
        }
        context.popStackItem();
    }

    private Randomizer<?> getRandomizer(Field field, RandomizationContext context) {
        Randomizer<?> randomizer = this.randomizerProvider.getRandomizerByField(field, context);
        if (randomizer == null) {
            Type genericType = field.getGenericType();
            if (ReflectionUtils.isTypeVariable(genericType)) {
                Class<?> type = this.getParametrizedType(field, context);
                randomizer = this.randomizerProvider.getRandomizerByType(type, context);
            } else {
                randomizer = this.randomizerProvider.getRandomizerByType(field.getType(), context);
            }
        }
        return randomizer;
    }

    private Object generateRandomValue(Field field, RandomizationContext context) {
        Class<?> fieldType = field.getType();
        Type fieldGenericType = field.getGenericType();
        if (ReflectionUtils.isArrayType(fieldType)) {
            return this.arrayPopulator.getRandomArray(fieldType, context);
        }
        if (ReflectionUtils.isCollectionType(fieldType)) {
            return this.collectionPopulator.getRandomCollection(field, context);
        }
        if (ReflectionUtils.isMapType(fieldType)) {
            return this.mapPopulator.getRandomMap(field, context);
        }
        if (ReflectionUtils.isOptionalType(fieldType)) {
            return this.optionalPopulator.getRandomOptional(field, context);
        }
        if (context.getParameters().isScanClasspathForConcreteTypes() && ReflectionUtils.isAbstract(fieldType) && !ReflectionUtils.isEnumType(fieldType)) {
            List<Class<?>> parameterizedTypes = ReflectionUtils.filterSameParameterizedTypes(ReflectionUtils.getPublicConcreteSubTypesOf(fieldType), fieldGenericType);
            if (parameterizedTypes.isEmpty()) {
                throw new ObjectCreationException("Unable to find a matching concrete subtype of type: " + fieldType);
            }
            Class<?> randomConcreteSubType = parameterizedTypes.get(this.easyRandom.nextInt(parameterizedTypes.size()));
            return this.easyRandom.doPopulateBean(randomConcreteSubType, context);
        }
        Type genericType = field.getGenericType();
        if (ReflectionUtils.isTypeVariable(genericType)) {
            Class<?> type = this.getParametrizedType(field, context);
            return this.easyRandom.doPopulateBean(type, context);
        }
        return this.easyRandom.doPopulateBean(fieldType, context);
    }

    private Class<?> getParametrizedType(Field field, RandomizationContext context) {
        Class<?> aClass;
        Class<?> declaringClass = field.getDeclaringClass();
        TypeVariable<Class<?>>[] typeParameters = declaringClass.getTypeParameters();
        Type genericSuperclass = this.getGenericSuperClass(context);
        ParameterizedType parameterizedGenericSuperType = (ParameterizedType)genericSuperclass;
        Type[] actualTypeArguments = parameterizedGenericSuperType.getActualTypeArguments();
        Type actualTypeArgument = null;
        for (int i = 0; i < typeParameters.length; ++i) {
            if (!field.getGenericType().equals(typeParameters[i])) continue;
            actualTypeArgument = actualTypeArguments[i];
        }
        if (actualTypeArgument == null) {
            return field.getClass();
        }
        String typeName = null;
        try {
            typeName = actualTypeArgument.getTypeName();
            aClass = Class.forName(typeName);
        }
        catch (ClassNotFoundException e) {
            String message = String.format("Unable to load class %s of generic field %s in class %s. Please refer to the documentation as this generic type may not be supported for randomization.", typeName, field.getName(), field.getDeclaringClass().getName());
            throw new ObjectCreationException(message, e);
        }
        return aClass;
    }

    private Type getGenericSuperClass(RandomizationContext context) {
        Class<?> targetType = context.getTargetType();
        Type genericSuperclass = targetType.getGenericSuperclass();
        while (targetType != null && !(genericSuperclass instanceof ParameterizedType)) {
            if ((targetType = targetType.getSuperclass()) == null) continue;
            genericSuperclass = targetType.getGenericSuperclass();
        }
        return genericSuperclass;
    }
}

