/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.time;

import java.time.Month;
import java.time.Period;
import java.time.Year;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.randomizers.misc.EnumRandomizer;
import org.jeasy.random.randomizers.time.DayRandomizer;
import org.jeasy.random.randomizers.time.YearRandomizer;

public class PeriodRandomizer
implements Randomizer<Period> {
    private final YearRandomizer yearRandomizer;
    private final EnumRandomizer<Month> monthRandomizer;
    private final DayRandomizer dayRandomizer;

    public PeriodRandomizer() {
        this.yearRandomizer = new YearRandomizer();
        this.monthRandomizer = new EnumRandomizer<Month>(Month.class);
        this.dayRandomizer = new DayRandomizer();
    }

    public PeriodRandomizer(long seed) {
        this.yearRandomizer = new YearRandomizer(seed);
        this.monthRandomizer = new EnumRandomizer<Month>(Month.class, seed);
        this.dayRandomizer = new DayRandomizer(seed);
    }

    @Deprecated
    public static PeriodRandomizer aNewPeriodRandomizer() {
        return new PeriodRandomizer();
    }

    @Deprecated
    public static PeriodRandomizer aNewPeriodRandomizer(long seed) {
        return new PeriodRandomizer(seed);
    }

    @Override
    public Period getRandomValue() {
        Year randomYear = this.yearRandomizer.getRandomValue();
        Month randomMonth = (Month)this.monthRandomizer.getRandomValue();
        int randomDay = this.dayRandomizer.getRandomValue();
        return Period.of(randomYear.getValue(), randomMonth.getValue(), randomDay);
    }
}

