/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.constant;

public enum ErrorCode {
    OK(100, "\u64cd\u4f5c\u6210\u529f"),
    FAIL(101, "\u64cd\u4f5c\u5931\u8d25"),
    ALERT(102, "alert"),
    ERROR(5000, "error");

    private int code;
    private String message;

    private ErrorCode() {
    }

    private ErrorCode(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public static ErrorCode getResultEnum(int code) {
        for (ErrorCode errorCode : ErrorCode.values()) {
            if (errorCode.getCode() != code) continue;
            return errorCode;
        }
        return ERROR;
    }

    public static ErrorCode getResultEnum(String message) {
        for (ErrorCode errorCode : ErrorCode.values()) {
            if (!errorCode.getMessage().equals(message)) continue;
            return errorCode;
        }
        return ERROR;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }
}

