/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.util;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class ViewFreemarker
implements InitializingBean {
    static final Logger logger = LoggerFactory.getLogger(ViewFreemarker.class);
    private static Configuration _tplConfig = new Configuration();

    private static String parseTemplate(String tplName, String encoding, Map<String, Object> paras) {
        try {
            StringWriter stringWriter = new StringWriter();
            Template template = null;
            template = _tplConfig.getTemplate(tplName, encoding);
            template.process(paras, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return exception.toString();
        }
    }

    public static void view(HttpServletRequest request, HttpServletResponse response, String template, Map<String, Object> paras) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Freemarker loading\uff1a" + template);
        }
        if (paras == null) {
            paras = new HashMap<String, Object>();
        }
        paras.put("request", request);
        paras.put("response", response);
        String string = ViewFreemarker.parseTemplate(template, "UTF-8", paras);
        ViewFreemarker.outputToPage(request, response, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void outputToPage(HttpServletRequest request, HttpServletResponse response, String content) throws Exception {
        response.setContentType("text/html");
        response.setHeader("Cache-Control", "no-store");
        response.setHeader("Content-Type", "text/html;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        PrintWriter printWriter = null;
        try {
            if (!response.isCommitted()) {
                printWriter = response.getWriter();
                printWriter.println(content);
                printWriter.flush();
                printWriter.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void afterPropertiesSet() throws Exception {
    }

    static {
        _tplConfig.setClassForTemplateLoading(ViewFreemarker.class, "/templates");
        _tplConfig.setDefaultEncoding("UTF-8");
    }
}

