/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class oConvertUtils {
    private static final Logger log = LoggerFactory.getLogger(oConvertUtils.class);

    public static boolean isEmptyString(CharSequence str) {
        return str == null || str.length() == 0 || str == "null" || str == "";
    }

    public static boolean isEmptyMap(Map<?, ?> map) {
        return null == map || map.isEmpty();
    }

    public static boolean isEmptyIterable(Iterable<?> iterable) {
        return null == iterable || oConvertUtils.isEmpty(iterable.iterator());
    }

    public static boolean isEmptyIterator(Iterator<?> Iterator2) {
        return null == Iterator2 || false == Iterator2.hasNext();
    }

    public static boolean isArray(Object obj) {
        if (null == obj) {
            return false;
        }
        return obj.getClass().isArray();
    }

    public static boolean isEmptyArray(Object array) {
        if (null == array) {
            return true;
        }
        if (oConvertUtils.isArray(array)) {
            return 0 == Array.getLength(array);
        }
        throw new JimuReportException("Object to provide is not a Array !");
    }

    public static boolean isEmpty(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return oConvertUtils.isEmptyString((CharSequence)obj);
        }
        if (obj instanceof Map) {
            return oConvertUtils.isEmptyMap((Map)obj);
        }
        if (obj instanceof Iterable) {
            return oConvertUtils.isEmptyIterable((Iterable)obj);
        }
        if (obj instanceof Iterator) {
            return oConvertUtils.isEmptyIterator((Iterator)obj);
        }
        if (oConvertUtils.isArray(obj)) {
            return oConvertUtils.isEmptyArray(obj);
        }
        return false;
    }

    public static boolean isNotEmpty(Object object) {
        return !oConvertUtils.isEmpty(object);
    }

    public static String decode(String strIn, String sourceCode, String targetCode) {
        String string = oConvertUtils.code2code(strIn, sourceCode, targetCode);
        return string;
    }

    public static boolean isNumeric(String str) {
        return str.matches("-?[0-9]+.?[0-9]*");
    }

    private static String code2code(String strIn, String sourceCode, String targetCode) {
        String string = null;
        if (strIn == null || strIn.trim().equals("")) {
            return strIn;
        }
        try {
            byte[] byArray = strIn.getBytes(sourceCode);
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                System.out.print(byArray[i2] + "  ");
            }
            string = new String(byArray, targetCode);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return string;
    }

    public static int getInt(String s, int defval) {
        if (s == null || s == "") {
            return defval;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return defval;
        }
    }

    public static int getInt(String s) {
        if (s == null || s == "") {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static int getInt(String s, Integer df) {
        if (s == null || s == "") {
            return df;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static int getInt(Object object, int defval) {
        if (oConvertUtils.isEmpty(object)) {
            return defval;
        }
        try {
            if (object instanceof Float) {
                return ((Float)object).intValue();
            }
            return Integer.parseInt(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return defval;
        }
    }

    public static Integer getInt(Object object) {
        if (oConvertUtils.isEmpty(object)) {
            return null;
        }
        try {
            if (object instanceof Float) {
                return ((Float)object).intValue();
            }
            return Integer.parseInt(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static int getInt(BigDecimal s, int defval) {
        if (s == null) {
            return defval;
        }
        return s.intValue();
    }

    public static String getString(String s) {
        return oConvertUtils.getString(s, "");
    }

    public static String getString(Object object) {
        if (oConvertUtils.isEmpty(object)) {
            return "";
        }
        return object.toString().trim();
    }

    public static String getString(int i2) {
        return String.valueOf(i2);
    }

    public static String getString(float i2) {
        return String.valueOf(i2);
    }

    public static String getString(String s, String defval) {
        if (oConvertUtils.isEmpty(s)) {
            return defval;
        }
        return s.trim();
    }

    public static String getString(Object s, String defval) {
        if (oConvertUtils.isEmpty(s)) {
            return defval;
        }
        return s.toString().trim();
    }

    public static String getJmString(Object s) {
        if (oConvertUtils.isEmpty(s)) {
            return "";
        }
        return s.toString();
    }

    public static String getIp() {
        String string = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        return string;
    }

    public static String camelToUnderline(String para) {
        if (para.length() < 3) {
            return para.toLowerCase();
        }
        StringBuilder stringBuilder = new StringBuilder(para);
        int n = 0;
        for (int i2 = 2; i2 < para.length(); ++i2) {
            if (!Character.isUpperCase(para.charAt(i2))) continue;
            stringBuilder.insert(i2 + n, "_");
            ++n;
        }
        return stringBuilder.toString().toLowerCase();
    }

    public static Field[] getAllFields(Object object) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            arrayList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
        }
        Field[] fieldArray = new Field[arrayList.size()];
        arrayList.toArray(fieldArray);
        return fieldArray;
    }

    public static String join(Object[] array, String separator, int startIndex, int endIndex) {
        int n;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        if ((n = endIndex - startIndex) <= 0) {
            return "";
        }
        StringBuilder stringBuilder = oConvertUtils.newStringBuilder(n);
        if (array[startIndex] != null) {
            stringBuilder.append(array[startIndex]);
        }
        for (int i2 = startIndex + 1; i2 < endIndex; ++i2) {
            stringBuilder.append(separator);
            if (array[i2] == null) continue;
            stringBuilder.append(array[i2]);
        }
        return stringBuilder.toString();
    }

    private static StringBuilder newStringBuilder(int noOfItems) {
        return new StringBuilder(noOfItems * 16);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int startPos) {
        int n;
        if (str == null || searchStr == null) {
            return -1;
        }
        if (startPos < 0) {
            startPos = 0;
        }
        if (startPos > (n = str.length() - searchStr.length() + 1)) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return startPos;
        }
        for (int i2 = startPos; i2 < n; ++i2) {
            if (!oConvertUtils.regionMatches(str, true, i2, searchStr, 0, searchStr.length())) continue;
            return i2;
        }
        return -1;
    }

    public static boolean regionMatches(CharSequence cs, boolean ignoreCase, int thisStart, CharSequence substring, int start, int length) {
        if (cs instanceof String && substring instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, thisStart, (String)substring, start, length);
        }
        int n = thisStart;
        int n2 = start;
        int n3 = length;
        int n4 = cs.length() - thisStart;
        int n5 = substring.length() - start;
        if (thisStart < 0 || start < 0 || length < 0) {
            return false;
        }
        if (n4 < length || n5 < length) {
            return false;
        }
        while (n3-- > 0) {
            char c2;
            char c3;
            if ((c3 = cs.charAt(n++)) == (c2 = substring.charAt(n2++))) continue;
            if (!ignoreCase) {
                return false;
            }
            if (Character.toUpperCase(c3) == Character.toUpperCase(c2) || Character.toLowerCase(c3) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    public static byte[] decodeBase64(String base64Str) {
        byte[] byArray = Base64.decodeBase64((String)base64Str);
        return byArray;
    }

    /*
     * Exception decompiling
     */
    public static <T> List<T> deepCopy(List<T> list) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

