/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import org.jeecg.modules.jmreport.common.constant.CommonConstant;

public class Result<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean success = true;
    private String message = "";
    private Integer code = 0;
    private T result;
    private long timestamp = System.currentTimeMillis();
    @JsonIgnore
    private String onlTable;

    public Result<T> success(String message) {
        this.message = message;
        this.code = CommonConstant.SC_OK_200;
        this.success = true;
        return this;
    }

    @Deprecated
    public static Result<Object> ok() {
        Result<Object> result = new Result<Object>();
        result.setSuccess(true);
        result.setCode(CommonConstant.SC_OK_200);
        result.setMessage("\u6210\u529f");
        return result;
    }

    @Deprecated
    public static Result<Object> ok(String msg) {
        Result<Object> result = new Result<Object>();
        result.setSuccess(true);
        result.setCode(CommonConstant.SC_OK_200);
        result.setMessage(msg);
        return result;
    }

    @Deprecated
    public static Result<Object> ok(Object data) {
        Result<Object> result = new Result<Object>();
        result.setSuccess(true);
        result.setCode(CommonConstant.SC_OK_200);
        result.setResult(data);
        return result;
    }

    public static <T> Result<T> OK() {
        Result<T> result = new Result<T>();
        result.setSuccess(true);
        result.setCode(CommonConstant.SC_OK_200);
        return result;
    }

    public static <T> Result<T> OK(T data) {
        Result<T> result = new Result<T>();
        result.setSuccess(true);
        result.setCode(CommonConstant.SC_OK_200);
        result.setResult(data);
        return result;
    }

    public static <T> Result<T> OK(String msg, T data) {
        Result<T> result = new Result<T>();
        result.setSuccess(true);
        result.setCode(CommonConstant.SC_OK_200);
        result.setMessage(msg);
        result.setResult(data);
        return result;
    }

    public static <T> Result<T> FAIL(String msg, T data) {
        Result<T> result = new Result<T>();
        result.setSuccess(false);
        result.setCode(CommonConstant.SC_OK_200);
        result.setMessage(msg);
        result.setResult(data);
        return result;
    }

    public static Result<Object> error(String msg) {
        return Result.error(CommonConstant.SC_INTERNAL_SERVER_ERROR_500, msg);
    }

    public static Result<Object> error(int code, String msg) {
        Result<Object> result = new Result<Object>();
        result.setCode(code);
        result.setMessage(msg);
        result.setSuccess(false);
        return result;
    }

    public Result<T> error500(String message) {
        this.message = message;
        this.code = CommonConstant.SC_INTERNAL_SERVER_ERROR_500;
        this.success = false;
        return this;
    }

    public static Result<Object> noauth(String msg) {
        return Result.error(CommonConstant.SC_JEECG_NO_AUTHZ, msg);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getMessage() {
        return this.message;
    }

    public Integer getCode() {
        return this.code;
    }

    public T getResult() {
        return this.result;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getOnlTable() {
        return this.onlTable;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @JsonIgnore
    public void setOnlTable(String onlTable) {
        this.onlTable = onlTable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result result = (Result)o;
        if (!result.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != result.isSuccess()) {
            return false;
        }
        if (this.getTimestamp() != result.getTimestamp()) {
            return false;
        }
        Integer n = this.getCode();
        Integer n2 = result.getCode();
        if (n == null ? n2 != null : !((Object)n).equals(n2)) {
            return false;
        }
        String string = this.getMessage();
        String string2 = result.getMessage();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        T t = this.getResult();
        T t2 = result.getResult();
        if (t == null ? t2 != null : !t.equals(t2)) {
            return false;
        }
        String string3 = this.getOnlTable();
        String string4 = result.getOnlTable();
        return !(string3 == null ? string4 != null : !string3.equals(string4));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * 59 + (this.isSuccess() ? 79 : 97);
        long l2 = this.getTimestamp();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        Integer n3 = this.getCode();
        n2 = n2 * 59 + (n3 == null ? 43 : ((Object)n3).hashCode());
        String string = this.getMessage();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        T t = this.getResult();
        n2 = n2 * 59 + (t == null ? 43 : t.hashCode());
        String string2 = this.getOnlTable();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        return n2;
    }

    public String toString() {
        return "Result(success=" + this.isSuccess() + ", message=" + this.getMessage() + ", code=" + this.getCode() + ", result=" + this.getResult() + ", timestamp=" + this.getTimestamp() + ", onlTable=" + this.getOnlTable() + ")";
    }
}

