/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component(value="hikariDataSourceConfig")
@ConfigurationProperties(prefix="spring.datasource.hikari")
public class HikariDataSourceConfig {
    private Integer minimumIdle = 5;
    private Integer maximumPoolSize = 15;
    private Integer idleTimeout = 30000;
    private Integer maxLifetime = 30000;
    private String poolName = "HikariCP";
    private String connectionTestQuery = null;
    private Integer connectionTimeout = 30000;
    private Boolean autoCommit = true;

    public Integer getMinimumIdle() {
        return this.minimumIdle;
    }

    public Integer getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public Integer getIdleTimeout() {
        return this.idleTimeout;
    }

    public Integer getMaxLifetime() {
        return this.maxLifetime;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public String getConnectionTestQuery() {
        return this.connectionTestQuery;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void setMinimumIdle(Integer minimumIdle) {
        this.minimumIdle = minimumIdle;
    }

    public void setMaximumPoolSize(Integer maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public void setIdleTimeout(Integer idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setMaxLifetime(Integer maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public void setConnectionTestQuery(String connectionTestQuery) {
        this.connectionTestQuery = connectionTestQuery;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setAutoCommit(Boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HikariDataSourceConfig)) {
            return false;
        }
        HikariDataSourceConfig hikariDataSourceConfig = (HikariDataSourceConfig)o;
        if (!hikariDataSourceConfig.canEqual(this)) {
            return false;
        }
        Integer n = this.getMinimumIdle();
        Integer n2 = hikariDataSourceConfig.getMinimumIdle();
        if (n == null ? n2 != null : !((Object)n).equals(n2)) {
            return false;
        }
        Integer n3 = this.getMaximumPoolSize();
        Integer n4 = hikariDataSourceConfig.getMaximumPoolSize();
        if (n3 == null ? n4 != null : !((Object)n3).equals(n4)) {
            return false;
        }
        Integer n5 = this.getIdleTimeout();
        Integer n6 = hikariDataSourceConfig.getIdleTimeout();
        if (n5 == null ? n6 != null : !((Object)n5).equals(n6)) {
            return false;
        }
        Integer n7 = this.getMaxLifetime();
        Integer n8 = hikariDataSourceConfig.getMaxLifetime();
        if (n7 == null ? n8 != null : !((Object)n7).equals(n8)) {
            return false;
        }
        Integer n9 = this.getConnectionTimeout();
        Integer n10 = hikariDataSourceConfig.getConnectionTimeout();
        if (n9 == null ? n10 != null : !((Object)n9).equals(n10)) {
            return false;
        }
        Boolean bl = this.getAutoCommit();
        Boolean bl2 = hikariDataSourceConfig.getAutoCommit();
        if (bl == null ? bl2 != null : !((Object)bl).equals(bl2)) {
            return false;
        }
        String string = this.getPoolName();
        String string2 = hikariDataSourceConfig.getPoolName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getConnectionTestQuery();
        String string4 = hikariDataSourceConfig.getConnectionTestQuery();
        return !(string3 == null ? string4 != null : !string3.equals(string4));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HikariDataSourceConfig;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        Integer n3 = this.getMinimumIdle();
        n2 = n2 * 59 + (n3 == null ? 43 : ((Object)n3).hashCode());
        Integer n4 = this.getMaximumPoolSize();
        n2 = n2 * 59 + (n4 == null ? 43 : ((Object)n4).hashCode());
        Integer n5 = this.getIdleTimeout();
        n2 = n2 * 59 + (n5 == null ? 43 : ((Object)n5).hashCode());
        Integer n6 = this.getMaxLifetime();
        n2 = n2 * 59 + (n6 == null ? 43 : ((Object)n6).hashCode());
        Integer n7 = this.getConnectionTimeout();
        n2 = n2 * 59 + (n7 == null ? 43 : ((Object)n7).hashCode());
        Boolean bl = this.getAutoCommit();
        n2 = n2 * 59 + (bl == null ? 43 : ((Object)bl).hashCode());
        String string = this.getPoolName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getConnectionTestQuery();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        return n2;
    }

    public String toString() {
        return "HikariDataSourceConfig(minimumIdle=" + this.getMinimumIdle() + ", maximumPoolSize=" + this.getMaximumPoolSize() + ", idleTimeout=" + this.getIdleTimeout() + ", maxLifetime=" + this.getMaxLifetime() + ", poolName=" + this.getPoolName() + ", connectionTestQuery=" + this.getConnectionTestQuery() + ", connectionTimeout=" + this.getConnectionTimeout() + ", autoCommit=" + this.getAutoCommit() + ")";
    }
}

