/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.config;

import org.jeecg.modules.jmreport.common.interceptor.JimuReportInterceptor;
import org.jeecg.modules.jmreport.common.util.oConvertUtils;
import org.jeecg.modules.jmreport.config.oss.JmReportUploadConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(value="jimuReportConfiguration")
@PropertySource(value={"classpath:config/default-config.properties"})
public class JimuReportConfiguration
implements InitializingBean,
WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(JimuReportConfiguration.class);
    @Value(value="${spring.resource.static-locations}")
    private String staticLocations;
    @Autowired
    private JmReportUploadConfig jmReportUploadConfig;

    @Bean
    public JimuReportInterceptor jimuReportInterceptor() {
        return new JimuReportInterceptor();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        String[] stringArray = new String[]{"/*.js", "/*.css", "/*.svg", "/*.pdf", "/*.jpg", "/*.png", "/*.ico", "/*.html", "/html/**", "/js/**", "/css/**", "/images/**"};
        registry.addInterceptor((HandlerInterceptor)this.jimuReportInterceptor()).excludePathPatterns(stringArray).addPathPatterns(new String[]{"/jmreport/**"});
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer placeholderConfigurer() {
        PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer = new PropertySourcesPlaceholderConfigurer();
        propertySourcesPlaceholderConfigurer.setIgnoreUnresolvablePlaceholders(true);
        return propertySourcesPlaceholderConfigurer;
    }

    public void afterPropertiesSet() throws Exception {
        log.info(" --- Init JimuReport Config --- ");
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        if (oConvertUtils.isEmpty(this.staticLocations)) {
            this.staticLocations = "classpath:/static/";
        } else if (oConvertUtils.isNotEmpty(this.staticLocations) && this.staticLocations.indexOf("classpath:/static/") == -1) {
            this.staticLocations = this.staticLocations + ",classpath:/static/";
            this.staticLocations = this.staticLocations.replace(",,", ",");
        }
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"file:" + this.jmReportUploadConfig.getPath().getUpload() + "//"}).addResourceLocations(this.staticLocations.split(","));
    }
}

