/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.config.client;

import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.modules.jmreport.api.JmReportTokenServiceI;
import org.jeecg.modules.jmreport.common.util.CommonUtils;
import org.jeecg.modules.jmreport.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;

@Component(value="jmReportTokenClient")
public class JmReportTokenClient {
    private static final Logger log = LoggerFactory.getLogger(JmReportTokenClient.class);
    @Autowired(required=false)
    private JmReportTokenServiceI jimuTokenService;

    public String getToken(HttpServletRequest request) {
        String string = "";
        if (oConvertUtils.isNotEmpty(this.jimuTokenService)) {
            string = this.jimuTokenService.getToken(request);
        }
        return string;
    }

    public String getToken() {
        String string = "";
        if (oConvertUtils.isNotEmpty(this.jimuTokenService)) {
            string = this.jimuTokenService.getToken();
        }
        return string;
    }

    public String getUsername(String token) {
        String string = "admin";
        if (oConvertUtils.isNotEmpty(this.jimuTokenService) && oConvertUtils.isNotEmpty(token)) {
            try {
                string = this.jimuTokenService.getUsername(token);
            }
            catch (Exception exception) {
                log.error(exception.getMessage(), (Throwable)exception);
            }
        }
        return string;
    }

    public String getUsername(HttpServletRequest request) {
        String string = "admin";
        String string2 = this.getToken(request);
        if (oConvertUtils.isNotEmpty(this.jimuTokenService) && oConvertUtils.isNotEmpty(string2)) {
            try {
                string = this.jimuTokenService.getUsername(string2);
            }
            catch (Exception exception) {
                log.error(exception.getMessage(), (Throwable)exception);
            }
        }
        return string;
    }

    public String getUsername() {
        String string = "admin";
        String string2 = this.getToken();
        if (oConvertUtils.isNotEmpty(this.jimuTokenService) && oConvertUtils.isNotEmpty(string2)) {
            try {
                string = this.jimuTokenService.getUsername(string2);
            }
            catch (Exception exception) {
                log.error(exception.getMessage(), (Throwable)exception);
            }
        }
        return string;
    }

    public boolean verifyToken(HttpServletRequest request) {
        Boolean bl = true;
        if (oConvertUtils.isNotEmpty(this.jimuTokenService)) {
            String string = this.getToken(request);
            bl = this.jimuTokenService.verifyToken(string);
        }
        return bl;
    }

    public Map<String, Object> getUserInfo(String token) {
        Map<String, Object> map = null;
        if (oConvertUtils.isNotEmpty(this.jimuTokenService) && oConvertUtils.isNotEmpty(token)) {
            try {
                map = this.jimuTokenService.getUserInfo(token);
                Date date = new Date();
                if (map.get("sysDate") == null) {
                    map.put("sysDate", CommonUtils.getCurrentDateString(date));
                }
                if (map.get("sysDateTime") == null) {
                    map.put("sysDateTime", CommonUtils.getCurrentDateTimeString(date));
                }
            }
            catch (Exception exception) {
                log.error(exception.getMessage(), (Throwable)exception);
            }
        }
        return map;
    }

    public HttpHeaders customApiHeader() {
        HttpHeaders httpHeaders = null;
        if (oConvertUtils.isNotEmpty(this.jimuTokenService)) {
            httpHeaders = this.jimuTokenService.customApiHeader();
        }
        return httpHeaders;
    }
}

