/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.dyndb;

import com.alibaba.druid.pool.DruidDataSource;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.util.JimuSpringContextUtils;
import org.jeecg.modules.jmreport.common.util.ReflectHelper;
import org.jeecg.modules.jmreport.common.util.oConvertUtils;
import org.jeecg.modules.jmreport.config.HikariDataSourceConfig;
import org.jeecg.modules.jmreport.desreport.service.IJimuReportAsyncService;
import org.jeecg.modules.jmreport.dyndb.JmreportDataSourceCachePool;
import org.jeecg.modules.jmreport.dyndb.util.JmreportFreemarkerParseFactory;
import org.jeecg.modules.jmreport.dyndb.vo.JmreportDynamicDataSourceVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;

@Component(value="JmreportDynamicDbUtil")
public class JmreportDynamicDbUtil {
    private static final Logger log = LoggerFactory.getLogger(JmreportDynamicDbUtil.class);
    @Resource
    private HikariDataSourceConfig hikariDataSourceConfig;
    @Resource
    private IJimuReportAsyncService jimuReportAsyncService;

    @Deprecated
    private DruidDataSource getDruidDataSource(JmreportDynamicDataSourceVo dbSource) {
        DruidDataSource druidDataSource = new DruidDataSource();
        String string = dbSource.getDbDriver();
        String string2 = dbSource.getDbUrl();
        String string3 = dbSource.getDbUsername();
        String string4 = dbSource.getDbPassword();
        druidDataSource.setDriverClassName(string);
        druidDataSource.setUrl(string2);
        druidDataSource.setTestWhileIdle(true);
        druidDataSource.setTestOnBorrow(false);
        druidDataSource.setTestOnReturn(false);
        druidDataSource.setBreakAfterAcquireFailure(true);
        druidDataSource.setLoginTimeout(oConvertUtils.getInt(this.hikariDataSourceConfig.getConnectionTimeout() / 1000, 10));
        druidDataSource.setConnectionErrorRetryAttempts(0);
        druidDataSource.setUsername(string3);
        druidDataSource.setMaxWait(60000L);
        druidDataSource.setPassword(string4);
        log.debug("******************************************");
        log.debug("*                                        *");
        log.debug("*====\u3010" + dbSource.getCode() + "\u3011=====Druid\u8fde\u63a5\u6c60\u5df2\u542f\u7528 ====*");
        log.debug("*                                        *");
        log.debug("******************************************");
        return druidDataSource;
    }

    private HikariDataSource getHikariDataSource(JmreportDynamicDataSourceVo dbSource) {
        HikariDataSource hikariDataSource = new HikariDataSource();
        String string = dbSource.getDbDriver();
        String string2 = dbSource.getDbUrl();
        String string3 = dbSource.getDbUsername();
        String string4 = dbSource.getDbPassword();
        hikariDataSource.setDriverClassName(string);
        hikariDataSource.setJdbcUrl(string2);
        hikariDataSource.setUsername(string3);
        hikariDataSource.setPassword(string4);
        hikariDataSource.setAutoCommit(this.hikariDataSourceConfig.getAutoCommit().booleanValue());
        hikariDataSource.setMaximumPoolSize(this.hikariDataSourceConfig.getMaximumPoolSize().intValue());
        hikariDataSource.setMinimumIdle(this.hikariDataSourceConfig.getMinimumIdle().intValue());
        hikariDataSource.setConnectionTimeout((long)this.hikariDataSourceConfig.getConnectionTimeout().intValue());
        hikariDataSource.setIdleTimeout((long)this.hikariDataSourceConfig.getIdleTimeout().intValue());
        hikariDataSource.setMaxLifetime((long)this.hikariDataSourceConfig.getMaxLifetime().intValue());
        hikariDataSource.setPoolName(this.hikariDataSourceConfig.getPoolName());
        log.debug("******************************************");
        log.debug("*                                        *");
        log.debug("*====\u3010" + dbSource.getCode() + "\u3011=====Hikari\u8fde\u63a5\u6c60\u5df2\u542f\u7528 ====*");
        log.debug("*                                        *");
        log.debug("******************************************");
        return hikariDataSource;
    }

    public DataSource getDbSourceByDbKey(String dbKey) {
        log.debug("----\u81ea\u5b9a\u4e49\u52a8\u6001\u6570\u636e\u6e90----------dbKey------: " + dbKey);
        DataSource dataSource = JmreportDataSourceCachePool.getCacheBasicDataSource(dbKey);
        try {
            if (dataSource != null) {
                log.debug("--------getDbSourceBydbKey------------------\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6DB\u8fde\u63a5-------------------");
                return dataSource;
            }
            JmreportDynamicDataSourceVo jmreportDynamicDataSourceVo = JmreportDataSourceCachePool.getCacheDynamicDataSourceModel(dbKey);
            if (jmreportDynamicDataSourceVo == null) {
                throw new JimuReportException("\u52a8\u6001\u6570\u636e\u6e90\u8fde\u63a5\u4e0d\u5b58\u5728\uff0cdbKey\uff1a" + dbKey);
            }
            if (jmreportDynamicDataSourceVo.getConnectTimes() > 5) {
                throw new JimuReportException("\u6570\u636e\u6e90\u5df2\u8fde\u63a5\u9519\u8bef5\u6b21\u4ee5\u4e0a,\u8bf7\u68c0\u67e5,dbKey:" + dbKey);
            }
            HikariDataSource hikariDataSource = this.getHikariDataSource(jmreportDynamicDataSourceVo);
            if (hikariDataSource == null) {
                throw new JimuReportException("\u52a8\u6001\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff0cdbKey\uff1a" + dbKey);
            }
            JmreportDataSourceCachePool.putCacheBasicDataSource(dbKey, (DataSource)hikariDataSource);
            log.debug("--------getDbSourceBydbKey------------------\u521b\u5efaDB\u6570\u636e\u5e93\u8fde\u63a5-------------------");
            return hikariDataSource;
        }
        catch (Exception exception) {
            log.warn(exception.getMessage(), (Throwable)exception);
            return dataSource;
        }
    }

    public void closeDbKey(String dbKey) {
        DataSource dataSource = this.getDbSourceByDbKey(dbKey);
        try {
            if (dataSource != null && !dataSource.getConnection().isClosed()) {
                dataSource.getConnection().commit();
                dataSource.getConnection().close();
                dataSource.getConnection().close();
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private JdbcTemplate getJdbcTemplate(String dbKey) {
        DataSource dataSource = this.getDbSourceByDbKey(dbKey);
        if (dataSource == null) {
            throw new JimuReportException("\u6570\u636e\u6e90\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8fde\u63a5\uff01");
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        jdbcTemplate.setQueryTimeout(oConvertUtils.getInt(this.hikariDataSourceConfig.getConnectionTimeout() / 1000, 10));
        return jdbcTemplate;
    }

    public int update(String dbKey, String sql, Object ... param) {
        int n;
        JdbcTemplate jdbcTemplate = null;
        try {
            jdbcTemplate = this.getJdbcTemplate(dbKey);
            n = oConvertUtils.isEmpty(param) ? jdbcTemplate.update(sql) : jdbcTemplate.update(sql, param);
        }
        catch (Exception exception) {
            this.jimuReportAsyncService.testConnect(jdbcTemplate, dbKey);
            throw exception;
        }
        return n;
    }

    public int updateByHash(String dbKey, String sql, HashMap<String, Object> data) {
        int n;
        JdbcTemplate jdbcTemplate = null;
        try {
            jdbcTemplate = this.getJdbcTemplate(dbKey);
            sql = JmreportFreemarkerParseFactory.parseTemplateContent(sql, data);
            NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate.getDataSource());
            n = namedParameterJdbcTemplate.update(sql, data);
        }
        catch (Exception exception) {
            this.jimuReportAsyncService.testConnect(jdbcTemplate, dbKey);
            throw exception;
        }
        return n;
    }

    public Object findOne(String dbKey, String sql, Object ... param) {
        List<Map<String, Object>> list = this.findList(dbKey, sql, param);
        if (oConvertUtils.isEmpty(list)) {
            log.error("Except one, but not find actually");
        }
        if (list.size() > 1) {
            log.error("Except one, but more than one actually");
        }
        return list.get(0);
    }

    public Object findOneByHash(String dbKey, String sql, HashMap<String, Object> data) {
        List<Map<String, Object>> list = this.findListByHash(dbKey, sql, data);
        if (oConvertUtils.isEmpty(list)) {
            log.error("Except one, but not find actually");
        }
        if (list.size() > 1) {
            log.error("Except one, but more than one actually");
        }
        return list.get(0);
    }

    public <T> Object findOne(String dbKey, String sql, Class<T> clazz, Object ... param) {
        Map map = (Map)this.findOne(dbKey, sql, param);
        return ReflectHelper.setAll(clazz, (Map<String, Object>)map);
    }

    public <T> Object findOneByHash(String dbKey, String sql, Class<T> clazz, HashMap<String, Object> data) {
        Map map = (Map)this.findOneByHash(dbKey, sql, data);
        return ReflectHelper.setAll(clazz, (Map<String, Object>)map);
    }

    public List<Map<String, Object>> findList(String dbKey, String sql, Object ... param) {
        List list;
        JdbcTemplate jdbcTemplate = null;
        try {
            jdbcTemplate = this.getJdbcTemplate(dbKey);
            list = oConvertUtils.isEmpty(param) ? jdbcTemplate.queryForList(sql) : jdbcTemplate.queryForList(sql, param);
        }
        catch (Exception exception) {
            this.jimuReportAsyncService.testConnect(jdbcTemplate, dbKey);
            throw exception;
        }
        return list;
    }

    public List<Map<String, Object>> findListByHash(String dbKey, String sql, HashMap<String, Object> data) {
        List list;
        JdbcTemplate jdbcTemplate = null;
        try {
            jdbcTemplate = this.getJdbcTemplate(dbKey);
            sql = JmreportFreemarkerParseFactory.parseTemplateContent(sql, data);
            NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate.getDataSource());
            list = namedParameterJdbcTemplate.queryForList(sql, data);
        }
        catch (Exception exception) {
            this.jimuReportAsyncService.testConnect(jdbcTemplate, dbKey);
            throw exception;
        }
        return list;
    }

    public <T> List<T> findList(String dbKey, String sql, Class<T> clazz, Object ... param) {
        List list;
        JdbcTemplate jdbcTemplate = null;
        try {
            jdbcTemplate = this.getJdbcTemplate(dbKey);
            list = oConvertUtils.isEmpty(param) ? jdbcTemplate.queryForList(sql, clazz) : jdbcTemplate.queryForList(sql, clazz, param);
        }
        catch (Exception exception) {
            this.jimuReportAsyncService.testConnect(jdbcTemplate, dbKey);
            throw exception;
        }
        return list;
    }

    public <T> List<T> findListByHash(String dbKey, String sql, Class<T> clazz, HashMap<String, Object> data) {
        List list;
        JdbcTemplate jdbcTemplate = null;
        try {
            jdbcTemplate = this.getJdbcTemplate(dbKey);
            sql = JmreportFreemarkerParseFactory.parseTemplateContent(sql, data);
            NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate.getDataSource());
            list = namedParameterJdbcTemplate.queryForList(sql, data, clazz);
        }
        catch (Exception exception) {
            this.jimuReportAsyncService.testConnect(jdbcTemplate, dbKey);
            throw exception;
        }
        return list;
    }

    public <T> List<T> findListEntities(String dbKey, String sql, Class<T> clazz, Object ... param) {
        List<Map<String, Object>> list = this.findList(dbKey, sql, param);
        return ReflectHelper.transList2Entrys(list, clazz);
    }

    public <T> List<T> findListEntitiesByHash(String dbKey, String sql, Class<T> clazz, HashMap<String, Object> data) {
        List<Map<String, Object>> list = this.findListByHash(dbKey, sql, data);
        return ReflectHelper.transList2Entrys(list, clazz);
    }

    public <T> List<Map<String, Object>> executeProcedure(String dbKey, String procedure) {
        List<Map<String, Object>> list = null;
        JdbcTemplate jdbcTemplate = null;
        try {
            jdbcTemplate = StringUtils.isBlank((CharSequence)dbKey) ? (JdbcTemplate)JimuSpringContextUtils.getApplicationContext().getBean(JdbcTemplate.class) : this.getJdbcTemplate(dbKey);
            return (List)jdbcTemplate.execute(procedure, new CallableStatementCallback(){

                public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                    ArrayList arrayList = new ArrayList();
                    ResultSet resultSet = cs.executeQuery();
                    while (resultSet.next()) {
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        for (int i2 = 1; i2 <= resultSetMetaData.getColumnCount(); ++i2) {
                            hashMap.put(resultSetMetaData.getColumnName(i2), resultSet.getString(resultSetMetaData.getColumnName(i2)));
                        }
                        arrayList.add(hashMap);
                    }
                    return arrayList;
                }
            });
        }
        catch (Exception exception) {
            this.jimuReportAsyncService.testConnect(jdbcTemplate, dbKey);
            return list;
        }
    }
}

