/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.dyndb.query;

import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jeecg.modules.jmreport.common.util.CommonUtils;
import org.jeecg.modules.jmreport.common.util.oConvertUtils;
import org.jeecg.modules.jmreport.dyndb.query.QueryRuleEnum;
import org.jeecg.modules.jmreport.dyndb.util.JmreportSqlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryGenerator {
    private static final Logger log = LoggerFactory.getLogger(QueryGenerator.class);
    public static final String SQL_RULES_COLUMN = "SQL_RULES_COLUMN";
    private static final String BEGIN = "_begin";
    private static final String END = "_end";
    private static final String MULTI = "_MultiString";
    private static final String STAR = "*";
    private static final String COMMA = ",";
    private static final String NOT_EQUAL = "!";
    private static final String QUERY_SEPARATE_KEYWORD = " ";
    private static final String SUPER_QUERY_PARAMS = "superQueryParams";
    private static final String SUPER_QUERY_MATCH_TYPE = "superQueryMatchType";
    public static final String SQL_SQ = "'";
    private static final String ORDER_COLUMN = "column";
    private static final String ORDER_TYPE = "order";
    private static final String ORDER_TYPE_ASC = "ASC";
    public static final String LIKE_MYSQL_SPECIAL_STRS = "_,%";
    private static final ThreadLocal<SimpleDateFormat> local = new ThreadLocal();

    private static SimpleDateFormat getTime() {
        SimpleDateFormat simpleDateFormat = local.get();
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            local.set(simpleDateFormat);
        }
        return simpleDateFormat;
    }

    private static QueryRuleEnum convert2Rule(Object value) {
        if (value == null) {
            return null;
        }
        String string = (value + "").toString().trim();
        if (string.length() == 0) {
            return null;
        }
        QueryRuleEnum queryRuleEnum = null;
        if (queryRuleEnum == null && string.length() >= 3 && QUERY_SEPARATE_KEYWORD.equals(string.substring(2, 3))) {
            queryRuleEnum = QueryRuleEnum.getByValue(string.substring(0, 2));
        }
        if (queryRuleEnum == null && string.length() >= 2 && QUERY_SEPARATE_KEYWORD.equals(string.substring(1, 2))) {
            queryRuleEnum = QueryRuleEnum.getByValue(string.substring(0, 1));
        }
        if (queryRuleEnum == null && string.contains(STAR)) {
            if (string.startsWith(STAR) && string.endsWith(STAR)) {
                queryRuleEnum = QueryRuleEnum.LIKE;
            } else if (string.startsWith(STAR)) {
                queryRuleEnum = QueryRuleEnum.LEFT_LIKE;
            } else if (string.endsWith(STAR)) {
                queryRuleEnum = QueryRuleEnum.RIGHT_LIKE;
            }
        }
        if (queryRuleEnum == null && string.contains(COMMA)) {
            queryRuleEnum = QueryRuleEnum.IN;
        }
        if (queryRuleEnum == null && string.startsWith(NOT_EQUAL)) {
            queryRuleEnum = QueryRuleEnum.NE;
        }
        return queryRuleEnum != null ? queryRuleEnum : QueryRuleEnum.EQ;
    }

    private static Object replaceValue(QueryRuleEnum rule, Object value) {
        if (rule == null) {
            return null;
        }
        if (!(value instanceof String)) {
            return value;
        }
        String string = (value + "").toString().trim();
        if (rule == QueryRuleEnum.LIKE) {
            value = string.substring(1, string.length() - 1);
            value = QueryGenerator.specialStrConvert(value.toString());
        } else if (rule == QueryRuleEnum.LEFT_LIKE || rule == QueryRuleEnum.NE) {
            value = string.substring(1);
            value = QueryGenerator.specialStrConvert(value.toString());
        } else if (rule == QueryRuleEnum.RIGHT_LIKE) {
            value = string.substring(0, string.length() - 1);
            value = QueryGenerator.specialStrConvert(value.toString());
        } else if (rule == QueryRuleEnum.IN) {
            value = string.split(COMMA);
        } else if (string.startsWith(rule.getValue())) {
            value = string.replaceFirst(rule.getValue(), "");
        } else if (string.startsWith(rule.getCondition() + QUERY_SEPARATE_KEYWORD)) {
            value = string.replaceFirst(rule.getCondition() + QUERY_SEPARATE_KEYWORD, "").trim();
        }
        return value;
    }

    private static Date getDateQueryByRule(String value, QueryRuleEnum rule) throws ParseException {
        Date date = null;
        if (value.length() == 10) {
            if (rule == QueryRuleEnum.GE) {
                date = QueryGenerator.getTime().parse(value + " 00:00:00");
            } else if (rule == QueryRuleEnum.LE) {
                date = QueryGenerator.getTime().parse(value + " 23:59:59");
            }
        }
        if (date == null) {
            date = QueryGenerator.getTime().parse(value);
        }
        return date;
    }

    private static boolean judgedIsUselessField(String name) {
        return "class".equals(name) || "ids".equals(name) || "page".equals(name) || "rows".equals(name) || "sort".equals(name) || ORDER_TYPE.equals(name);
    }

    public static String trimSingleQuote(String ruleValue) {
        if (oConvertUtils.isEmpty(ruleValue)) {
            return "";
        }
        if (ruleValue.startsWith(SQL_SQ)) {
            ruleValue = ruleValue.substring(1);
        }
        if (ruleValue.endsWith(SQL_SQ)) {
            ruleValue = ruleValue.substring(0, ruleValue.length() - 1);
        }
        return ruleValue;
    }

    public static Set<String> getSqlRuleParams(String sql) {
        if (oConvertUtils.isEmpty(sql)) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        String string = "\\#\\{\\w+\\}";
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(sql);
        while (matcher.find()) {
            String string2 = matcher.group();
            hashSet.add(string2.substring(string2.indexOf("{") + 1, string2.indexOf("}")));
        }
        return hashSet;
    }

    public static String getSingleQueryConditionSql(String field, String alias, Object value, boolean isString) {
        if (value == null) {
            return "";
        }
        field = alias + oConvertUtils.camelToUnderline(field);
        QueryRuleEnum queryRuleEnum = QueryGenerator.convert2Rule(value);
        return QueryGenerator.getSingleSqlByRule(queryRuleEnum, field, value, isString);
    }

    public static String getSingleSqlByRule(QueryRuleEnum rule, String field, Object value, boolean isString) {
        String string = "";
        switch (rule) {
            case GT: {
                string = field + rule.getValue() + QueryGenerator.getFieldConditionValue(value, isString);
                break;
            }
            case GE: {
                string = field + rule.getValue() + QueryGenerator.getFieldConditionValue(value, isString);
                break;
            }
            case LT: {
                string = field + rule.getValue() + QueryGenerator.getFieldConditionValue(value, isString);
                break;
            }
            case LE: {
                string = field + rule.getValue() + QueryGenerator.getFieldConditionValue(value, isString);
                break;
            }
            case EQ: {
                string = field + rule.getValue() + QueryGenerator.getFieldConditionValue(value, isString);
                break;
            }
            case NE: {
                string = field + " <> " + QueryGenerator.getFieldConditionValue(value, isString);
                break;
            }
            case IN: {
                string = field + " in " + QueryGenerator.getInConditionValue(value, isString);
                break;
            }
            case LIKE: {
                string = field + " like " + QueryGenerator.getLikeConditionValue(value);
                break;
            }
            case LEFT_LIKE: {
                string = field + " like " + QueryGenerator.getLikeConditionValue(value);
                break;
            }
            case RIGHT_LIKE: {
                string = field + " like " + QueryGenerator.getLikeConditionValue(value);
                break;
            }
            default: {
                string = field + " = " + QueryGenerator.getFieldConditionValue(value, isString);
            }
        }
        return string;
    }

    private static String getFieldConditionValue(Object value, boolean isString) {
        String string = value.toString().trim();
        if (string.startsWith(NOT_EQUAL)) {
            string = string.substring(1);
        } else if (string.startsWith(">=")) {
            string = string.substring(2);
        } else if (string.startsWith("<=")) {
            string = string.substring(2);
        } else if (string.startsWith(">")) {
            string = string.substring(1);
        } else if (string.startsWith("<")) {
            string = string.substring(1);
        }
        if (isString) {
            if (JmreportSqlUtils.dbTypeIsSQLServer(CommonUtils.getDatabaseType())) {
                return " N'" + string + "' ";
            }
            return " '" + string + "' ";
        }
        if (JmreportSqlUtils.dbTypeIsSQLServer(CommonUtils.getDatabaseType()) && string.endsWith(SQL_SQ) && string.startsWith(SQL_SQ)) {
            return " N" + string;
        }
        return value.toString();
    }

    private static String getInConditionValue(Object value, boolean isString) {
        if (isString) {
            String[] stringArray = value.toString().split(COMMA);
            String string = "";
            for (String string2 : stringArray) {
                string = JmreportSqlUtils.dbTypeIsSQLServer(CommonUtils.getDatabaseType()) ? string + ",N'" + string2 + SQL_SQ : string + ",'" + string2 + SQL_SQ;
            }
            return "(" + string.substring(1) + ")";
        }
        return "(" + value.toString() + ")";
    }

    private static String getLikeConditionValue(Object value) {
        String string = value.toString().trim();
        if (string.startsWith(STAR) && string.endsWith(STAR)) {
            if (JmreportSqlUtils.dbTypeIsSQLServer(CommonUtils.getDatabaseType())) {
                return "N'%" + string.substring(1, string.length() - 1) + "%'";
            }
            return "'%" + string.substring(1, string.length() - 1) + "%'";
        }
        if (string.startsWith(STAR)) {
            if (JmreportSqlUtils.dbTypeIsSQLServer(CommonUtils.getDatabaseType())) {
                return "N'%" + string.substring(1) + SQL_SQ;
            }
            return "'%" + string.substring(1) + SQL_SQ;
        }
        if (string.endsWith(STAR)) {
            if (JmreportSqlUtils.dbTypeIsSQLServer(CommonUtils.getDatabaseType())) {
                return "N'" + string.substring(0, string.length() - 1) + "%'";
            }
            return SQL_SQ + string.substring(0, string.length() - 1) + "%'";
        }
        if (string.indexOf("%") >= 0) {
            if (JmreportSqlUtils.dbTypeIsSQLServer(CommonUtils.getDatabaseType())) {
                if (string.startsWith(SQL_SQ) && string.endsWith(SQL_SQ)) {
                    return "N" + string;
                }
                return "N'" + string + SQL_SQ;
            }
            if (string.startsWith(SQL_SQ) && string.endsWith(SQL_SQ)) {
                return string;
            }
            return SQL_SQ + string + SQL_SQ;
        }
        if (JmreportSqlUtils.dbTypeIsSQLServer(CommonUtils.getDatabaseType())) {
            return "N'%" + string + "%'";
        }
        return "'%" + string + "%'";
    }

    private static List<Field> getClassFields(Class<?> clazz) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        do {
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                arrayList.add(fieldArray[i2]);
            }
        } while ((clazz = clazz.getSuperclass()) != Object.class && clazz != null);
        return arrayList;
    }

    private static String specialStrConvert(String value) {
        if (JmreportSqlUtils.dbTypeIsMySQL(CommonUtils.getDatabaseType())) {
            String[] stringArray;
            for (String string : stringArray = LIKE_MYSQL_SPECIAL_STRS.split(COMMA)) {
                if (value.indexOf(string) == -1) continue;
                value = value.replace(string, "\\" + string);
            }
        }
        return value;
    }
}

