/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.dyndb.util;

import org.jeecg.modules.jmreport.common.util.oConvertUtils;

public class JmreportSqlUtils {
    public static final String MYSQL_ALLTABLES_COMMENT_SQL = "show table status";
    public static final String POSTGRE_ALLTABLES_COMMENT_SQL = "select relname as name,cast(obj_description(relfilenode,'pg_class') as varchar) as comment from pg_class c  where  relkind = 'r' and relname not like 'pg_%' and relname not like 'sql_%' order by relname";
    public static final String ORACLE_ALLTABLES_COMMENT_SQL = "select table_name Name,comments Comments from user_tab_comments";
    public static final String SQLSERVER_ALLTABLES_COMMENT_SQL = "SELECT DISTINCT CAST(d.name AS varchar(500)) Name,CAST(f.value AS varchar(500)) Comment FROM syscolumns a\nLEFT JOIN systypes b ON a.xusertype= b.xusertype\nINNER JOIN sysobjects d ON a.id= d.id\nAND d.xtype= 'U'\nAND d.name<> 'dtproperties'\nLEFT JOIN syscomments e ON a.cdefault= e.id\nLEFT JOIN sys.extended_properties g ON a.id= G.major_id\nAND a.colid= g.minor_id\nLEFT JOIN sys.extended_properties f ON d.id= f.major_id\nAND f.minor_id= 0 ;";

    public static boolean dbTypeIsMySQL(String dbUrl) {
        return JmreportSqlUtils.dbTypeIf(dbUrl, "mysql") || JmreportSqlUtils.dbTypeIf(dbUrl, "mariadb") || JmreportSqlUtils.dbTypeIf(dbUrl, "sqlite") || JmreportSqlUtils.dbTypeIf(dbUrl, "clickhouse") || JmreportSqlUtils.dbTypeIf(dbUrl, "polardb");
    }

    public static boolean dbTypeIsOracle(String dbType) {
        return JmreportSqlUtils.dbTypeIf(dbType, "oracle9i") || JmreportSqlUtils.dbTypeIf(dbType, "oracle") || JmreportSqlUtils.dbTypeIf(dbType, "dm") || JmreportSqlUtils.dbTypeIf(dbType, "edb");
    }

    public static boolean dbTypeIsSQLServer(String dbType) {
        return JmreportSqlUtils.dbTypeIf(dbType, "sqlserver") || JmreportSqlUtils.dbTypeIf(dbType, "sqlserver2012") || JmreportSqlUtils.dbTypeIf(dbType, "derby");
    }

    public static boolean dbTypeIsPostgre(String dbType) {
        return JmreportSqlUtils.dbTypeIf(dbType, "postgresql") || JmreportSqlUtils.dbTypeIf(dbType, "kingbase") || JmreportSqlUtils.dbTypeIf(dbType, "zenith");
    }

    public static boolean dbTypeIf(String dbUrl, String dbType) {
        return dbUrl.toLowerCase().contains(dbType);
    }

    public static String getCountSql(String sql) {
        return String.format("SELECT COUNT(1) total FROM ( %s ) temp_count", sql);
    }

    private static int getAfterSelectInsertPoint(String sql) {
        int n = sql.toLowerCase().indexOf("select");
        int n2 = sql.toLowerCase().indexOf("select distinct");
        return n + (n2 == n ? 15 : 6);
    }

    public static String getAllTableSql(String dbUrl) {
        if (oConvertUtils.isNotEmpty(dbUrl)) {
            if (JmreportSqlUtils.dbTypeIsMySQL(dbUrl)) {
                return MYSQL_ALLTABLES_COMMENT_SQL;
            }
            if (JmreportSqlUtils.dbTypeIsOracle(dbUrl)) {
                return ORACLE_ALLTABLES_COMMENT_SQL;
            }
            if (JmreportSqlUtils.dbTypeIsPostgre(dbUrl)) {
                return POSTGRE_ALLTABLES_COMMENT_SQL;
            }
            if (JmreportSqlUtils.dbTypeIsSQLServer(dbUrl)) {
                return SQLSERVER_ALLTABLES_COMMENT_SQL;
            }
        }
        return null;
    }
}

