/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.automate.service.a;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.jeecg.modules.jmreport.automate.c.b;
import org.jeecg.modules.jmreport.automate.model.JimuReportAutoExportVO;
import org.jeecg.modules.jmreport.automate.service.IJimuReportAutoService;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.util.DateUtils;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.common.util.i;
import org.jeecg.modules.jmreport.common.util.k;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.jeecg.modules.jmreport.config.JmReportBaseConfig;
import org.jeecg.modules.jmreport.desreport.dao.JimuReportExportJobDao;
import org.jeecg.modules.jmreport.desreport.dao.JimuReportExportLogDao;
import org.jeecg.modules.jmreport.desreport.entity.JimuReportExportJob;
import org.jeecg.modules.jmreport.desreport.entity.JimuReportExportLog;
import org.jeecg.modules.jmreport.desreport.model.JmPage;
import org.jeecg.modules.jmreport.desreport.util.g;
import org.jeecg.modules.jmreport.desreport.util.q;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronExpression;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;

@Service(value="jimuReportAutoServiceImpl")
public class a
implements IJimuReportAutoService {
    private static final Logger a = LoggerFactory.getLogger(a.class);
    @Autowired
    org.jeecg.modules.jmreport.automate.conf.a automateConfigBean;
    @Autowired
    JmReportBaseConfig jmReportBaseConfig;
    @Autowired
    org.jeecg.modules.jmreport.automate.a.a autoAsyncTasks;
    @Autowired
    private HttpServletResponse response;
    @Autowired
    b pyExecHandler;
    @Autowired
    JimuReportExportLogDao jimuReportExportLogDao;
    @Autowired
    JimuReportExportJobDao jimuReportExportJobDao;
    @Qualifier(value="jmTaskScheduler")
    @Autowired
    private TaskScheduler taskScheduler;
    @Autowired
    private org.jeecg.modules.jmreport.automate.conf.a jimuRepAutomateConfigBean;
    private final Map<String, ScheduledFuture<?>> b = new ConcurrentHashMap();

    @Override
    public Result<?> autoExport(JimuReportAutoExportVO jimuReportAutoExportVO, boolean useScript) {
        Object object;
        if (null == jimuReportAutoExportVO) {
            return Result.error("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (OkConvertUtils.isEmpty(jimuReportAutoExportVO.getReportParams()) && OkConvertUtils.isEmpty(jimuReportAutoExportVO.getReportIds())) {
            return Result.error("\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u62a5\u8868");
        }
        if (OkConvertUtils.isEmpty(jimuReportAutoExportVO.getReceiverEmail()) && OkConvertUtils.isEmpty(object = jimuReportAutoExportVO.getExportFrom()) && !"job".equals(object)) {
            return Result.error("\u8bf7\u8f93\u5165\u63a5\u6536\u901a\u77e5\u7684\u90ae\u7bb1\u5730\u5740");
        }
        if (OkConvertUtils.isEmpty(jimuReportAutoExportVO.getExportType())) {
            jimuReportAutoExportVO.setExportType("PDF");
        }
        if (!useScript) {
            object = this.automateConfigBean.getExport().getPluginDomain();
            if (OkConvertUtils.isEmpty(object)) {
                return Result.error("\u8bf7\u914d\u7f6e\u63d2\u4ef6\u5730\u5740\u548c\u7aef\u53e3");
            }
            String string = String.format("%s/export/conn/test", object);
            try {
                q.a(string, Result.class);
            }
            catch (RestClientException restClientException) {
                a.error(restClientException.getMessage(), (Throwable)restClientException);
                return Result.error("\u8fde\u63a5\u5bfc\u51fa\u63d2\u4ef6\u5931\u8d25,\u8bf7\u68c0\u67e5\u63d2\u4ef6\u662f\u5426\u6b63\u5e38\u542f\u52a8.");
            }
        }
        object = DateUtils.b(new Date(), "yyyyMMddHHmmss") + k.getInstance().a(6);
        jimuReportAutoExportVO.setBatchNo((String)object);
        this.autoAsyncTasks.a(jimuReportAutoExportVO, useScript);
        return Result.OK("\u5df2\u542f\u52a8\u540e\u53f0\u5bfc\u51fa\u4efb\u52a1", object);
    }

    @Override
    public Result<?> download(String batchNo, String signature) {
        String string;
        String string2;
        File file;
        if (OkConvertUtils.isEmpty(batchNo)) {
            return Result.error("\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (batchNo.length() < 6) {
            return Result.error("\u6279\u6b21\u53f7\u9519\u8bef");
        }
        int n2 = this.automateConfigBean.getExport().getExpired();
        if (n2 > 0) {
            try {
                long l2 = Long.parseLong(batchNo.trim().substring(0, batchNo.length() - 6));
                if (DateUtils.a(DateUtils.DiffType.b, new Date(), new Date(l2)) > (long)n2) {
                    return Result.error("\u56e0\u8d85\u8fc7\u6709\u6548\u671f,\u8be5\u6587\u4ef6\u5df2\u88ab\u6e05\u7406");
                }
            }
            catch (NumberFormatException numberFormatException) {
                return Result.error("\u6279\u6b21\u53f7\u9519\u8bef");
            }
        }
        if (OkConvertUtils.isNotEmpty(signature)) {
            this.a(batchNo, signature);
        }
        if (!(file = new File(string2 = (string = this.autoAsyncTasks.getAtoExportDownloadPath()) + batchNo)).exists()) {
            return Result.error("\u4e0b\u8f7d\u76ee\u5f55\u4e0d\u5b58\u5728");
        }
        String string3 = batchNo + ".zip";
        String string4 = string + File.separator + string3;
        try {
            i.a(string4, string2);
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
        }
        i.a(this.response, string4, string3);
        return null;
    }

    private void a(String string, String string2) {
        if (OkConvertUtils.isEmpty(string2)) {
            a.error("\u4e0b\u8f7d\u6279\u91cf\u5bfc\u51fa\u62a5\u8868\u5931\u8d25:\u6587\u4ef6\u7b7e\u540d\u4e3a\u7a7a.");
            throw new JimuReportException("\u975e\u6cd5\u8bf7\u6c42");
        }
        JimuReportExportLog jimuReportExportLog = this.jimuReportExportLogDao.getByBatchNo(string);
        if (jimuReportExportLog == null) {
            a.error("\u4e0b\u8f7d\u6279\u91cf\u5bfc\u51fa\u62a5\u8868\u5931\u8d25:\u5bfc\u51fa\u8bb0\u5f55\u4e0d\u5b58\u5728.");
            throw new JimuReportException("\u5bfc\u51fa\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String string3 = jimuReportExportLog.getId();
        if (!string2.trim().equals(org.jeecg.modules.jmreport.automate.a.a.a(string3, string))) {
            a.error("\u4e0b\u8f7d\u6279\u91cf\u5bfc\u51fa\u62a5\u8868\u5931\u8d25:\u6587\u4ef6\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25.");
            throw new JimuReportException("\u975e\u6cd5\u8bf7\u6c42");
        }
        jimuReportExportLog.setUpdateTime(new Date());
    }

    @Override
    public Result<?> queryExportLogs(Integer pageNo, Integer pageSize, String batchNo, String fromId) {
        try {
            JimuReportExportLog jimuReportExportLog = new JimuReportExportLog();
            if (OkConvertUtils.isNotEmpty(batchNo)) {
                batchNo = "%" + (String)batchNo + "%";
            }
            jimuReportExportLog.setBatchNo((String)batchNo);
            jimuReportExportLog.setFromId(fromId);
            MiniDaoPage<JimuReportExportLog> miniDaoPage = this.jimuReportExportLogDao.pageList(jimuReportExportLog, pageNo, pageSize);
            JmPage<?> jmPage = g.a(miniDaoPage);
            return Result.OK(jmPage);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    @Override
    public Result<?> deleteExportLog(String id) {
        this.jimuReportExportLogDao.deleteById(id);
        return Result.OK("\u5220\u9664\u6210\u529f", true);
    }

    @PostConstruct
    public void a() {
        List<Object> list = new ArrayList();
        try {
            list = this.jimuReportExportJobDao.queryAllByStatus(1);
        }
        catch (Throwable throwable) {
            if (throwable.getCause() instanceof SQLSyntaxErrorException && throwable.getMessage().contains("doesn't exist")) {
                a.error("\u5bfc\u51fa\u4efb\u52a1\u8868(jimu_report_export_job)\u4e0d\u5b58\u5728\uff0c\u5b9a\u65f6\u5bfc\u51fa\u62a5\u8868\u529f\u80fd\u5c06\u65e0\u6cd5\u4f7f\u7528\u3002");
            }
            a.error(throwable.getMessage(), throwable);
        }
        for (JimuReportExportJob jimuReportExportJob : list) {
            try {
                this.a(jimuReportExportJob);
            }
            catch (Exception exception) {
                a.warn("\u542f\u52a8\u5b9a\u65f6\u5bfc\u51fa\u4efb\u52a1\u5931\u8d25:" + jimuReportExportJob.getId() + exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private Result<?> a(JimuReportExportJob jimuReportExportJob) {
        Object object;
        if (this.b.containsKey(jimuReportExportJob.getId())) {
            return Result.OK();
        }
        Date date = new Date();
        if (OkConvertUtils.isNotEmpty(jimuReportExportJob.getEndTime()) && jimuReportExportJob.getEndTime().before(date)) {
            return Result.error("\u5df2\u7ecf\u8d85\u8fc7\u622a\u6b62\u65f6\u95f4");
        }
        if (OkConvertUtils.isEmpty(jimuReportExportJob.getReportConf())) {
            return Result.error("\u8bf7\u5148\u914d\u7f6e\u9700\u8981\u5bfc\u51fa\u7684\u62a5\u8868");
        }
        try {
            object = JSONObject.parseArray((String)jimuReportExportJob.getReportConf());
            if (object.isEmpty()) {
                return Result.error("\u8bf7\u5148\u914d\u7f6e\u9700\u8981\u5bfc\u51fa\u7684\u62a5\u8868");
            }
        }
        catch (Exception exception) {
            return Result.error("\u8bf7\u5148\u914d\u7f6e\u9700\u8981\u5bfc\u51fa\u7684\u62a5\u8868");
        }
        object = () -> this.b(jimuReportExportJob);
        if (!CronExpression.isValidExpression((String)jimuReportExportJob.getExecInterval())) {
            return Result.error("\u6267\u884c\u9891\u7387\u4e0d\u662f\u4e00\u4e2a\u6b63\u786e\u7684Cron\u8868\u8fbe\u5f0f");
        }
        CronTrigger cronTrigger = new CronTrigger(jimuReportExportJob.getExecInterval());
        ScheduledFuture scheduledFuture = this.taskScheduler.schedule((Runnable)object, (Trigger)cronTrigger);
        this.b.put(jimuReportExportJob.getId(), scheduledFuture);
        return Result.OK();
    }

    private Result<?> b(JimuReportExportJob jimuReportExportJob) {
        Result<?> result = this.c(jimuReportExportJob);
        Date date = new Date();
        if (!result.isSuccess()) {
            a.error(result.getMessage());
        }
        jimuReportExportJob.setLastRunTime(date);
        this.jimuReportExportJobDao.update(jimuReportExportJob);
        if (OkConvertUtils.isNotEmpty(jimuReportExportJob.getEndTime()) && jimuReportExportJob.getEndTime().before(date)) {
            this.a(jimuReportExportJob.getId());
        }
        return result;
    }

    private Result<?> c(JimuReportExportJob jimuReportExportJob) {
        if (OkConvertUtils.isNotEmpty(jimuReportExportJob.getBeginTime()) && jimuReportExportJob.getBeginTime().after(new Date())) {
            return Result.error("\u672a\u5230\u5f00\u59cb\u65f6\u95f4");
        }
        String string = jimuReportExportJob.getReportConf();
        if (OkConvertUtils.isEmpty(string)) {
            return Result.error("\u8bf7\u5148\u914d\u7f6e\u62a5\u8868");
        }
        JSONArray jSONArray = null;
        try {
            jSONArray = JSONArray.parseArray((String)string);
        }
        catch (Exception exception) {
            return Result.error("\u8bf7\u5148\u914d\u7f6e\u62a5\u8868");
        }
        if (OkConvertUtils.isEmpty(jSONArray)) {
            return Result.error("\u8bf7\u5148\u914d\u7f6e\u62a5\u8868");
        }
        ArrayList<JimuReportAutoExportVO.a> arrayList = new ArrayList<JimuReportAutoExportVO.a>();
        jSONArray.stream().map(object -> (JSONObject)object).forEach(jSONObject -> {
            String string = jSONObject.getString("reportId");
            JimuReportAutoExportVO.a a2 = new JimuReportAutoExportVO.a();
            a2.setId(string);
            Object object = jSONObject.get((Object)"params");
            HashMap<String, String> hashMap = new HashMap();
            if (OkConvertUtils.isNotEmpty(object)) {
                hashMap = (Map)TypeUtils.castToJavaBean((Object)object, Map.class);
            }
            if (OkConvertUtils.isNotEmpty(hashMap)) {
                a2.setParams(hashMap);
            }
            if (OkConvertUtils.isNotEmpty(jSONObject.get((Object)"exportType"))) {
                a2.setExportType(jSONObject.getString("exportType"));
            }
            arrayList.add(a2);
        });
        JimuReportAutoExportVO jimuReportAutoExportVO = new JimuReportAutoExportVO();
        if (OkConvertUtils.isNotEmpty(jimuReportExportJob.getReceiverEmail())) {
            jimuReportAutoExportVO.setReceiverEmail(jimuReportExportJob.getReceiverEmail());
        }
        jimuReportAutoExportVO.setReportParams(arrayList);
        jimuReportAutoExportVO.setExportType("PDF");
        jimuReportAutoExportVO.setExportFrom("job");
        jimuReportAutoExportVO.setFromId(jimuReportExportJob.getId());
        jimuReportAutoExportVO.setFromName(jimuReportExportJob.getName());
        String string2 = this.jmReportBaseConfig.getApiBasePath();
        if (OkConvertUtils.isNotEmpty(string2)) {
            jimuReportAutoExportVO.setDomain(string2);
        }
        if (OkConvertUtils.isNotEmpty(jimuReportExportJob.getFileSyncPath())) {
            jimuReportAutoExportVO.setFileSyncPath(jimuReportExportJob.getFileSyncPath());
        }
        return this.autoExport(jimuReportAutoExportVO, !this.jimuRepAutomateConfigBean.getExport().a());
    }

    public Result<?> a(String string) {
        ScheduledFuture<?> scheduledFuture = this.b.get(string);
        if (scheduledFuture != null) {
            boolean bl = scheduledFuture.cancel(true);
            if (bl) {
                this.b.remove(string);
                return Result.OK();
            }
            return Result.error("\u64cd\u4f5c\u5931\u8d25");
        }
        return Result.OK();
    }

    @Override
    public Result<?> queryExportJob(Integer pageNo, Integer pageSize, String name) {
        try {
            JimuReportExportJob jimuReportExportJob = new JimuReportExportJob();
            if (OkConvertUtils.isNotEmpty(name)) {
                name = "%" + (String)name + "%";
            }
            jimuReportExportJob.setName((String)name);
            MiniDaoPage<JimuReportExportJob> miniDaoPage = this.jimuReportExportJobDao.pageList(jimuReportExportJob, pageNo, pageSize);
            JmPage<?> jmPage = g.a(miniDaoPage);
            return Result.OK(jmPage);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    @Override
    public Result<?> getExportJobDetail(String id) {
        JimuReportExportJob jimuReportExportJob = this.jimuReportExportJobDao.get(id);
        return Result.OK(jimuReportExportJob);
    }

    @Override
    public Result<?> saveExportJob(JimuReportExportJob jimuReportExportJob) {
        if (OkConvertUtils.isEmpty(jimuReportExportJob.getBeginTime())) {
            jimuReportExportJob.setBeginTime(new Date());
        }
        if (OkConvertUtils.isEmpty(jimuReportExportJob.getStatus())) {
            jimuReportExportJob.setStatus(0);
        }
        if (OkConvertUtils.isEmpty(jimuReportExportJob.getExecInterval())) {
            return Result.error("\u8bf7\u8f93\u5165\u6267\u884c\u9891\u7387");
        }
        if (!CronExpression.isValidExpression((String)jimuReportExportJob.getExecInterval())) {
            return Result.error("\u6267\u884c\u9891\u7387\u9700\u8981\u4f7f\u7528\u6b63\u786e\u7684Cron\u8868\u8fbe\u5f0f");
        }
        if (OkConvertUtils.isNotEmpty(jimuReportExportJob.getFileSyncPath()) && !i.b(jimuReportExportJob.getFileSyncPath())) {
            return Result.error("\u540c\u6b65\u76ee\u5f55\u4e0d\u53ef\u4ee5\u4f7f\u7528\u4e0a\u4e00\u7ea7\u8def\u5f84(../)");
        }
        if (OkConvertUtils.isEmpty(jimuReportExportJob.getId())) {
            this.jimuReportExportJobDao.insert(jimuReportExportJob);
        } else {
            this.jimuReportExportJobDao.update(jimuReportExportJob);
        }
        return Result.OK();
    }

    @Override
    public Result<?> deleteExportJob(String id) {
        JimuReportExportJob jimuReportExportJob = this.jimuReportExportJobDao.get(id);
        if (OkConvertUtils.isEmpty(jimuReportExportJob)) {
            return Result.OK();
        }
        if (OkConvertUtils.isNotEmpty(jimuReportExportJob.getStatus()) && 1 == jimuReportExportJob.getStatus()) {
            return Result.error("\u4e0d\u80fd\u5220\u9664\u542f\u52a8\u4e2d\u7684\u5bfc\u51fa\u4efb\u52a1");
        }
        int n2 = this.jimuReportExportJobDao.deleteById(id);
        if (n2 > 0) {
            return Result.OK();
        }
        return Result.error("\u5220\u9664\u5931\u8d25");
    }

    @Override
    public Result<?> updateExportJobStatus(JimuReportExportJob jimuReportExportJob) {
        if (OkConvertUtils.isEmpty(jimuReportExportJob.getId())) {
            return Result.error("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JimuReportExportJob jimuReportExportJob2 = this.jimuReportExportJobDao.get(jimuReportExportJob.getId());
        if (OkConvertUtils.isEmpty(jimuReportExportJob2)) {
            return Result.error("\u5bfc\u51fa\u8ba1\u5212\u6570\u636e\u4e0d\u5b58\u5728");
        }
        jimuReportExportJob2.setStatus(jimuReportExportJob.getStatus());
        Result<Object> result = Result.error("\u64cd\u4f5c\u5931\u8d25");
        result = 1 == jimuReportExportJob2.getStatus() ? this.a(jimuReportExportJob2) : this.a(jimuReportExportJob2.getId());
        if (result.isSuccess()) {
            this.jimuReportExportJobDao.update(jimuReportExportJob2);
        }
        return result;
    }

    @Override
    public Result<?> runNow(String jobId) {
        if (OkConvertUtils.isEmpty(jobId)) {
            return Result.error("\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u4efb\u52a1");
        }
        JimuReportExportJob jimuReportExportJob = this.jimuReportExportJobDao.get(jobId);
        if (OkConvertUtils.isEmpty(jimuReportExportJob)) {
            return Result.error("\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        return this.b(jimuReportExportJob);
    }
}

