/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.config.client;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jeecg.modules.jmreport.api.JmReportTokenServiceI;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.common.util.e;
import org.jeecg.modules.jmreport.config.JmReportBaseConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;

@Component(value="jmReportTokenClient")
public class JmReportTokenClient {
    private static final Logger log = LoggerFactory.getLogger(JmReportTokenClient.class);
    @Autowired(required=false)
    private JmReportTokenServiceI jimuTokenService;
    @Autowired(required=false)
    private JmReportBaseConfig jmBaseConfig;

    public boolean isTokenServiceImplemented() {
        return null != this.jimuTokenService;
    }

    public String[] getRoles(HttpServletRequest request) {
        if (OkConvertUtils.isNotEmpty(this.jimuTokenService)) {
            return this.jimuTokenService.getRoles(this.getToken(request));
        }
        return null;
    }

    public String getToken(HttpServletRequest request) {
        String string = "";
        if (OkConvertUtils.isNotEmpty(this.jimuTokenService)) {
            string = this.jimuTokenService.getToken(request);
        }
        return string;
    }

    public String getToken() {
        String string = "";
        if (OkConvertUtils.isNotEmpty(this.jimuTokenService)) {
            string = this.jimuTokenService.getToken();
        }
        return string;
    }

    public String getUsername(String token) {
        String string = "";
        if (OkConvertUtils.isNotEmpty(this.jimuTokenService) && OkConvertUtils.isNotEmpty(token)) {
            try {
                string = this.jimuTokenService.getUsername(token);
            }
            catch (Exception exception) {
                log.error(exception.getMessage(), (Throwable)exception);
            }
        }
        return string;
    }

    public String getUsername(HttpServletRequest request) {
        String string;
        String string2 = "";
        String string3 = this.getToken(request);
        if (OkConvertUtils.isNotEmpty(this.jimuTokenService) && OkConvertUtils.isNotEmpty(string3)) {
            try {
                string2 = this.jimuTokenService.getUsername(string3);
            }
            catch (Exception exception) {
                log.error(exception.getMessage(), (Throwable)exception);
            }
        }
        if (OkConvertUtils.isEmpty(string = request.getHeader("JmReport-Share-Token"))) {
            string = request.getParameter("shareToken");
        }
        if ("created".equals(this.jmBaseConfig.getSaasMode()) && OkConvertUtils.isEmpty(string)) {
            if (OkConvertUtils.isEmpty(string3)) {
                throw new JimuReportException("token\u83b7\u53d6\u4e3a\u7a7a\uff0c\u8bf7\u5b9e\u73b0JmReportTokenServiceI\u4e2d\u7684getToken\u65b9\u6cd5\uff01");
            }
            if (OkConvertUtils.isEmpty(string2)) {
                throw new JimuReportException("\u7528\u6237\u8d26\u53f7\u83b7\u53d6\u4e3a\u7a7a\uff0c\u8bf7\u5b9e\u73b0JmReportTokenServiceI\u4e2d\u7684getUsername\u65b9\u6cd5\uff01");
            }
        }
        return string2;
    }

    public String getUsername() {
        String string = "";
        try {
            String string2 = this.getToken();
            if (OkConvertUtils.isNotEmpty(this.jimuTokenService) && OkConvertUtils.isNotEmpty(string2)) {
                string = this.jimuTokenService.getUsername(string2);
            }
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
        return string;
    }

    public Boolean verifyToken(HttpServletRequest request) {
        Boolean bl = true;
        if (OkConvertUtils.isNotEmpty(this.jimuTokenService)) {
            String string = this.getToken(request);
            bl = this.jimuTokenService.verifyToken(string);
        }
        return bl;
    }

    @Deprecated
    public Map<String, Object> getUserInfo(String token) {
        Map<String, Object> map = null;
        if (OkConvertUtils.isNotEmpty(this.jimuTokenService) && OkConvertUtils.isNotEmpty(token)) {
            try {
                map = this.jimuTokenService.getUserInfo(token);
                if (map == null) {
                    map = new HashMap<String, Object>(5);
                }
                Date date = new Date();
                if (map.get("sysDate") == null) {
                    map.put("sysDate", e.b(date));
                }
                if (map.get("sysDateTime") == null) {
                    map.put("sysDateTime", e.a(date));
                }
            }
            catch (Exception exception) {
                log.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38: " + exception.getMessage());
            }
        }
        return map;
    }

    public Map<String, Object> getUserInformation(String token) {
        Map<String, Object> map = new HashMap<String, Object>(5);
        if (OkConvertUtils.isNotEmpty(this.jimuTokenService)) {
            try {
                if (OkConvertUtils.isEmpty(token) && OkConvertUtils.isEmpty(token = this.jimuTokenService.getToken())) {
                    return map;
                }
                map = this.jimuTokenService.getUserInfo(token);
            }
            catch (Exception exception) {
                log.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38: " + exception.getMessage());
            }
        }
        return map;
    }

    public HttpHeaders customApiHeader() {
        HttpHeaders httpHeaders = null;
        if (OkConvertUtils.isNotEmpty(this.jimuTokenService)) {
            httpHeaders = this.jimuTokenService.customApiHeader();
        }
        return httpHeaders;
    }

    public String getTenantId() {
        String string = "";
        try {
            if (OkConvertUtils.isNotEmpty(this.jimuTokenService)) {
                string = this.jimuTokenService.getTenantId();
            }
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
        if (OkConvertUtils.isEmpty(string)) {
            return null;
        }
        return string;
    }

    public String[] getPermissions(HttpServletRequest request) {
        if (OkConvertUtils.isNotEmpty(this.jimuTokenService)) {
            return this.jimuTokenService.getPermissions(this.getToken(request));
        }
        return null;
    }
}

