/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.config.firewall.interceptor.handlers;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import org.jeecg.modules.jmreport.common.annotation.Logical;
import org.jeecg.modules.jmreport.common.annotation.RequiresPermissions;
import org.jeecg.modules.jmreport.common.annotation.RequiresRoles;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.jeecg.modules.jmreport.config.client.JmReportTokenClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class JmIPermissionsVerifyHandler {
    private static final Logger log = LoggerFactory.getLogger(JmIPermissionsVerifyHandler.class);
    @Autowired
    private JmReportTokenClient jimuTokenClient;
    private static final Integer GEN_TEST_DATA_CODE = 402;

    public Result<?> verifyPermissions(HttpServletRequest request, RequiresPermissions requiresPermissions) {
        if (requiresPermissions == null) {
            return Result.OK();
        }
        Object[] objectArray = requiresPermissions.value();
        String[] stringArray = this.jimuTokenClient.getPermissions(request);
        boolean bl = false;
        if (OkConvertUtils.isNotEmpty(stringArray) && OkConvertUtils.isNotEmpty(objectArray)) {
            Object[] objectArray2 = objectArray;
            Logical logical = requiresPermissions.logical();
            bl = Logical.AND.equals((Object)logical) ? Arrays.stream(objectArray2).allMatch(code -> OkConvertUtils.isIn(code, stringArray)) : Arrays.stream(stringArray).anyMatch(arg_0 -> JmIPermissionsVerifyHandler.lambda$verifyPermissions$1((String[])objectArray2, arg_0));
        }
        if (!bl) {
            if (OkConvertUtils.isEmpty(objectArray)) {
                objectArray = new String[]{};
            }
            log.error("Subject does not have permission {}", (Object)Arrays.toString(objectArray));
        }
        return bl ? Result.OK() : Result.error("\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u914d\u6743\u9650\uff01");
    }

    public Result<?> verifyRoles(HttpServletRequest request, RequiresRoles requiresRoles, String requestPath) {
        if (requiresRoles == null) {
            return Result.OK();
        }
        String[] stringArray = requiresRoles.value();
        String[] stringArray2 = this.jimuTokenClient.getRoles(request);
        Integer n2 = 500;
        if (OkConvertUtils.isEmpty(stringArray2)) {
            log.error("\u6b64\u63a5\u53e3\u9700\u8981\u89d2\u8272\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01\u8bf7\u6c42\u65e0\u6743\u9650(" + request.getMethod() + ")\uff1a" + requestPath);
            if ("/jmreport/loadTableData".equals(requestPath)) {
                n2 = GEN_TEST_DATA_CODE;
            }
            return Result.error(n2, "\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u914d\u89d2\u8272\uff01");
        }
        Logical logical = requiresRoles.logical();
        boolean bl = Logical.AND.equals((Object)logical) ? Arrays.stream(stringArray).allMatch(code -> OkConvertUtils.isIn(code, stringArray2)) : Arrays.stream(stringArray2).anyMatch(code -> OkConvertUtils.isIn(code, stringArray));
        if (!bl) {
            log.error("\u6b64\u63a5\u53e3\u9700\u8981\u89d2\u8272\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01\u8bf7\u6c42\u65e0\u6743\u9650(" + request.getMethod() + ")\uff1a" + requestPath);
            if ("/jmreport/loadTableData".equals(requestPath)) {
                n2 = GEN_TEST_DATA_CODE;
            }
            return Result.error(n2, "\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u914d\u89d2\u8272\uff01");
        }
        return Result.OK();
    }

    private static /* synthetic */ boolean lambda$verifyPermissions$1(String[] finalPermissions, String code) {
        return OkConvertUtils.isIn(code, finalPermissions);
    }
}

