/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.control;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.control.configs.ControlConfigs;
import com.alibaba.nacos.plugin.control.configs.ControlConfigsInitializer;
import com.alibaba.nacos.sys.env.EnvUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SpringValueConfigsInitializer
implements ControlConfigsInitializer {
    @Value(value="${nacos.plugin.control.tps.barrier.creator:nacos}")
    private String tpsBarrierCreator = "nacos";
    @Value(value="${nacos.plugin.control.tps.barrier.rule.creator:nacos}")
    private String tpsRuleBarrierCreator = "nacos";
    @Value(value="${nacos.plugin.control.connection.runtime.ejector:nacos}")
    private String connectionRuntimeEjector = "nacos";
    @Value(value="${nacos.plugin.control.connection.manager:nacos}")
    private String connectionManager = "nacos";
    @Value(value="${nacos.plugin.control.tps.manager:nacos}")
    private String tpsManager = "nacos";
    @Value(value="${nacos.plugin.control.rule.external.storage:}")
    private String ruleExternalStorage = "";
    @Value(value="${nacos.plugin.control.rule.parser:nacos}")
    private String ruleParser = "nacos";
    @Value(value="${nacos.plugin.control.rule.local.basedir:}")
    private String localRuleStorageBaseDir = "";

    public void initialize(ControlConfigs controlConfigs) {
        controlConfigs.setTpsManager(this.tpsManager);
        controlConfigs.setTpsBarrierCreator(this.tpsBarrierCreator);
        controlConfigs.setTpsRuleBarrierCreator(this.tpsRuleBarrierCreator);
        controlConfigs.setConnectionRuntimeEjector(this.connectionRuntimeEjector);
        controlConfigs.setConnectionManager(this.connectionManager);
        controlConfigs.setRuleParser(this.ruleParser);
        if (StringUtils.isNotBlank((String)this.localRuleStorageBaseDir)) {
            controlConfigs.setLocalRuleStorageBaseDir(this.localRuleStorageBaseDir);
        } else {
            controlConfigs.setLocalRuleStorageBaseDir(EnvUtil.getNacosHome());
        }
        controlConfigs.setRuleExternalStorage(this.ruleExternalStorage);
    }
}

