/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.utils;

import com.alibaba.nacos.common.cache.Cache;
import com.alibaba.nacos.common.cache.builder.CacheBuilder;
import java.util.concurrent.TimeUnit;

public class StringPool {
    private static final Cache<String, String> GROUP_KEY_CACHE = CacheBuilder.builder().maximumSize(5000000).expireNanos(180L, TimeUnit.SECONDS).lru(true).build();

    public static String get(String key) {
        if (key == null) {
            return key;
        }
        String value = (String)GROUP_KEY_CACHE.get((Object)key);
        if (value == null) {
            GROUP_KEY_CACHE.put((Object)key, (Object)key);
            value = (String)GROUP_KEY_CACHE.get((Object)key);
        }
        return value == null ? key : value;
    }

    public static long size() {
        return GROUP_KEY_CACHE.getSize();
    }

    public static void remove(String key) {
        GROUP_KEY_CACHE.remove((Object)key);
    }
}

