/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.extension;

import java.util.Optional;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.commons.util.ToStringBuilder;

@API(status=API.Status.STABLE, since="5.0")
public class ConditionEvaluationResult {
    private final boolean enabled;
    private final Optional<String> reason;

    public static ConditionEvaluationResult enabled(@Nullable String reason) {
        return new ConditionEvaluationResult(true, reason);
    }

    public static ConditionEvaluationResult disabled(@Nullable String reason) {
        return new ConditionEvaluationResult(false, reason);
    }

    @API(status=API.Status.STABLE, since="5.7")
    public static ConditionEvaluationResult disabled(@Nullable String reason, @Nullable String customReason) {
        if (StringUtils.isBlank((String)reason)) {
            return ConditionEvaluationResult.disabled(customReason);
        }
        if (StringUtils.isBlank((String)customReason)) {
            return ConditionEvaluationResult.disabled(reason);
        }
        return ConditionEvaluationResult.disabled("%s ==> %s".formatted(reason.strip(), customReason.strip()));
    }

    private ConditionEvaluationResult(boolean enabled, @Nullable String reason) {
        this.enabled = enabled;
        this.reason = StringUtils.isNotBlank((String)reason) ? Optional.of(reason.strip()) : Optional.empty();
    }

    public boolean isDisabled() {
        return !this.enabled;
    }

    public Optional<String> getReason() {
        return this.reason;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("enabled", (Object)this.enabled).append("reason", (Object)this.reason.orElse("<unknown>")).toString();
    }
}

