/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.EngineExecutionContext;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestExecutorService;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.hierarchical.NodeTestTaskContext;
import org.junit.platform.engine.support.hierarchical.NodeUtils;
import org.junit.platform.engine.support.hierarchical.ResourceLock;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

class NodeTestTask<C extends EngineExecutionContext>
implements HierarchicalTestExecutorService.TestTask {
    private static final Logger logger = LoggerFactory.getLogger(NodeTestTask.class);
    private static final Runnable NOOP = () -> {};
    static final Node.SkipResult CANCELLED_SKIP_RESULT = Node.SkipResult.skip("Execution cancelled");
    private final NodeTestTaskContext taskContext;
    private final TestDescriptor testDescriptor;
    private final Node<C> node;
    private final Runnable finalizer;
    private @Nullable C parentContext;
    private @Nullable C context;
    private @Nullable Node.SkipResult skipResult;
    private boolean started;
    private @Nullable ThrowableCollector throwableCollector;

    NodeTestTask(NodeTestTaskContext taskContext, TestDescriptor testDescriptor) {
        this(taskContext, testDescriptor, NOOP);
    }

    NodeTestTask(NodeTestTaskContext taskContext, TestDescriptor testDescriptor, Runnable finalizer) {
        this.taskContext = taskContext;
        this.testDescriptor = testDescriptor;
        this.node = NodeUtils.asNode(testDescriptor);
        this.finalizer = finalizer;
    }

    @Override
    public ResourceLock getResourceLock() {
        return this.taskContext.executionAdvisor().getResourceLock(this.testDescriptor);
    }

    @Override
    public Node.ExecutionMode getExecutionMode() {
        return this.taskContext.executionAdvisor().getForcedExecutionMode(this.testDescriptor).orElseGet(this.node::getExecutionMode);
    }

    @Override
    public TestDescriptor getTestDescriptor() {
        return this.testDescriptor;
    }

    public String toString() {
        return "NodeTestTask [" + String.valueOf(this.testDescriptor) + "]";
    }

    void setParentContext(@Nullable C parentContext) {
        this.parentContext = parentContext;
    }

    @Override
    public void execute() {
        try {
            this.throwableCollector = this.taskContext.throwableCollectorFactory().create();
            if (!this.taskContext.cancellationToken().isCancellationRequested()) {
                this.prepare();
            }
            if (this.throwableCollector.isEmpty()) {
                this.throwableCollector.execute(() -> {
                    this.skipResult = this.checkWhetherSkipped();
                });
            }
            if (this.throwableCollector.isEmpty() && !this.requiredSkipResult().isSkipped()) {
                this.executeRecursively();
            }
            if (this.context != null) {
                this.cleanUp();
            }
            this.reportCompletion();
        }
        finally {
            if (Thread.interrupted()) {
                logger.debug(() -> "Execution of TestDescriptor with display name [%s] and unique ID [%s] failed to clear the 'interrupted status' flag for the current thread. JUnit has cleared the flag, but you may wish to investigate why the flag was not cleared by user code.".formatted(this.testDescriptor.getDisplayName(), this.testDescriptor.getUniqueId()));
            }
            this.finalizer.run();
        }
        this.context = null;
    }

    private void prepare() {
        this.requiredThrowableCollector().execute(() -> {
            this.context = this.node.prepare((EngineExecutionContext)Objects.requireNonNull(this.parentContext));
        });
        this.parentContext = null;
    }

    private Node.SkipResult checkWhetherSkipped() throws Exception {
        return this.taskContext.cancellationToken().isCancellationRequested() ? CANCELLED_SKIP_RESULT : this.node.shouldBeSkipped(this.requiredContext());
    }

    private void executeRecursively() {
        this.taskContext.listener().executionStarted(this.testDescriptor);
        this.started = true;
        ThrowableCollector throwableCollector = this.requiredThrowableCollector();
        throwableCollector.execute(() -> this.node.around((EngineExecutionContext)this.requiredContext(), ctx -> {
            this.context = ctx;
            throwableCollector.execute(() -> {
                List children = this.testDescriptor.getChildren().stream().map(descriptor -> new NodeTestTask<C>(this.taskContext, (TestDescriptor)descriptor)).collect(Collectors.toCollection(ArrayList::new));
                this.context = this.node.before(this.requiredContext());
                DefaultDynamicTestExecutor dynamicTestExecutor = new DefaultDynamicTestExecutor();
                this.context = this.node.execute(this.requiredContext(), dynamicTestExecutor);
                if (!children.isEmpty()) {
                    children.forEach(child -> child.setParentContext(this.context));
                    this.taskContext.executorService().invokeAll(children);
                }
                throwableCollector.execute(dynamicTestExecutor::awaitFinished);
            });
            throwableCollector.execute(() -> this.node.after(this.requiredContext()));
        }));
    }

    private void cleanUp() {
        this.requiredThrowableCollector().execute(() -> this.node.cleanUp(this.requiredContext()));
    }

    private void reportCompletion() {
        ThrowableCollector throwableCollector = this.requiredThrowableCollector();
        if (throwableCollector.isEmpty() && this.requiredSkipResult().isSkipped()) {
            Node.SkipResult skipResult = this.requiredSkipResult();
            try {
                this.node.nodeSkipped((EngineExecutionContext)Objects.requireNonNullElse(this.context, this.parentContext), this.testDescriptor, skipResult);
            }
            catch (Throwable throwable) {
                UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)throwable);
                logger.debug(throwable, () -> "Failed to invoke nodeSkipped() on Node %s".formatted(this.testDescriptor.getUniqueId()));
            }
            this.taskContext.listener().executionSkipped(this.testDescriptor, skipResult.getReason().orElse("<unknown>"));
            return;
        }
        if (!this.started) {
            this.taskContext.listener().executionStarted(this.testDescriptor);
        }
        try {
            this.node.nodeFinished(this.requiredContext(), this.testDescriptor, throwableCollector.toTestExecutionResult());
        }
        catch (Throwable throwable) {
            UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)throwable);
            logger.debug(throwable, () -> "Failed to invoke nodeFinished() on Node %s".formatted(this.testDescriptor.getUniqueId()));
        }
        this.taskContext.listener().executionFinished(this.testDescriptor, throwableCollector.toTestExecutionResult());
        this.throwableCollector = null;
    }

    private C requiredContext() {
        return (C)((EngineExecutionContext)Objects.requireNonNull(this.context));
    }

    private Node.SkipResult requiredSkipResult() {
        return Objects.requireNonNull(this.skipResult);
    }

    private ThrowableCollector requiredThrowableCollector() {
        return Objects.requireNonNull(this.throwableCollector);
    }

    private class DefaultDynamicTestExecutor
    implements Node.DynamicTestExecutor {
        private final Map<UniqueId, DynamicTaskState> unfinishedTasks = new ConcurrentHashMap<UniqueId, DynamicTaskState>();

        private DefaultDynamicTestExecutor() {
        }

        @Override
        public void execute(TestDescriptor testDescriptor) {
            this.execute(testDescriptor, NodeTestTask.this.taskContext.listener());
        }

        @Override
        public Future<?> execute(TestDescriptor testDescriptor, EngineExecutionListener executionListener) {
            Preconditions.notNull((Object)testDescriptor, (String)"testDescriptor must not be null");
            Preconditions.notNull((Object)executionListener, (String)"executionListener must not be null");
            executionListener.dynamicTestRegistered(testDescriptor);
            Set<ExclusiveResource> exclusiveResources = NodeUtils.asNode(testDescriptor).getExclusiveResources();
            if (!exclusiveResources.isEmpty()) {
                executionListener.executionStarted(testDescriptor);
                String message = "Dynamic test descriptors must not declare exclusive resources: " + String.valueOf(exclusiveResources);
                executionListener.executionFinished(testDescriptor, TestExecutionResult.failed((Throwable)new JUnitException(message)));
                return CompletableFuture.completedFuture(null);
            }
            UniqueId uniqueId = testDescriptor.getUniqueId();
            NodeTestTask nodeTestTask = new NodeTestTask(NodeTestTask.this.taskContext.withListener(executionListener), testDescriptor, () -> this.unfinishedTasks.remove(uniqueId));
            nodeTestTask.setParentContext(NodeTestTask.this.context);
            this.unfinishedTasks.put(uniqueId, DynamicTaskState.unscheduled());
            Future<@Nullable Void> future = NodeTestTask.this.taskContext.executorService().submit(nodeTestTask);
            this.unfinishedTasks.computeIfPresent(uniqueId, (__, state) -> DynamicTaskState.scheduled(future));
            return future;
        }

        @Override
        public void awaitFinished() throws InterruptedException {
            for (DynamicTaskState state : this.unfinishedTasks.values()) {
                try {
                    state.awaitFinished();
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException e) {
                    throw ExceptionUtils.throwAsUncheckedException((Throwable)Objects.requireNonNullElse(e.getCause(), e));
                }
            }
        }
    }

    @FunctionalInterface
    private static interface DynamicTaskState {
        public static final DynamicTaskState UNSCHEDULED = () -> {};

        public static DynamicTaskState unscheduled() {
            return UNSCHEDULED;
        }

        public static DynamicTaskState scheduled(Future<@Nullable Void> future) {
            return future::get;
        }

        public void awaitFinished() throws CancellationException, ExecutionException, InterruptedException;
    }
}

