/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.commandline;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.joran.spi.ConsoleTarget;
import ch.qos.logback.core.spi.FilterReply;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import liquibase.CatalogAndSchema;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.change.CheckSum;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.command.AbstractSelfConfiguratingCommand;
import liquibase.command.CommandFactory;
import liquibase.command.CommandResult;
import liquibase.command.LiquibaseCommand;
import liquibase.command.core.DropAllCommand;
import liquibase.command.core.ExecuteSqlCommand;
import liquibase.command.core.HistoryCommand;
import liquibase.command.core.SnapshotCommand;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.StandardObjectChangeFilter;
import liquibase.exception.CommandLineParsingException;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationFailedException;
import liquibase.integration.commandline.ChangeExecListenerUtils;
import liquibase.integration.commandline.CommandLineResourceAccessor;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.license.LicenseInstallResult;
import liquibase.license.LicenseService;
import liquibase.license.LicenseServiceFactory;
import liquibase.license.Location;
import liquibase.license.LocationType;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.LogLevel;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.servicelocator.ServiceLocator;
import liquibase.util.ISODateFormat;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StringUtils;
import liquibase.util.xml.XMLResourceBundle;
import liquibase.util.xml.XmlResourceBundleControl;
import org.slf4j.LoggerFactory;

public class Main {
    private static final String ERRORMSG_UNEXPECTED_PARAMETERS = "unexpected.command.parameters";
    private static final liquibase.logging.Logger LOG = LogService.getLog(Main.class);
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    private static XMLResourceBundle commandLineHelpBundle = (XMLResourceBundle)ResourceBundle.getBundle("liquibase/i18n/liquibase-commandline-helptext", new XmlResourceBundleControl());
    protected ClassLoader classLoader;
    protected String driver;
    protected String username;
    protected String password;
    protected String url;
    protected String databaseClass;
    protected String defaultSchemaName;
    protected String outputDefaultSchema;
    protected String outputDefaultCatalog;
    protected String liquibaseCatalogName;
    protected String liquibaseSchemaName;
    protected String databaseChangeLogTableName;
    protected String databaseChangeLogLockTableName;
    protected String databaseChangeLogTablespaceName;
    protected String defaultCatalogName;
    protected String changeLogFile;
    protected String overwriteOutputFile;
    protected String classpath;
    protected String contexts;
    protected String labels;
    protected String driverPropertiesFile;
    protected String propertyProviderClass;
    protected String changeExecListenerClass;
    protected String changeExecListenerPropertiesFile;
    protected Boolean promptForNonLocalDatabase;
    protected Boolean includeSystemClasspath;
    protected Boolean strict = Boolean.TRUE;
    protected String defaultsFile = "liquibase.properties";
    protected String diffTypes;
    protected String changeSetAuthor;
    protected String changeSetContext;
    protected String dataOutputDirectory;
    protected String referenceDriver;
    protected String referenceUrl;
    protected String referenceUsername;
    protected String referencePassword;
    protected String referenceDefaultCatalogName;
    protected String referenceDefaultSchemaName;
    protected String currentDateTimeFunction;
    protected String command;
    protected Set<String> commandParams = new LinkedHashSet<String>();
    protected String logLevel;
    protected String logFile;
    protected Map<String, Object> changeLogParameters = new HashMap<String, Object>();
    protected String outputFile;
    protected String excludeObjects;
    protected Boolean includeCatalog;
    protected String includeObjects;
    protected Boolean includeSchema;
    protected Boolean includeTablespace;
    protected String outputSchemasAs;
    protected String referenceSchemas;
    protected String schemas;
    protected String snapshotFormat;
    protected String liquibaseProLicenseKey;
    private boolean liquibaseProLicenseValid = false;
    private Boolean managingLogConfig = null;
    private boolean outputsLogMessages = false;
    protected String sqlFile;
    protected String delimiter;
    protected String rollbackScript;
    private static int[] suspiciousCodePoints = new int[]{160, 225, 226, 227, 228, 229, 230, 198, 200, 201, 202, 203, 204, 205, 206, 207, 209, 210, 211, 212, 213, 214, 217, 218, 219, 220, 222, 223, 232, 233, 234, 235, 236, 237, 238, 239, 241, 249, 250, 251, 252, 255, 284, 332, 333, 334, 335, 336, 337, 359, 360, 361, 362, 363, 364, 365, 366, 367, 377, 399, 8192, 8193, 8194, 8196, 8197, 8199, 8200, 8201, 8202, 8203, 8211, 8287};

    public static void main(String[] args) {
        int errorLevel = 0;
        try {
            errorLevel = Main.run(args);
        }
        catch (Throwable e2) {
            System.exit(-1);
        }
        System.exit(errorLevel);
    }

    public static int run(String[] args) throws LiquibaseException {
        Main main = null;
        liquibase.logging.Logger log = null;
        try {
            main = new Main();
            main.reconfigureLogging();
            log = LogService.getLog(Main.class);
        }
        catch (Throwable e2) {
            e2.printStackTrace(System.err);
            System.exit(-1);
        }
        try {
            List<String> setupMessages;
            GlobalConfiguration globalConfiguration = LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class);
            if (!globalConfiguration.getShouldRun()) {
                log.warning(LogType.USER_MESSAGE, String.format(coreBundle.getString("did.not.run.because.param.was.set.to.false"), LiquibaseConfiguration.getInstance().describeValueLookupLogic(globalConfiguration.getProperty("shouldRun"))));
                return 0;
            }
            if (args.length == 0 || args.length == 1 && "--help".equals(args[0])) {
                main.printHelp(System.out);
                return 0;
            }
            if ("--version".equals(args[0])) {
                main.command = "";
                main.reconfigureLogging();
                main.parseDefaultPropertyFiles();
                PrintStream stream = System.out;
                stream.println(CommandLineUtils.getBanner());
                stream.println(String.format(coreBundle.getString("version.number"), LiquibaseUtil.getBuildVersion()));
                LicenseService licenseService = LicenseServiceFactory.getInstance().getLicenseService();
                if (licenseService != null) {
                    if (main.liquibaseProLicenseKey == null) {
                        log.info(LogType.LOG, "The command '" + main.command + "' requires a Liquibase Pro license, available at http://liquibase.org.");
                    } else {
                        Location licenseKeyLocation = new Location("property liquibaseProLicenseKey", LocationType.BASE64_STRING, main.liquibaseProLicenseKey);
                        LicenseInstallResult result = licenseService.installLicense(licenseKeyLocation);
                        if (result.code != 0) {
                            String allMessages = String.join((CharSequence)"\n", result.messages);
                            log.warning(LogType.USER_MESSAGE, allMessages);
                        }
                    }
                    stream.println(licenseService.getLicenseInfo());
                }
                stream.println(String.format("Running Java under %s (Version %s)", System.getProperties().getProperty("java.home"), System.getProperty("java.version")));
                return 0;
            }
            for (int i2 = 0; i2 < args.length; ++i2) {
                CodePointCheck codePointCheck = Main.checkArg(args[i2]);
                if (codePointCheck == null) continue;
                String message = "A non-standard character '" + codePointCheck.ch + "' was detected on the command line at position " + (codePointCheck.position + 1) + " of argument number " + (i2 + 1) + ".\nIf problems occur, please remove the character and try again.";
                LOG.warning(message);
                System.err.println(message);
            }
            try {
                main.parseOptions(args);
            }
            catch (CommandLineParsingException e3) {
                log.info(LogType.USER_MESSAGE, CommandLineUtils.getBanner());
                log.warning(LogType.USER_MESSAGE, coreBundle.getString("how.to.display.help"));
                throw e3;
            }
            main.reconfigureLogging();
            log.info(LogType.LOG, CommandLineUtils.getBanner());
            LicenseService licenseService = LicenseServiceFactory.getInstance().getLicenseService();
            if (licenseService != null) {
                if (main.liquibaseProLicenseKey == null) {
                    log.info(LogType.LOG, "No Liquibase Pro license key supplied. Please set liquibaseProLicenseKey on command line or in liquibase.properties to use Liquibase Pro features.");
                } else {
                    Location licenseKeyLocation = new Location("property liquibaseProLicenseKey", LocationType.BASE64_STRING, main.liquibaseProLicenseKey);
                    LicenseInstallResult result = licenseService.installLicense(licenseKeyLocation);
                    if (result.code != 0) {
                        String allMessages = String.join((CharSequence)"\n", result.messages);
                        log.warning(LogType.USER_MESSAGE, allMessages);
                    } else {
                        main.liquibaseProLicenseValid = true;
                    }
                }
                if (licenseService.daysTilExpiration() < 0) {
                    main.liquibaseProLicenseValid = false;
                }
                log.info(LogType.USER_MESSAGE, licenseService.getLicenseInfo());
            }
            if (!(main.commandParams.contains("--help") && (main.command.startsWith("rollbackOneChangeSet") || main.command.startsWith("rollbackOneUpdate")) || (setupMessages = main.checkSetup()).isEmpty())) {
                main.printHelp(setupMessages, Main.isStandardOutputRequired(main.command) ? System.err : System.out);
                return 1;
            }
            main.applyDefaults();
            main.configureClassLoader();
            main.doMigration();
            if ("update".equals(main.command)) {
                log.info(LogType.USER_MESSAGE, coreBundle.getString("update.successful"));
            } else if (main.command.startsWith("rollback") && !main.command.endsWith("SQL")) {
                log.info(LogType.USER_MESSAGE, coreBundle.getString("rollback.successful"));
            } else if (!main.command.endsWith("SQL")) {
                log.info(LogType.USER_MESSAGE, String.format(coreBundle.getString("command.successful"), main.command));
            }
        }
        catch (Throwable e4) {
            String message = e4.getMessage();
            if (e4.getCause() != null) {
                message = e4.getCause().getMessage();
            }
            if (message == null) {
                message = coreBundle.getString("unknown.reason");
            }
            try {
                if (e4.getCause() instanceof ValidationFailedException) {
                    ((ValidationFailedException)e4.getCause()).printDescriptiveError(System.out);
                } else if (main.outputsLogMessages) {
                    log.severe(LogType.USER_MESSAGE, String.format(coreBundle.getString("unexpected.error"), message), e4);
                } else {
                    log.severe(LogType.USER_MESSAGE, String.format(coreBundle.getString("unexpected.error"), message));
                    log.severe(LogType.USER_MESSAGE, coreBundle.getString("for.more.information.use.loglevel.flag"));
                    log.severe(LogType.LOG, String.format(coreBundle.getString("unexpected.error"), message), e4);
                }
            }
            catch (IllegalFormatException e1) {
                e1.printStackTrace();
            }
            throw new LiquibaseException(String.format(coreBundle.getString("unexpected.error"), message), e4);
        }
        return 0;
    }

    protected void reconfigureLogging() {
        ConsoleFilter userOutput;
        ch.qos.logback.classic.Level logLevel;
        org.slf4j.Logger configuredLogger = LoggerFactory.getLogger((String)"ROOT");
        if (this.managingLogConfig == null) {
            ArrayList<String> appenders = new ArrayList<String>();
            if ("ch.qos.logback.classic.Logger".equals(configuredLogger.getClass().getName())) {
                Iterator appenderIterator = ((Logger)configuredLogger).iteratorForAppenders();
                while (appenderIterator.hasNext()) {
                    Appender next = (Appender)appenderIterator.next();
                    appenders.add(next.getName());
                }
                if (appenders.size() == 1 && ((String)appenders.get(0)).equals("console")) {
                    this.managingLogConfig = true;
                } else {
                    LogService.getLog(this.getClass()).debug("Custom logging config found, not going to modify");
                    this.managingLogConfig = false;
                }
            } else {
                System.err.println("Liquibase command line logging cannot be configured; a supported org.slf4j.Logger implementation is not on the classpath.");
                this.managingLogConfig = false;
            }
        }
        if (!this.managingLogConfig.booleanValue()) {
            return;
        }
        if (this.command == null) {
            return;
        }
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        if (this.logLevel == null) {
            logLevel = ch.qos.logback.classic.Level.OFF;
        } else {
            if (this.logLevel.equalsIgnoreCase(LogLevel.DEBUG.name())) {
                this.logLevel = ch.qos.logback.classic.Level.DEBUG.toString();
            } else if (this.logLevel.equalsIgnoreCase(LogLevel.INFO.name())) {
                this.logLevel = ch.qos.logback.classic.Level.INFO.toString();
            } else if (this.logLevel.equalsIgnoreCase(LogLevel.WARNING.name())) {
                this.logLevel = ch.qos.logback.classic.Level.WARN.toString();
            } else if (this.logLevel.equalsIgnoreCase(LogLevel.SEVERE.name())) {
                this.logLevel = ch.qos.logback.classic.Level.ERROR.toString();
            }
            if (this.logLevel.equalsIgnoreCase(Level.FINE.toString()) || this.logLevel.equalsIgnoreCase(Level.FINER.toString()) || this.logLevel.equalsIgnoreCase(Level.FINEST.toString())) {
                this.logLevel = ch.qos.logback.classic.Level.DEBUG.toString();
            } else if (this.logLevel.equalsIgnoreCase(Level.INFO.toString())) {
                this.logLevel = ch.qos.logback.classic.Level.INFO.toString();
            } else if (this.logLevel.equalsIgnoreCase(Level.WARNING.toString())) {
                this.logLevel = ch.qos.logback.classic.Level.WARN.toString();
            } else if (this.logLevel.equalsIgnoreCase(Level.SEVERE.toString())) {
                this.logLevel = ch.qos.logback.classic.Level.ERROR.toString();
            }
            logLevel = ch.qos.logback.classic.Level.toLevel((String)this.logLevel);
        }
        rootLogger.setLevel(ch.qos.logback.classic.Level.DEBUG);
        ConsoleAppender consoleAppender = new ConsoleAppender();
        consoleAppender.setContext((Context)rootLogger.getLoggerContext());
        consoleAppender.setName("liquibase-cli");
        PatternLayoutEncoder logMessagePattern = new PatternLayoutEncoder();
        logMessagePattern.setContext((Context)rootLogger.getLoggerContext());
        logMessagePattern.setPattern("%d{HH:mm:ss.SSS} %-5level [%logger]: %message%n");
        logMessagePattern.start();
        if (Main.isStandardOutputRequired(this.command)) {
            consoleAppender.setTarget(ConsoleTarget.SystemErr.getName());
        }
        FileAppender fileAppender = null;
        if (this.logFile != null) {
            fileAppender = new FileAppender();
            fileAppender.setContext((Context)rootLogger.getLoggerContext());
            fileAppender.setEncoder((Encoder)logMessagePattern);
            fileAppender.setFile(this.logFile);
            fileAppender.setAppend(true);
            ch.qos.logback.classic.Level fileLogLevel = logLevel;
            if (logLevel == ch.qos.logback.classic.Level.OFF) {
                fileLogLevel = ch.qos.logback.classic.Level.DEBUG;
            } else {
                logLevel = ch.qos.logback.classic.Level.OFF;
            }
            ConsoleFilter logOutputFilter = new ConsoleFilter(fileLogLevel, new LogType[0]);
            logOutputFilter.start();
            fileAppender.addFilter((Filter)logOutputFilter);
            fileAppender.start();
        }
        if (logLevel == ch.qos.logback.classic.Level.OFF) {
            userOutput = new ConsoleFilter(logLevel, LogType.USER_MESSAGE);
            userOutput.setContext((Context)rootLogger.getLoggerContext());
            userOutput.start();
            PatternLayoutEncoder userMessagePattern = new PatternLayoutEncoder();
            userMessagePattern.setContext((Context)rootLogger.getLoggerContext());
            userMessagePattern.setPattern("%msg%n");
            userMessagePattern.start();
            consoleAppender.setEncoder((Encoder)userMessagePattern);
            consoleAppender.addFilter((Filter)userOutput);
        } else {
            userOutput = new ConsoleFilter(logLevel, new LogType[0]);
            userOutput.setContext((Context)rootLogger.getLoggerContext());
            userOutput.start();
            consoleAppender.setEncoder((Encoder)logMessagePattern);
            consoleAppender.addFilter((Filter)userOutput);
            this.outputsLogMessages = true;
        }
        consoleAppender.start();
        Iterator appenderIterator = rootLogger.iteratorForAppenders();
        while (appenderIterator.hasNext()) {
            Appender next = (Appender)appenderIterator.next();
            next.stop();
            rootLogger.detachAppender(next);
        }
        rootLogger.addAppender((Appender)consoleAppender);
        if (fileAppender != null) {
            rootLogger.addAppender((Appender)fileAppender);
        }
    }

    private static String[] splitArg(String arg) throws CommandLineParsingException {
        String[] splitArg = arg.split("=", 2);
        if (splitArg.length < 2) {
            throw new CommandLineParsingException(String.format(coreBundle.getString("could.not.parse.expression"), arg));
        }
        splitArg[0] = splitArg[0].replaceFirst("--", "");
        return splitArg;
    }

    private static boolean isStandardOutputRequired(String command) {
        return "snapshot".equalsIgnoreCase(command) || "snapshotReference".equalsIgnoreCase(command) || "changelogSyncSQL".equalsIgnoreCase(command) || "markNextChangeSetRanSQL".equalsIgnoreCase(command) || "updateCountSQL".equalsIgnoreCase(command) || "updateToTagSQL".equalsIgnoreCase(command) || "updateSQL".equalsIgnoreCase(command) || "rollbackSQL".equalsIgnoreCase(command) || "rollbackToDateSQL".equalsIgnoreCase(command) || "rollbackCountSQL".equalsIgnoreCase(command) || "futureRollbackSQL".equalsIgnoreCase(command) || "futureRollbackCountSQL".equalsIgnoreCase(command) || "futureRollbackFromTagSQL".equalsIgnoreCase(command);
    }

    private static boolean isChangeLogRequired(String command) {
        return command.toLowerCase().startsWith("update") || command.toLowerCase().startsWith("rollback") && !command.equalsIgnoreCase("rollbackOneChangeSet") && !command.equalsIgnoreCase("rollbackOneUpdate") || "calculateCheckSum".equalsIgnoreCase(command) || "status".equalsIgnoreCase(command) || "validate".equalsIgnoreCase(command) || "changelogSync".equalsIgnoreCase(command) || "changelogSyncSQL".equalsIgnoreCase(command) || "generateChangeLog".equalsIgnoreCase(command) || "diffChangeLog".equalsIgnoreCase(command) || "rollbackOneChangeSet".equalsIgnoreCase(command) || "rollbackOneUpdate".equalsIgnoreCase(command);
    }

    private static boolean isCommand(String arg) {
        return "migrate".equals(arg) || "migrateSQL".equalsIgnoreCase(arg) || "update".equalsIgnoreCase(arg) || "updateSQL".equalsIgnoreCase(arg) || "updateCount".equalsIgnoreCase(arg) || "updateCountSQL".equalsIgnoreCase(arg) || "updateToTag".equalsIgnoreCase(arg) || "updateToTagSQL".equalsIgnoreCase(arg) || "rollback".equalsIgnoreCase(arg) || "rollbackToDate".equalsIgnoreCase(arg) || "rollbackCount".equalsIgnoreCase(arg) || "rollbackSQL".equalsIgnoreCase(arg) || "rollbackToDateSQL".equalsIgnoreCase(arg) || "rollbackCountSQL".equalsIgnoreCase(arg) || "futureRollbackSQL".equalsIgnoreCase(arg) || "futureRollbackCountSQL".equalsIgnoreCase(arg) || "futureRollbackToTagSQL".equalsIgnoreCase(arg) || "updateTestingRollback".equalsIgnoreCase(arg) || "tag".equalsIgnoreCase(arg) || "tagExists".equalsIgnoreCase(arg) || "listLocks".equalsIgnoreCase(arg) || "history".equalsIgnoreCase(arg) || "dropAll".equalsIgnoreCase(arg) || "releaseLocks".equalsIgnoreCase(arg) || "status".equalsIgnoreCase(arg) || "unexpectedChangeSets".equalsIgnoreCase(arg) || "validate".equalsIgnoreCase(arg) || "help".equalsIgnoreCase(arg) || "diff".equalsIgnoreCase(arg) || "diffChangeLog".equalsIgnoreCase(arg) || "generateChangeLog".equalsIgnoreCase(arg) || "snapshot".equalsIgnoreCase(arg) || "snapshotReference".equalsIgnoreCase(arg) || "executeSql".equalsIgnoreCase(arg) || "calculateCheckSum".equalsIgnoreCase(arg) || "clearCheckSums".equalsIgnoreCase(arg) || "dbDoc".equalsIgnoreCase(arg) || "changelogSync".equalsIgnoreCase(arg) || "changelogSyncSQL".equalsIgnoreCase(arg) || "markNextChangeSetRan".equalsIgnoreCase(arg) || "markNextChangeSetRanSQL".equalsIgnoreCase(arg) || "rollbackOneChangeSet".equalsIgnoreCase(arg) || "rollbackOneChangeSetSQL".equalsIgnoreCase(arg) || "rollbackOneUpdate".equalsIgnoreCase(arg) || "rollbackOneUpdateSQL".equalsIgnoreCase(arg);
    }

    private static boolean isNoArgCommand(String arg) {
        return "migrate".equals(arg) || "migrateSQL".equalsIgnoreCase(arg) || "update".equalsIgnoreCase(arg) || "updateSQL".equalsIgnoreCase(arg) || "futureRollbackSQL".equalsIgnoreCase(arg) || "updateTestingRollback".equalsIgnoreCase(arg) || "listLocks".equalsIgnoreCase(arg) || "dropAll".equalsIgnoreCase(arg) || "releaseLocks".equalsIgnoreCase(arg) || "validate".equalsIgnoreCase(arg) || "help".equalsIgnoreCase(arg) || "clearCheckSums".equalsIgnoreCase(arg) || "changelogSync".equalsIgnoreCase(arg) || "changelogSyncSQL".equalsIgnoreCase(arg) || "markNextChangeSetRan".equalsIgnoreCase(arg) || "markNextChangeSetRanSQL".equalsIgnoreCase(arg);
    }

    private static void addWarFileClasspathEntries(File classPathFile, List<URL> urls) throws IOException {
        URL jarUrl = new URL("jar:" + classPathFile.toURI().toURL() + "!/WEB-INF/classes/");
        LOG.info(LogType.LOG, "adding '" + jarUrl + "' to classpath");
        urls.add(jarUrl);
        try (JarFile warZip = new JarFile(classPathFile);){
            Enumeration<JarEntry> entries = warZip.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith("WEB-INF/lib") || !entry.getName().toLowerCase().endsWith(".jar")) continue;
                File jar = Main.extract(warZip, entry);
                URL newUrl = new URL("jar:" + jar.toURI().toURL() + "!/");
                LOG.info(LogType.LOG, "adding '" + newUrl + "' to classpath");
                urls.add(newUrl);
                jar.deleteOnExit();
            }
        }
    }

    private static File extract(JarFile jar, JarEntry entry) throws IOException {
        File tempFile = File.createTempFile("liquibase.tmp", null);
        try (BufferedInputStream inStream = new BufferedInputStream(jar.getInputStream(entry));
             BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(tempFile));){
            int status;
            while ((status = inStream.read()) != -1) {
                outStream.write(status);
            }
        }
        return tempFile;
    }

    protected void parseDefaultPropertyFiles() throws CommandLineParsingException {
        File[] potentialPropertyFiles = new File[2];
        potentialPropertyFiles[0] = new File(this.defaultsFile);
        String localDefaultsPathName = this.defaultsFile.replaceFirst("(\\.[^\\.]+)$", ".local$1");
        potentialPropertyFiles[1] = new File(localDefaultsPathName);
        for (File potentialPropertyFile : potentialPropertyFiles) {
            try {
                if (potentialPropertyFile.exists()) {
                    this.parseDefaultPropertyFileFromFile(potentialPropertyFile);
                    continue;
                }
                this.parseDefaultPropertyFileFromResource(potentialPropertyFile);
            }
            catch (IOException e2) {
                throw new CommandLineParsingException(e2);
            }
        }
    }

    private void parseDefaultPropertyFileFromResource(File potentialPropertyFile) throws IOException, CommandLineParsingException {
        try (InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(potentialPropertyFile.getAbsolutePath());){
            if (resourceAsStream != null) {
                this.parsePropertiesFile(resourceAsStream);
            }
        }
    }

    private void parseDefaultPropertyFileFromFile(File potentialPropertyFile) throws IOException, CommandLineParsingException {
        try (FileInputStream stream = new FileInputStream(potentialPropertyFile);){
            this.parsePropertiesFile(stream);
        }
    }

    protected String[] fixupArgs(String[] args) {
        ArrayList<String> fixedArgs = new ArrayList<String>();
        for (int i2 = 0; i2 < args.length; ++i2) {
            String arg = args[i2];
            if ((arg.startsWith("--") || arg.startsWith("-D")) && !arg.contains("=")) {
                String nextArg = null;
                if (i2 + 1 < args.length) {
                    nextArg = args[i2 + 1];
                }
                if (nextArg != null && !nextArg.startsWith("--") && !Main.isCommand(nextArg)) {
                    arg = arg + "=" + nextArg;
                    ++i2;
                }
            }
            arg = arg.replace("\\,", ",");
            fixedArgs.add(arg);
        }
        return fixedArgs.toArray(new String[fixedArgs.size()]);
    }

    protected List<String> checkSetup() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.command == null) {
            messages.add(coreBundle.getString("command.not.passed"));
        } else if (!Main.isCommand(this.command)) {
            messages.add(String.format(coreBundle.getString("command.unknown"), this.command));
        } else {
            if (StringUtils.trimToNull(this.url) == null) {
                messages.add(String.format(coreBundle.getString("option.required"), "--url"));
            }
            if (Main.isChangeLogRequired(this.command) && StringUtils.trimToNull(this.changeLogFile) == null) {
                messages.add(String.format(coreBundle.getString("option.required"), "--changeLogFile"));
            }
            if (Main.isNoArgCommand(this.command) && !this.commandParams.isEmpty()) {
                messages.add(coreBundle.getString(ERRORMSG_UNEXPECTED_PARAMETERS) + this.commandParams);
            } else {
                this.validateCommandParameters(messages);
            }
        }
        return messages;
    }

    private void checkForUnexpectedCommandParameter(List<String> messages) {
        block16: {
            block18: {
                block17: {
                    block15: {
                        if (!"updateCount".equalsIgnoreCase(this.command) && !"updateCountSQL".equalsIgnoreCase(this.command) && !"updateToTag".equalsIgnoreCase(this.command) && !"updateToTagSQL".equalsIgnoreCase(this.command) && !"calculateCheckSum".equalsIgnoreCase(this.command) && !"dbDoc".equalsIgnoreCase(this.command) && !"tag".equalsIgnoreCase(this.command) && !"tagExists".equalsIgnoreCase(this.command)) break block15;
                        if (this.commandParams.isEmpty() || !this.commandParams.iterator().next().startsWith("-")) break block16;
                        messages.add(coreBundle.getString(ERRORMSG_UNEXPECTED_PARAMETERS) + this.commandParams);
                        break block16;
                    }
                    if (!"status".equalsIgnoreCase(this.command) && !"unexpectedChangeSets".equalsIgnoreCase(this.command)) break block17;
                    if (this.commandParams.isEmpty() || this.commandParams.iterator().next().equalsIgnoreCase("--verbose")) break block16;
                    messages.add(coreBundle.getString(ERRORMSG_UNEXPECTED_PARAMETERS) + this.commandParams);
                    break block16;
                }
                if (!"diff".equalsIgnoreCase(this.command) && !"diffChangeLog".equalsIgnoreCase(this.command)) break block18;
                if (this.commandParams.isEmpty()) break block16;
                for (String cmdParm : this.commandParams) {
                    if (cmdParm.startsWith("--referenceUsername") || cmdParm.startsWith("--referencePassword") || cmdParm.startsWith("--referenceDriver") || cmdParm.startsWith("--referenceDefaultCatalogName") || cmdParm.startsWith("--referenceDefaultSchemaName") || cmdParm.startsWith("--includeSchema") || cmdParm.startsWith("--includeCatalog") || cmdParm.startsWith("--includeTablespace") || cmdParm.startsWith("--schemas") || cmdParm.startsWith("--outputSchemasAs") || cmdParm.startsWith("--referenceSchemas") || cmdParm.startsWith("--referenceUrl") || cmdParm.startsWith("--excludeObjects") || cmdParm.startsWith("--includeObjects") || cmdParm.startsWith("--diffTypes") || cmdParm.startsWith("--snapshotFormat")) continue;
                    messages.add(String.format(coreBundle.getString("unexpected.command.parameter"), cmdParm));
                }
                break block16;
            }
            if (("snapshot".equalsIgnoreCase(this.command) || "generateChangeLog".equalsIgnoreCase(this.command)) && !this.commandParams.isEmpty()) {
                for (String cmdParm : this.commandParams) {
                    if (cmdParm.startsWith("--includeSchema") || cmdParm.startsWith("--includeCatalog") || cmdParm.startsWith("--includeTablespace") || cmdParm.startsWith("--schemas") || cmdParm.startsWith("--snapshotFormat") || cmdParm.startsWith("--dataOutputDirectory") || cmdParm.startsWith("--outputSchemasAs")) continue;
                    messages.add(String.format(coreBundle.getString("unexpected.command.parameter"), cmdParm));
                }
            } else if ("rollbackOneChangeSet".equalsIgnoreCase(this.command)) {
                for (String cmdParm : this.commandParams) {
                    if (cmdParm.startsWith("--changeSetId") || cmdParm.startsWith("--help") || cmdParm.startsWith("--force") || cmdParm.startsWith("--changeSetPath") || cmdParm.startsWith("--changeSetAuthor") || cmdParm.startsWith("--rollbackScript")) continue;
                    messages.add(String.format(coreBundle.getString("unexpected.command.parameter"), cmdParm));
                }
            } else if ("rollbackOneChangeSetSQL".equalsIgnoreCase(this.command)) {
                for (String cmdParm : this.commandParams) {
                    if (cmdParm.startsWith("--changeSetId") || cmdParm.startsWith("--help") || cmdParm.startsWith("--force") || cmdParm.startsWith("--changeSetPath") || cmdParm.startsWith("--changeSetAuthor") || cmdParm.startsWith("--rollbackScript")) continue;
                    messages.add(String.format(coreBundle.getString("unexpected.command.parameter"), cmdParm));
                }
            } else if ("rollbackOneUpdate".equalsIgnoreCase(this.command)) {
                for (String cmdParm : this.commandParams) {
                    if (cmdParm.startsWith("--deploymentId") || cmdParm.startsWith("--help") || cmdParm.startsWith("--force")) continue;
                    messages.add(String.format(coreBundle.getString("unexpected.command.parameter"), cmdParm));
                }
            } else if ("rollbackOneUpdateSQL".equalsIgnoreCase(this.command)) {
                for (String cmdParm : this.commandParams) {
                    if (cmdParm.startsWith("--deploymentId") || cmdParm.startsWith("--help") || cmdParm.startsWith("--force")) continue;
                    messages.add(String.format(coreBundle.getString("unexpected.command.parameter"), cmdParm));
                }
            }
        }
    }

    private void validateCommandParameters(List<String> messages) {
        this.checkForUnexpectedCommandParameter(messages);
        this.checkForMissingCommandParameters(messages);
        this.checkForMalformedCommandParameters(messages);
    }

    private void checkForMissingCommandParameters(List<String> messages) {
        if ((this.commandParams.isEmpty() || this.commandParams.iterator().next().startsWith("-")) && "calculateCheckSum".equalsIgnoreCase(this.command)) {
            messages.add(coreBundle.getString("changeset.identifier.missing"));
        }
    }

    private void checkForMalformedCommandParameters(List<String> messages) {
        if (this.commandParams.isEmpty()) {
            return;
        }
        int CHANGESET_MINIMUM_IDENTIFIER_PARTS = 3;
        if ("calculateCheckSum".equalsIgnoreCase(this.command)) {
            for (String param : this.commandParams) {
                String[] parts;
                if (param == null || param.startsWith("-") || (parts = param.split("::")).length >= 3) continue;
                messages.add(coreBundle.getString("changeset.identifier.must.have.form.filepath.id.author"));
                break;
            }
        } else if ("diffChangeLog".equalsIgnoreCase(this.command) && this.diffTypes != null && this.diffTypes.toLowerCase().contains("data")) {
            messages.add(String.format(coreBundle.getString("including.data.diffchangelog.has.no.effect"), "diffTypes", "generateChangeLog"));
        }
    }

    protected void parsePropertiesFile(InputStream propertiesInputStream) throws IOException, CommandLineParsingException {
        Properties props = new Properties();
        props.load(propertiesInputStream);
        if (props.containsKey("strict")) {
            this.strict = Boolean.valueOf(props.getProperty("strict"));
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            try {
                if ("promptOnNonLocalDatabase".equals(entry.getKey())) continue;
                if (((String)entry.getKey()).startsWith("parameter.")) {
                    this.changeLogParameters.put(((String)entry.getKey()).replaceFirst("^parameter.", ""), entry.getValue());
                    continue;
                }
                Field field = this.getClass().getDeclaredField((String)entry.getKey());
                Object currentValue = field.get(this);
                if (currentValue != null) continue;
                String value = entry.getValue().toString().trim();
                if (field.getType().equals(Boolean.class)) {
                    field.set(this, Boolean.valueOf(value));
                    continue;
                }
                field.set(this, value);
            }
            catch (NoSuchFieldException ignored) {
                if (this.strict.booleanValue()) {
                    throw new CommandLineParsingException(String.format(coreBundle.getString("parameter.unknown"), entry.getKey()));
                }
                LogService.getLog(this.getClass()).warning(LogType.LOG, String.format(coreBundle.getString("parameter.ignored"), entry.getKey()));
            }
            catch (IllegalAccessException e2) {
                throw new UnexpectedLiquibaseException(String.format(coreBundle.getString("parameter.unknown"), entry.getKey()));
            }
        }
    }

    protected void printHelp(List<String> errorMessages, PrintStream stream) {
        stream.println(coreBundle.getString("errors"));
        for (String message : errorMessages) {
            stream.println("  " + message);
        }
        stream.println();
    }

    protected void printHelp(PrintStream stream) {
        Main main = null;
        main = new Main();
        this.logLevel = ch.qos.logback.classic.Level.ERROR.toString();
        main.reconfigureLogging();
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        rootLogger.setLevel(ch.qos.logback.classic.Level.ERROR);
        stream.println(CommandLineUtils.getBanner());
        String helpText = commandLineHelpBundle.getString("commandline-helptext");
        stream.println(helpText);
    }

    protected static CodePointCheck checkArg(String arg) {
        char[] chars = arg.toCharArray();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            for (int j2 = 0; j2 < suspiciousCodePoints.length; ++j2) {
                if (suspiciousCodePoints[j2] != chars[i2]) continue;
                CodePointCheck codePointCheck = new CodePointCheck();
                codePointCheck.position = i2;
                codePointCheck.ch = chars[i2];
                return codePointCheck;
            }
        }
        return null;
    }

    protected void parseOptions(String[] paramArgs) throws CommandLineParsingException {
        String[] args = this.fixupArgs(paramArgs);
        boolean seenCommand = false;
        for (String arg : args) {
            if (Main.isCommand(arg)) {
                this.command = arg;
                if (this.command.equalsIgnoreCase("migrate")) {
                    this.command = "update";
                } else if (this.command.equalsIgnoreCase("migrateSQL")) {
                    this.command = "updateSQL";
                }
                seenCommand = true;
                continue;
            }
            if (seenCommand) {
                if (arg.startsWith("-D")) {
                    String[] splitArg = Main.splitArg(arg);
                    String attributeName = splitArg[0].replaceFirst("^-D", "");
                    String value = splitArg[1];
                    this.changeLogParameters.put(attributeName, value);
                    continue;
                }
                this.commandParams.add(arg);
                if (!arg.startsWith("--")) continue;
                this.parseOptionArgument(arg, true);
                continue;
            }
            if (arg.startsWith("--")) {
                this.parseOptionArgument(arg, false);
                continue;
            }
            throw new CommandLineParsingException(String.format(coreBundle.getString("unexpected.value"), arg));
        }
        this.parseDefaultPropertyFiles();
    }

    private void parseOptionArgument(String arg, boolean okIfNotAField) throws CommandLineParsingException {
        block8: {
            String PROMPT_FOR_VALUE = "PROMPT";
            if (arg.toLowerCase().startsWith("--verbose")) {
                return;
            }
            if (arg.toLowerCase().equals("--force") || arg.toLowerCase().equals("--help")) {
                arg = arg + "=true";
            }
            String[] splitArg = Main.splitArg(arg);
            String attributeName = splitArg[0];
            String value = splitArg[1];
            if ("PROMPT".equalsIgnoreCase(StringUtils.trimToEmpty(value))) {
                Console c2 = System.console();
                if (c2 == null) {
                    throw new CommandLineParsingException(String.format(MessageFormat.format(coreBundle.getString("cannot.prompt.for.the.value.no.console"), attributeName), new Object[0]));
                }
                value = attributeName.toLowerCase().contains("password") ? new String(c2.readPassword(attributeName + ": ", new Object[0])) : c2.readLine(attributeName + ": ", new Object[0]);
            }
            try {
                Field field = this.getClass().getDeclaredField(attributeName);
                if (field.getType().equals(Boolean.class)) {
                    field.set(this, Boolean.valueOf(value));
                } else {
                    field.set(this, value);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e2) {
                if (okIfNotAField) break block8;
                throw new CommandLineParsingException(String.format(coreBundle.getString("option.unknown"), attributeName));
            }
        }
    }

    protected void applyDefaults() {
        if (this.promptForNonLocalDatabase == null) {
            this.promptForNonLocalDatabase = Boolean.FALSE;
        }
        if (this.logLevel == null) {
            this.logLevel = "off";
        }
        if (this.includeSystemClasspath == null) {
            this.includeSystemClasspath = Boolean.TRUE;
        }
        if (this.outputDefaultCatalog == null) {
            this.outputDefaultCatalog = "true";
        }
        if (this.outputDefaultSchema == null) {
            this.outputDefaultSchema = "true";
        }
        if (this.defaultsFile == null) {
            this.defaultsFile = "liquibase.properties";
        }
        if (this.includeSchema == null) {
            this.includeSchema = false;
        }
        if (this.includeCatalog == null) {
            this.includeCatalog = false;
        }
        if (this.includeTablespace == null) {
            this.includeTablespace = false;
        }
    }

    protected void configureClassLoader() throws CommandLineParsingException {
        final ArrayList<URL> urls = new ArrayList<URL>();
        if (this.classpath != null) {
            String[] classpathSoFar = this.isWindows() ? this.classpath.split(";") : this.classpath.split(":");
            for (String classpathEntry : classpathSoFar) {
                File classPathFile = new File(classpathEntry);
                if (!classPathFile.exists()) {
                    throw new CommandLineParsingException(String.format(coreBundle.getString("does.not.exist"), classPathFile.getAbsolutePath()));
                }
                if (classpathEntry.endsWith(".war")) {
                    try {
                        Main.addWarFileClasspathEntries(classPathFile, urls);
                        continue;
                    }
                    catch (IOException e2) {
                        throw new CommandLineParsingException(e2);
                    }
                }
                if (classpathEntry.endsWith(".ear")) {
                    try (JarFile earZip = new JarFile(classPathFile);){
                        Enumeration<JarEntry> entries = earZip.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            if (entry.getName().toLowerCase().endsWith(".jar")) {
                                File jar = Main.extract(earZip, entry);
                                URL newUrl = new URL("jar:" + jar.toURI().toURL() + "!/");
                                urls.add(newUrl);
                                LOG.debug(LogType.LOG, String.format(coreBundle.getString("adding.to.classpath"), newUrl));
                                jar.deleteOnExit();
                                continue;
                            }
                            if (!entry.getName().toLowerCase().endsWith("war")) continue;
                            File warFile = Main.extract(earZip, entry);
                            Main.addWarFileClasspathEntries(warFile, urls);
                        }
                        continue;
                    }
                    catch (IOException e3) {
                        throw new CommandLineParsingException(e3);
                    }
                }
                URL newUrl = null;
                try {
                    newUrl = new File(classpathEntry).toURI().toURL();
                }
                catch (MalformedURLException e4) {
                    throw new CommandLineParsingException(e4);
                }
                LOG.debug(LogType.LOG, String.format(coreBundle.getString("adding.to.classpath"), newUrl));
                urls.add(newUrl);
            }
        }
        this.classLoader = this.includeSystemClasspath != false ? (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader());
            }
        }) : (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
            }
        });
        ServiceLocator.getInstance().setResourceAccessor(new ClassLoaderResourceAccessor(this.classLoader));
        Thread.currentThread().setContextClassLoader(this.classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doMigration() throws Exception {
        if ("help".equalsIgnoreCase(this.command)) {
            this.printHelp(System.err);
            return;
        }
        if (("rollbackOneChangeSet".equals(this.command) || "rollbackOneChangeSetSQL".equals(this.command) || "rollbackOneUpdate".equals(this.command) || "rollbackOneUpdateSQL".equals(this.command)) && !this.commandParams.contains("--help") && !this.liquibaseProLicenseValid) {
            String messageString = String.format(coreBundle.getString("no.pro.license.found"), this.command);
            throw new LiquibaseException(messageString);
        }
        FileSystemResourceAccessor fsOpener = new FileSystemResourceAccessor();
        CommandLineResourceAccessor clOpener = new CommandLineResourceAccessor(this.classLoader);
        CompositeResourceAccessor fileOpener = new CompositeResourceAccessor(fsOpener, clOpener);
        Database database = null;
        if (this.url != null) {
            database = CommandLineUtils.createDatabaseObject(fileOpener, this.url, this.username, this.password, this.driver, this.defaultCatalogName, this.defaultSchemaName, Boolean.parseBoolean(this.outputDefaultCatalog), Boolean.parseBoolean(this.outputDefaultSchema), this.databaseClass, this.driverPropertiesFile, this.propertyProviderClass, this.liquibaseCatalogName, this.liquibaseSchemaName, this.databaseChangeLogTableName, this.databaseChangeLogLockTableName);
            database.setLiquibaseTablespaceName(this.databaseChangeLogTablespaceName);
        }
        try {
            HashMap<String, Object> argsMap;
            Object outputWriter4;
            ChangeLogParameters clp;
            HashMap<String, Object> argsMap2;
            SnapshotCommand snapshotCommand;
            if (this.excludeObjects != null && this.includeObjects != null) {
                throw new UnexpectedLiquibaseException(String.format(coreBundle.getString("cannot.specify.both"), "excludeObjects", "includeObjects"));
            }
            boolean b2 = this.dataOutputDirectory != null;
            LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).setShouldSnapshotData(b2);
            StandardObjectChangeFilter objectChangeFilter = null;
            CompareControl.ComputedSchemas computedSchemas = CompareControl.computeSchemas(this.schemas, this.referenceSchemas, this.outputSchemasAs, this.defaultCatalogName, this.defaultSchemaName, this.referenceDefaultCatalogName, this.referenceDefaultSchemaName, database);
            CompareControl.SchemaComparison[] finalSchemaComparisons = computedSchemas.finalSchemaComparisons;
            DiffOutputControl diffOutputControl = new DiffOutputControl(this.includeCatalog, this.includeSchema, this.includeTablespace, finalSchemaComparisons);
            if (this.excludeObjects != null) {
                objectChangeFilter = new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.EXCLUDE, this.excludeObjects);
                diffOutputControl.setObjectChangeFilter(objectChangeFilter);
            }
            if (this.includeObjects != null) {
                objectChangeFilter = new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.INCLUDE, this.includeObjects);
                diffOutputControl.setObjectChangeFilter(objectChangeFilter);
            }
            for (CompareControl.SchemaComparison schema : finalSchemaComparisons) {
                diffOutputControl.addIncludedSchema(schema.getReferenceSchema());
                diffOutputControl.addIncludedSchema(schema.getComparisonSchema());
            }
            if ("diff".equalsIgnoreCase(this.command)) {
                CommandLineUtils.doDiff(this.createReferenceDatabaseFromCommandParams(this.commandParams, fileOpener), database, StringUtils.trimToNull(this.diffTypes), finalSchemaComparisons, objectChangeFilter, new PrintStream(this.getOutputStream()));
                return;
            }
            if ("diffChangeLog".equalsIgnoreCase(this.command)) {
                CommandLineUtils.doDiffToChangeLog(this.changeLogFile, this.createReferenceDatabaseFromCommandParams(this.commandParams, fileOpener), database, diffOutputControl, objectChangeFilter, StringUtils.trimToNull(this.diffTypes), finalSchemaComparisons);
                return;
            }
            if ("generateChangeLog".equalsIgnoreCase(this.command)) {
                File file;
                String currentChangeLogFile = this.changeLogFile;
                if (currentChangeLogFile == null) {
                    currentChangeLogFile = "";
                }
                if ((file = new File(currentChangeLogFile)).exists() && !Boolean.parseBoolean(this.overwriteOutputFile)) {
                    throw new LiquibaseException(String.format(coreBundle.getString("changelogfile.already.exists"), currentChangeLogFile));
                }
                try {
                    if (file.delete()) {
                        // empty if block
                    }
                }
                catch (SecurityException e2) {
                    throw new LiquibaseException(String.format(coreBundle.getString("attempt.to.delete.the.file.failed.cannot.continue"), currentChangeLogFile), e2);
                }
                CatalogAndSchema[] finalTargetSchemas = computedSchemas.finalTargetSchemas;
                CommandLineUtils.doGenerateChangeLog(currentChangeLogFile, database, finalTargetSchemas, StringUtils.trimToNull(this.diffTypes), StringUtils.trimToNull(this.changeSetAuthor), StringUtils.trimToNull(this.changeSetContext), StringUtils.trimToNull(this.dataOutputDirectory), diffOutputControl);
                return;
            }
            if ("snapshot".equalsIgnoreCase(this.command)) {
                snapshotCommand = (SnapshotCommand)CommandFactory.getInstance().getCommand("snapshot");
                snapshotCommand.setDatabase(database);
                snapshotCommand.setSchemas(this.getSchemaParams(database));
                snapshotCommand.setSerializerFormat(this.getCommandParam("snapshotFormat", null));
                Writer outputWriter2 = this.getOutputWriter();
                String result = ((SnapshotCommand.SnapshotCommandResult)snapshotCommand.execute()).print();
                outputWriter2.write(result);
                outputWriter2.flush();
                outputWriter2.close();
                return;
            }
            if ("executeSql".equalsIgnoreCase(this.command)) {
                ExecuteSqlCommand executeSqlCommand = (ExecuteSqlCommand)CommandFactory.getInstance().getCommand("executeSql");
                executeSqlCommand.setDatabase(database);
                executeSqlCommand.setSql(this.getCommandParam("sql", null));
                executeSqlCommand.setSqlFile(this.getCommandParam("sqlFile", null));
                executeSqlCommand.setDelimiter(this.getCommandParam("delimiter", ";"));
                Writer outputWriter3 = this.getOutputWriter();
                outputWriter3.write(((CommandResult)executeSqlCommand.execute()).print());
                outputWriter3.flush();
                outputWriter3.close();
                return;
            }
            if ("snapshotReference".equalsIgnoreCase(this.command)) {
                snapshotCommand = (SnapshotCommand)CommandFactory.getInstance().getCommand("snapshot");
                Database referenceDatabase = this.createReferenceDatabaseFromCommandParams(this.commandParams, fileOpener);
                snapshotCommand.setDatabase(referenceDatabase);
                snapshotCommand.setSchemas(this.getSchemaParams(database));
                snapshotCommand.setSerializerFormat(this.getCommandParam("snapshotFormat", null));
                Writer outputWriter4 = this.getOutputWriter();
                outputWriter4.write(((SnapshotCommand.SnapshotCommandResult)snapshotCommand.execute()).print());
                outputWriter4.flush();
                outputWriter4.close();
                return;
            }
            Liquibase liquibase = new Liquibase(this.changeLogFile, (ResourceAccessor)fileOpener, database);
            ChangeExecListener listener = ChangeExecListenerUtils.getChangeExecListener(liquibase.getDatabase(), liquibase.getResourceAccessor(), this.changeExecListenerClass, this.changeExecListenerPropertiesFile);
            liquibase.setChangeExecListener(listener);
            if (database != null) {
                database.setCurrentDateTimeFunction(this.currentDateTimeFunction);
            }
            for (Map.Entry<String, Object> entry : this.changeLogParameters.entrySet()) {
                liquibase.setChangeLogParameter(entry.getKey(), entry.getValue());
            }
            if ("listLocks".equalsIgnoreCase(this.command)) {
                liquibase.reportLocks(System.err);
                return;
            }
            if ("releaseLocks".equalsIgnoreCase(this.command)) {
                LockService lockService = LockServiceFactory.getInstance().getLockService(database);
                lockService.forceReleaseLock();
                LogService.getLog(this.getClass()).info(LogType.USER_MESSAGE, String.format(coreBundle.getString("successfully.released.database.change.log.locks"), liquibase.getDatabase().getConnection().getConnectionUserName() + "@" + liquibase.getDatabase().getConnection().getURL()));
                return;
            }
            if ("tag".equalsIgnoreCase(this.command)) {
                liquibase.tag(this.getCommandArgument());
                LogService.getLog(this.getClass()).info(LogType.USER_MESSAGE, String.format(coreBundle.getString("successfully.tagged"), liquibase.getDatabase().getConnection().getConnectionUserName() + "@" + liquibase.getDatabase().getConnection().getURL()));
                return;
            }
            if ("tagExists".equalsIgnoreCase(this.command)) {
                String tag = this.commandParams.iterator().next();
                boolean exists = liquibase.tagExists(tag);
                if (exists) {
                    LogService.getLog(this.getClass()).info(LogType.USER_MESSAGE, String.format(coreBundle.getString("tag.exists"), tag, liquibase.getDatabase().getConnection().getConnectionUserName() + "@" + liquibase.getDatabase().getConnection().getURL()));
                    return;
                }
                LogService.getLog(this.getClass()).info(LogType.USER_MESSAGE, String.format(coreBundle.getString("tag.does.not.exist"), tag, liquibase.getDatabase().getConnection().getConnectionUserName() + "@" + liquibase.getDatabase().getConnection().getURL()));
                return;
            }
            if ("rollbackOneChangeSet".equals(this.command)) {
                argsMap2 = new HashMap<String, Object>();
                argsMap2.put("changeSetId", this.getCommandParam("changeSetId", null));
                argsMap2.put("changeSetAuthor", this.getCommandParam("changeSetAuthor", null));
                argsMap2.put("changeSetPath", this.getCommandParam("changeSetPath", null));
                argsMap2.put("rollbackScript", this.rollbackScript);
                argsMap2.put("changeLogFile", this.changeLogFile);
                argsMap2.put("database", database);
                if (!this.commandParams.contains("--help")) {
                    argsMap2.put("changeLog", liquibase.getDatabaseChangeLog());
                }
                argsMap2.put("resourceAccessor", liquibase.getResourceAccessor());
                clp = new ChangeLogParameters(database);
                for (Map.Entry<String, Object> entry : this.changeLogParameters.entrySet()) {
                    clp.set(entry.getKey(), entry.getValue());
                }
                argsMap2.put("changeLogParameters", clp);
                if (this.commandParams.contains("--force")) {
                    argsMap2.put("force", true);
                }
                if (this.commandParams.contains("--help")) {
                    argsMap2.put("help", true);
                }
                LiquibaseCommand liquibaseCommand = this.createLiquibaseCommand(database, liquibase, "rollbackOneChangeSet", argsMap2);
                liquibaseCommand.execute();
                return;
            }
            if ("rollbackOneChangeSetSQL".equals(this.command)) {
                outputWriter4 = this.getOutputWriter();
                argsMap = new HashMap<String, Object>();
                argsMap.put("outputWriter", outputWriter4);
                argsMap.put("force", true);
                LiquibaseCommand liquibaseCommand = this.createLiquibaseCommand(database, liquibase, "rollbackOneChangeSet", argsMap);
                liquibaseCommand.execute();
                ((Writer)outputWriter4).flush();
                ((Writer)outputWriter4).close();
                return;
            }
            if ("rollbackOneUpdate".equals(this.command)) {
                argsMap2 = new HashMap();
                argsMap2.put("deploymentId", this.getCommandParam("deploymentId", null));
                argsMap2.put("changeLogFile", this.changeLogFile);
                argsMap2.put("database", database);
                if (!this.commandParams.contains("--help")) {
                    argsMap2.put("changeLog", liquibase.getDatabaseChangeLog());
                }
                argsMap2.put("resourceAccessor", liquibase.getResourceAccessor());
                clp = new ChangeLogParameters(database);
                for (Map.Entry<String, Object> entry : this.changeLogParameters.entrySet()) {
                    clp.set(entry.getKey(), entry.getValue());
                }
                argsMap2.put("changeLogParameters", clp);
                if (this.commandParams.contains("--force")) {
                    argsMap2.put("force", true);
                }
                if (this.commandParams.contains("--help")) {
                    argsMap2.put("help", true);
                }
                LiquibaseCommand liquibaseCommand = this.createLiquibaseCommand(database, liquibase, "rollbackOneUpdate", argsMap2);
                liquibaseCommand.execute();
                return;
            }
            if ("rollbackOneUpdateSQL".equals(this.command)) {
                outputWriter4 = this.getOutputWriter();
                argsMap = new HashMap();
                argsMap.put("deploymentId", this.getCommandParam("deploymentId", null));
                argsMap.put("outputWriter", outputWriter4);
                argsMap.put("force", true);
                LiquibaseCommand liquibaseCommand = this.createLiquibaseCommand(database, liquibase, "rollbackOneUpdate", argsMap);
                liquibaseCommand.execute();
                ((Writer)outputWriter4).flush();
                ((Writer)outputWriter4).close();
                return;
            }
            if ("dropAll".equals(this.command)) {
                DropAllCommand dropAllCommand = (DropAllCommand)CommandFactory.getInstance().getCommand("dropAll");
                dropAllCommand.setDatabase(liquibase.getDatabase());
                dropAllCommand.setSchemas(this.getSchemaParams(database));
                LogService.getLog(this.getClass()).info(LogType.USER_MESSAGE, ((CommandResult)dropAllCommand.execute()).print());
                return;
            }
            if ("status".equalsIgnoreCase(this.command)) {
                boolean runVerbose = false;
                if (this.commandParams.contains("--verbose")) {
                    runVerbose = true;
                }
                liquibase.reportStatus(runVerbose, new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                return;
            }
            if ("unexpectedChangeSets".equalsIgnoreCase(this.command)) {
                boolean runVerbose = false;
                if (this.commandParams.contains("--verbose")) {
                    runVerbose = true;
                }
                liquibase.reportUnexpectedChangeSets(runVerbose, this.contexts, this.getOutputWriter());
                return;
            }
            if ("validate".equalsIgnoreCase(this.command)) {
                try {
                    liquibase.validate();
                }
                catch (ValidationFailedException e3) {
                    e3.printDescriptiveError(System.err);
                    try {
                        if (database == null) return;
                        database.rollback();
                        database.close();
                        return;
                    }
                    catch (DatabaseException e4) {
                        LogService.getLog(this.getClass()).warning(LogType.LOG, coreBundle.getString("problem.closing.connection"), e4);
                    }
                    return;
                }
                LogService.getLog(this.getClass()).info(LogType.USER_MESSAGE, coreBundle.getString("no.validation.errors.found"));
                return;
            }
            if ("clearCheckSums".equalsIgnoreCase(this.command)) {
                liquibase.clearCheckSums();
                return;
            }
            if ("calculateCheckSum".equalsIgnoreCase(this.command)) {
                CheckSum checkSum = null;
                checkSum = liquibase.calculateCheckSum(this.commandParams.iterator().next());
                LogService.getLog(this.getClass()).info(LogType.USER_MESSAGE, checkSum.toString());
                return;
            }
            if ("dbDoc".equalsIgnoreCase(this.command)) {
                if (this.commandParams.isEmpty()) {
                    throw new CommandLineParsingException(coreBundle.getString("dbdoc.requires.output.directory"));
                }
                if (this.changeLogFile == null) {
                    throw new CommandLineParsingException(coreBundle.getString("dbdoc.requires.changelog.parameter"));
                }
                liquibase.generateDocumentation(this.commandParams.iterator().next(), this.contexts);
                return;
            }
            try {
                if ("update".equalsIgnoreCase(this.command)) {
                    liquibase.update(new Contexts(this.contexts), new LabelExpression(this.labels));
                    return;
                }
                if ("changelogSync".equalsIgnoreCase(this.command)) {
                    liquibase.changeLogSync(new Contexts(this.contexts), new LabelExpression(this.labels));
                    return;
                }
                if ("changelogSyncSQL".equalsIgnoreCase(this.command)) {
                    liquibase.changeLogSync(new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("markNextChangeSetRan".equalsIgnoreCase(this.command)) {
                    liquibase.markNextChangeSetRan(new Contexts(this.contexts), new LabelExpression(this.labels));
                    return;
                }
                if ("markNextChangeSetRanSQL".equalsIgnoreCase(this.command)) {
                    liquibase.markNextChangeSetRan(new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("updateCount".equalsIgnoreCase(this.command)) {
                    liquibase.update(Integer.parseInt(this.commandParams.iterator().next()), new Contexts(this.contexts), new LabelExpression(this.labels));
                    return;
                }
                if ("updateCountSQL".equalsIgnoreCase(this.command)) {
                    liquibase.update(Integer.parseInt(this.commandParams.iterator().next()), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("updateToTag".equalsIgnoreCase(this.command)) {
                    if (this.commandParams != null && !this.commandParams.isEmpty()) {
                        liquibase.update(this.commandParams.iterator().next(), new Contexts(this.contexts), new LabelExpression(this.labels));
                        return;
                    }
                    throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.tag"), "updateToTag"));
                }
                if ("updateToTagSQL".equalsIgnoreCase(this.command)) {
                    if (this.commandParams != null && !this.commandParams.isEmpty()) {
                        liquibase.update(this.commandParams.iterator().next(), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                        return;
                    }
                    throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.tag"), "updateToTagSQL"));
                }
                if ("updateSQL".equalsIgnoreCase(this.command)) {
                    liquibase.update(new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("rollback".equalsIgnoreCase(this.command)) {
                    if (this.getCommandArgument() == null) {
                        throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.tag"), "rollback"));
                    }
                    liquibase.rollback(this.getCommandArgument(), this.getCommandParam("rollbackScript", null), new Contexts(this.contexts), new LabelExpression(this.labels));
                    return;
                }
                if ("rollbackToDate".equalsIgnoreCase(this.command)) {
                    if (this.getCommandArgument() == null) {
                        throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.timestamp"), "rollbackToDate"));
                    }
                    liquibase.rollback(new ISODateFormat().parse(this.getCommandArgument()), this.getCommandParam("rollbackScript", null), new Contexts(this.contexts), new LabelExpression(this.labels));
                    return;
                }
                if ("rollbackCount".equalsIgnoreCase(this.command)) {
                    liquibase.rollback(Integer.parseInt(this.getCommandArgument()), this.getCommandParam("rollbackScript", null), new Contexts(this.contexts), new LabelExpression(this.labels));
                    return;
                }
                if ("rollbackSQL".equalsIgnoreCase(this.command)) {
                    if (this.getCommandArgument() == null) {
                        throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.tag"), "rollbackSQL"));
                    }
                    liquibase.rollback(this.getCommandArgument(), this.getCommandParam("rollbackScript", null), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("rollbackToDateSQL".equalsIgnoreCase(this.command)) {
                    if (this.getCommandArgument() == null) {
                        throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.timestamp"), "rollbackToDateSQL"));
                    }
                    liquibase.rollback(new ISODateFormat().parse(this.getCommandArgument()), this.getCommandParam("rollbackScript", null), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("rollbackCountSQL".equalsIgnoreCase(this.command)) {
                    if (this.getCommandArgument() == null) {
                        throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.count"), "rollbackCountSQL"));
                    }
                    liquibase.rollback(Integer.parseInt(this.getCommandArgument()), this.getCommandParam("rollbackScript", null), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("futureRollbackSQL".equalsIgnoreCase(this.command)) {
                    liquibase.futureRollbackSQL(new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("futureRollbackCountSQL".equalsIgnoreCase(this.command)) {
                    if (this.getCommandArgument() == null) {
                        throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.count"), "futureRollbackCountSQL"));
                    }
                    liquibase.futureRollbackSQL((Integer)Integer.parseInt(this.getCommandArgument()), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("futureRollbackFromTagSQL".equalsIgnoreCase(this.command)) {
                    if (this.getCommandArgument() == null) {
                        throw new CommandLineParsingException(String.format(coreBundle.getString("command.requires.tag"), "futureRollbackFromTagSQL"));
                    }
                    liquibase.futureRollbackSQL(this.getCommandArgument(), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("updateTestingRollback".equalsIgnoreCase(this.command)) {
                    liquibase.updateTestingRollback(new Contexts(this.contexts), new LabelExpression(this.labels));
                    return;
                }
                if ("history".equalsIgnoreCase(this.command)) {
                    HistoryCommand historyCommand = (HistoryCommand)CommandFactory.getInstance().getCommand("history");
                    historyCommand.setDatabase(database);
                    historyCommand.setOutputStream(new PrintStream(this.getOutputStream()));
                    historyCommand.execute();
                    return;
                }
                throw new CommandLineParsingException(String.format(coreBundle.getString("command.unknown"), this.command));
            }
            catch (ParseException ignored) {
                throw new CommandLineParsingException(coreBundle.getString("timeformat.invalid"));
            }
        }
        finally {
            try {
                if (database != null) {
                    database.rollback();
                    database.close();
                }
            }
            catch (DatabaseException e5) {
                LogService.getLog(this.getClass()).warning(LogType.LOG, coreBundle.getString("problem.closing.connection"), e5);
            }
        }
    }

    private String getSchemaParams(Database database) throws CommandLineParsingException {
        String schemaParams = this.getCommandParam("schemas", this.schemas);
        if (schemaParams == null || schemaParams.isEmpty()) {
            return database.getDefaultSchema().getSchemaName();
        }
        return schemaParams;
    }

    private LiquibaseCommand createLiquibaseCommand(Database database, Liquibase liquibase, String commandName, Map<String, Object> argsMap) throws CommandLineParsingException, LiquibaseException {
        LiquibaseCommand liquibaseCommand = CommandFactory.getInstance().getCommand(commandName);
        AbstractSelfConfiguratingCommand configuratingCommand = (AbstractSelfConfiguratingCommand)liquibaseCommand;
        argsMap.put("changeSetId", this.getCommandParam("changeSetId", null));
        argsMap.put("changeSetAuthor", this.getCommandParam("changeSetAuthor", null));
        argsMap.put("changeSetPath", this.getCommandParam("changeSetPath", null));
        argsMap.put("rollbackScript", this.rollbackScript);
        argsMap.put("changeLogFile", this.changeLogFile);
        argsMap.put("database", database);
        argsMap.put("liquibase", liquibase);
        if (!this.commandParams.contains("--help")) {
            argsMap.put("changeLog", liquibase.getDatabaseChangeLog());
        }
        argsMap.put("resourceAccessor", liquibase.getResourceAccessor());
        ChangeLogParameters clp = new ChangeLogParameters(database);
        for (Map.Entry<String, Object> entry : this.changeLogParameters.entrySet()) {
            clp.set(entry.getKey(), entry.getValue());
        }
        argsMap.put("changeLogParameters", clp);
        if (this.commandParams.contains("--force")) {
            argsMap.put("force", true);
        }
        if (this.commandParams.contains("--help")) {
            argsMap.put("help", true);
        }
        configuratingCommand.configure(argsMap);
        return liquibaseCommand;
    }

    private String getCommandArgument() {
        for (String param : this.commandParams) {
            if (param.contains("=")) continue;
            return param;
        }
        return null;
    }

    private String getCommandParam(String paramName, String defaultValue) throws CommandLineParsingException {
        for (String param : this.commandParams) {
            if (!param.contains("=")) continue;
            String[] splitArg = Main.splitArg(param);
            String attributeName = splitArg[0];
            String value = splitArg[1];
            if (!attributeName.equalsIgnoreCase(paramName)) continue;
            return value;
        }
        return defaultValue;
    }

    private Database createReferenceDatabaseFromCommandParams(Set<String> commandParams, ResourceAccessor resourceAccessor) throws CommandLineParsingException, DatabaseException {
        String refDriver = this.referenceDriver;
        String refUrl = this.referenceUrl;
        String refUsername = this.referenceUsername;
        String refPassword = this.referencePassword;
        String defSchemaName = this.referenceDefaultSchemaName;
        String defCatalogName = this.referenceDefaultCatalogName;
        for (String param : commandParams) {
            String[] splitArg = Main.splitArg(param);
            String attributeName = splitArg[0];
            String value = splitArg[1];
            if ("referenceDriver".equalsIgnoreCase(attributeName)) {
                refDriver = value;
                continue;
            }
            if ("referenceUrl".equalsIgnoreCase(attributeName)) {
                refUrl = value;
                continue;
            }
            if ("referenceUsername".equalsIgnoreCase(attributeName)) {
                refUsername = value;
                continue;
            }
            if ("referencePassword".equalsIgnoreCase(attributeName)) {
                refPassword = value;
                continue;
            }
            if ("referenceDefaultCatalogName".equalsIgnoreCase(attributeName)) {
                defCatalogName = value;
                continue;
            }
            if ("referenceDefaultSchemaName".equalsIgnoreCase(attributeName)) {
                defSchemaName = value;
                continue;
            }
            if (!"dataOutputDirectory".equalsIgnoreCase(attributeName)) continue;
            this.dataOutputDirectory = value;
        }
        if (refUrl == null) {
            throw new CommandLineParsingException(String.format(coreBundle.getString("option.required"), "--referenceUrl"));
        }
        return CommandLineUtils.createDatabaseObject(resourceAccessor, refUrl, refUsername, refPassword, refDriver, defCatalogName, defSchemaName, Boolean.parseBoolean(this.outputDefaultCatalog), Boolean.parseBoolean(this.outputDefaultSchema), null, null, this.propertyProviderClass, this.liquibaseCatalogName, this.liquibaseSchemaName, this.databaseChangeLogTableName, this.databaseChangeLogLockTableName);
    }

    private OutputStream getOutputStream() throws IOException {
        if (this.outputFile != null) {
            try {
                FileOutputStream fileOut = new FileOutputStream(this.outputFile, false);
                return fileOut;
            }
            catch (IOException e2) {
                LogService.getLog(this.getClass()).severe(LogType.LOG, String.format(coreBundle.getString("could.not.create.output.file"), this.outputFile));
                throw e2;
            }
        }
        return System.out;
    }

    private Writer getOutputWriter() throws IOException {
        String charsetName = LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding();
        return new OutputStreamWriter(this.getOutputStream(), charsetName);
    }

    public boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows ");
    }

    private static class ConsoleFilter
    extends Filter<ILoggingEvent> {
        private Set<LogType> includeTypes = new HashSet<LogType>();
        private final ch.qos.logback.classic.Level logLevel;

        public ConsoleFilter(ch.qos.logback.classic.Level logLevel, LogType ... types) {
            this.includeTypes.addAll(Arrays.asList(types));
            this.logLevel = logLevel;
        }

        public FilterReply decide(ILoggingEvent event) {
            LogType messageType = LogType.valueOf(event.getMarker().getName());
            if (event.getMarker().getName().equals(LogType.USER_MESSAGE.name())) {
                return FilterReply.ACCEPT;
            }
            if (!event.getLevel().isGreaterOrEqual(this.logLevel)) {
                return FilterReply.DENY;
            }
            if (this.includeTypes.isEmpty() || this.includeTypes.contains((Object)messageType)) {
                return FilterReply.ACCEPT;
            }
            return FilterReply.DENY;
        }
    }

    private static enum OPTIONS {

        private static final String VERBOSE = "verbose";
        private static final String CHANGELOG_FILE = "changeLogFile";
        private static final String DATA_OUTPUT_DIRECTORY = "dataOutputDirectory";
        private static final String DIFF_TYPES = "diffTypes";
        private static final String CHANGE_SET_ID = "changeSetId";
        private static final String CHANGE_SET_AUTHOR = "changeSetAuthor";
        private static final String CHANGE_SET_PATH = "changeSetPath";
        private static final String DEPLOYMENT_ID = "deploymentId";
        private static final String OUTPUT_FILE = "outputFile";
        private static final String FORCE = "force";
        private static final String ROLLBACK_SCRIPT = "rollbackScript";
        private static final String EXCLUDE_OBJECTS = "excludeObjects";
        private static final String INCLUDE_CATALOG = "includeCatalog";
        private static final String INCLUDE_OBJECTS = "includeObjects";
        private static final String INCLUDE_SCHEMA = "includeSchema";
        private static final String INCLUDE_TABLESPACE = "includeTablespace";
        private static final String OUTPUT_SCHEMAS_AS = "outputSchemasAs";
        private static final String REFERENCE_DEFAULT_CATALOG_NAME = "referenceDefaultCatalogName";
        private static final String REFERENCE_DEFAULT_SCHEMA_NAME = "referenceDefaultSchemaName";
        private static final String REFERENCE_DRIVER = "referenceDriver";
        private static final String REFERENCE_PASSWORD = "referencePassword";
        private static final String REFERENCE_SCHEMAS = "referenceSchemas";
        private static final String REFERENCE_URL = "referenceUrl";
        private static final String REFERENCE_USERNAME = "referenceUsername";
        private static final String SCHEMAS = "schemas";
        private static final String URL = "url";
        private static final String HELP = "help";
        private static final String VERSION = "version";
        private static final String SNAPSHOT_FORMAT = "snapshotFormat";
        private static final String LOG_FILE = "logFile";
        private static final String LOG_LEVEL = "logLevel";
    }

    private static enum COMMANDS {

        private static final String CALCULATE_CHECKSUM = "calculateCheckSum";
        private static final String CHANGELOG_SYNC = "changelogSync";
        private static final String CHANGELOG_SYNC_SQL = "changelogSyncSQL";
        private static final String CLEAR_CHECKSUMS = "clearCheckSums";
        private static final String DB_DOC = "dbDoc";
        private static final String DIFF = "diff";
        private static final String DIFF_CHANGELOG = "diffChangeLog";
        private static final String DROP_ALL = "dropAll";
        private static final String EXECUTE_SQL = "executeSql";
        private static final String FUTURE_ROLLBACK_COUNT_SQL = "futureRollbackCountSQL";
        private static final String FUTURE_ROLLBACK_FROM_TAG_SQL = "futureRollbackFromTagSQL";
        private static final String FUTURE_ROLLBACK_SQL = "futureRollbackSQL";
        private static final String FUTURE_ROLLBACK_TO_TAG_SQL = "futureRollbackToTagSQL";
        private static final String GENERATE_CHANGELOG = "generateChangeLog";
        private static final String HELP = "help";
        private static final String HISTORY = "history";
        private static final String LIST_LOCKS = "listLocks";
        private static final String MARK_NEXT_CHANGESET_RAN = "markNextChangeSetRan";
        private static final String MARK_NEXT_CHANGESET_RAN_SQL = "markNextChangeSetRanSQL";
        private static final String MIGRATE = "migrate";
        private static final String MIGRATE_SQL = "migrateSQL";
        private static final String RELEASE_LOCKS = "releaseLocks";
        private static final String ROLLBACK_ONE_CHANGE_SET = "rollbackOneChangeSet";
        private static final String ROLLBACK_ONE_CHANGE_SET_SQL = "rollbackOneChangeSetSQL";
        private static final String ROLLBACK_ONE_UPDATE = "rollbackOneUpdate";
        private static final String ROLLBACK_ONE_UPDATE_SQL = "rollbackOneUpdateSQL";
        private static final String ROLLBACK = "rollback";
        private static final String ROLLBACK_COUNT = "rollbackCount";
        private static final String ROLLBACK_COUNT_SQL = "rollbackCountSQL";
        private static final String ROLLBACK_SCRIPT = "rollbackScript";
        private static final String ROLLBACK_SQL = "rollbackSQL";
        private static final String ROLLBACK_TO_DATE = "rollbackToDate";
        private static final String ROLLBACK_TO_DATE_SQL = "rollbackToDateSQL";
        private static final String SNAPSHOT = "snapshot";
        private static final String SNAPSHOT_REFERENCE = "snapshotReference";
        private static final String STATUS = "status";
        private static final String TAG = "tag";
        private static final String TAG_EXISTS = "tagExists";
        private static final String UNEXPECTED_CHANGESETS = "unexpectedChangeSets";
        private static final String UPDATE = "update";
        private static final String UPDATE_COUNT = "updateCount";
        private static final String UPDATE_COUNT_SQL = "updateCountSQL";
        private static final String UPDATE_SQL = "updateSQL";
        private static final String UPDATE_TESTING_ROLLBACK = "updateTestingRollback";
        private static final String UPDATE_TO_TAG = "updateToTag";
        private static final String UPDATE_TO_TAG_SQL = "updateToTagSQL";
        private static final String VALIDATE = "validate";
    }

    private static enum FILE_SUFFIXES {

        private static final String FILE_SUFFIX_EAR = ".ear";
        private static final String WAR_FILE_SUFFIX = ".war";
    }

    protected static class CodePointCheck {
        public int position;
        public char ch;

        protected CodePointCheck() {
        }
    }
}

