/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.spring;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.sql.DataSource;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.configuration.ConfigurationProperty;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.OfflineConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.logging.Logger;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtils;
import liquibase.util.file.FilenameUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;

public class SpringLiquibase
implements InitializingBean,
BeanNameAware,
ResourceLoaderAware {
    protected final Logger log = LogService.getLog(SpringLiquibase.class);
    protected String beanName;
    protected ResourceLoader resourceLoader;
    protected DataSource dataSource;
    protected String changeLog;
    protected String contexts;
    protected String labels;
    protected String tag;
    protected Map<String, String> parameters;
    protected String defaultSchema;
    protected String liquibaseSchema;
    protected String databaseChangeLogTable;
    protected String databaseChangeLogLockTable;
    protected String liquibaseTablespace;
    protected boolean dropFirst;
    protected boolean clearCheckSums;
    protected boolean shouldRun = true;
    protected File rollbackFile;
    private boolean ignoreClasspathPrefix = true;
    protected boolean testRollbackOnUpdate = false;

    public boolean isDropFirst() {
        return this.dropFirst;
    }

    public void setDropFirst(boolean dropFirst) {
        this.dropFirst = dropFirst;
    }

    public boolean isClearCheckSums() {
        return this.clearCheckSums;
    }

    public void setClearCheckSums(boolean clearCheckSums) {
        this.clearCheckSums = clearCheckSums;
    }

    public void setShouldRun(boolean shouldRun) {
        this.shouldRun = shouldRun;
    }

    public String getDatabaseProductName() throws DatabaseException {
        Connection connection = null;
        Database database = null;
        String name = "unknown";
        try {
            connection = this.getDataSource().getConnection();
            database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(new JdbcConnection(connection));
            name = database.getDatabaseProductName();
        }
        catch (SQLException e2) {
            throw new DatabaseException(e2);
        }
        finally {
            if (database != null) {
                database.close();
            } else if (connection != null) {
                try {
                    if (!connection.getAutoCommit()) {
                        connection.rollback();
                    }
                    connection.close();
                }
                catch (SQLException e3) {
                    this.log.warning(LogType.LOG, "problem closing connection", e3);
                }
            }
        }
        return name;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getChangeLog() {
        return this.changeLog;
    }

    public void setChangeLog(String dataModel) {
        this.changeLog = dataModel;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setContexts(String contexts) {
        this.contexts = contexts;
    }

    public String getLabels() {
        return this.labels;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public String getLiquibaseTablespace() {
        return this.liquibaseTablespace;
    }

    public void setLiquibaseTablespace(String liquibaseTablespace) {
        this.liquibaseTablespace = liquibaseTablespace;
    }

    public String getLiquibaseSchema() {
        return this.liquibaseSchema;
    }

    public void setLiquibaseSchema(String liquibaseSchema) {
        this.liquibaseSchema = liquibaseSchema;
    }

    public String getDatabaseChangeLogTable() {
        return this.databaseChangeLogTable;
    }

    public void setDatabaseChangeLogTable(String databaseChangeLogTable) {
        this.databaseChangeLogTable = databaseChangeLogTable;
    }

    public String getDatabaseChangeLogLockTable() {
        return this.databaseChangeLogLockTable;
    }

    public void setDatabaseChangeLogLockTable(String databaseChangeLogLockTable) {
        this.databaseChangeLogLockTable = databaseChangeLogLockTable;
    }

    public boolean isTestRollbackOnUpdate() {
        return this.testRollbackOnUpdate;
    }

    public void setTestRollbackOnUpdate(boolean testRollbackOnUpdate) {
        this.testRollbackOnUpdate = testRollbackOnUpdate;
    }

    public void afterPropertiesSet() throws LiquibaseException {
        ConfigurationProperty shouldRunProperty = LiquibaseConfiguration.getInstance().getProperty(GlobalConfiguration.class, "shouldRun");
        if (!shouldRunProperty.getValue(Boolean.class).booleanValue()) {
            LogService.getLog(this.getClass()).info(LogType.LOG, "Liquibase did not run because " + LiquibaseConfiguration.getInstance().describeValueLookupLogic(shouldRunProperty) + " was set to false");
            return;
        }
        if (!this.shouldRun) {
            LogService.getLog(this.getClass()).info(LogType.LOG, "Liquibase did not run because 'shouldRun' property was set to false on " + this.getBeanName() + " Liquibase Spring bean.");
            return;
        }
        Connection c2 = null;
        Liquibase liquibase = null;
        try {
            c2 = this.getDataSource().getConnection();
            liquibase = this.createLiquibase(c2);
            this.generateRollbackFile(liquibase);
            this.performUpdate(liquibase);
        }
        catch (SQLException e2) {
            throw new DatabaseException(e2);
        }
        finally {
            Database database = null;
            if (liquibase != null) {
                database = liquibase.getDatabase();
            }
            if (database != null) {
                database.close();
            }
        }
    }

    private void generateRollbackFile(Liquibase liquibase) throws LiquibaseException {
        if (this.rollbackFile != null) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(this.rollbackFile);
                 OutputStreamWriter output = new OutputStreamWriter((OutputStream)fileOutputStream, LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding());){
                if (this.tag != null) {
                    liquibase.futureRollbackSQL(this.tag, new Contexts(this.getContexts()), new LabelExpression(this.getLabels()), (Writer)output);
                } else {
                    liquibase.futureRollbackSQL(new Contexts(this.getContexts()), new LabelExpression(this.getLabels()), (Writer)output);
                }
            }
            catch (IOException e2) {
                throw new LiquibaseException("Unable to generate rollback file.", e2);
            }
        }
    }

    protected void performUpdate(Liquibase liquibase) throws LiquibaseException {
        if (this.isClearCheckSums()) {
            liquibase.clearCheckSums();
        }
        if (this.isTestRollbackOnUpdate()) {
            if (this.tag != null) {
                liquibase.updateTestingRollback(this.tag, new Contexts(this.getContexts()), new LabelExpression(this.getLabels()));
            } else {
                liquibase.updateTestingRollback(new Contexts(this.getContexts()), new LabelExpression(this.getLabels()));
            }
        } else if (this.tag != null) {
            liquibase.update(this.tag, new Contexts(this.getContexts()), new LabelExpression(this.getLabels()));
        } else {
            liquibase.update(new Contexts(this.getContexts()), new LabelExpression(this.getLabels()));
        }
    }

    protected Liquibase createLiquibase(Connection c2) throws LiquibaseException {
        SpringResourceOpener resourceAccessor = this.createResourceOpener();
        Liquibase liquibase = new Liquibase(this.getChangeLog(), (ResourceAccessor)resourceAccessor, this.createDatabase(c2, resourceAccessor));
        liquibase.setIgnoreClasspathPrefix(this.isIgnoreClasspathPrefix());
        if (this.parameters != null) {
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                liquibase.setChangeLogParameter(entry.getKey(), entry.getValue());
            }
        }
        if (this.isDropFirst()) {
            liquibase.dropAll();
        }
        return liquibase;
    }

    protected Database createDatabase(Connection c2, ResourceAccessor resourceAccessor) throws DatabaseException {
        DatabaseConnection liquibaseConnection;
        if (c2 == null) {
            this.log.warning(LogType.LOG, "Null connection returned by liquibase datasource. Using offline unknown database");
            liquibaseConnection = new OfflineConnection("offline:unknown", resourceAccessor);
        } else {
            liquibaseConnection = new JdbcConnection(c2);
        }
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(liquibaseConnection);
        if (StringUtils.trimToNull(this.defaultSchema) != null) {
            if (database.supportsSchemas()) {
                database.setDefaultSchemaName(this.defaultSchema);
            } else if (database.supportsCatalogs()) {
                database.setDefaultCatalogName(this.defaultSchema);
            }
        }
        if (StringUtils.trimToNull(this.liquibaseSchema) != null) {
            if (database.supportsSchemas()) {
                database.setLiquibaseSchemaName(this.liquibaseSchema);
            } else if (database.supportsCatalogs()) {
                database.setLiquibaseCatalogName(this.liquibaseSchema);
            }
        }
        if (StringUtils.trimToNull(this.liquibaseTablespace) != null && database.supportsTablespaces()) {
            database.setLiquibaseTablespaceName(this.liquibaseTablespace);
        }
        if (StringUtils.trimToNull(this.databaseChangeLogTable) != null) {
            database.setDatabaseChangeLogTableName(this.databaseChangeLogTable);
        }
        if (StringUtils.trimToNull(this.databaseChangeLogLockTable) != null) {
            database.setDatabaseChangeLogLockTableName(this.databaseChangeLogLockTable);
        }
        return database;
    }

    public void setChangeLogParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    protected SpringResourceOpener createResourceOpener() {
        return new SpringResourceOpener(this.getChangeLog());
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setRollbackFile(File rollbackFile) {
        this.rollbackFile = rollbackFile;
    }

    public boolean isIgnoreClasspathPrefix() {
        return this.ignoreClasspathPrefix;
    }

    public void setIgnoreClasspathPrefix(boolean ignoreClasspathPrefix) {
        this.ignoreClasspathPrefix = ignoreClasspathPrefix;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getResourceLoader().toString() + ")";
    }

    public class SpringResourceOpener
    extends ClassLoaderResourceAccessor {
        private String parentFile;

        public SpringResourceOpener(String parentFile) {
            this.parentFile = parentFile;
        }

        @Override
        protected void init() {
            super.init();
            try {
                Resource[] resources = this.getResources("");
                if (resources.length != 0 && (resources.length != 1 || resources[0].exists())) {
                    for (Resource res : resources) {
                        this.addRootPath(res.getURL());
                    }
                    return;
                }
                HashSet<String> liquibasePackages = new HashSet<String>();
                for (Resource manifest : this.getResources("META-INF/MANIFEST.MF")) {
                    liquibasePackages.addAll(this.getPackagesFromManifest(manifest));
                }
                if (liquibasePackages.isEmpty()) {
                    LogService.getLog(this.getClass()).warning(LogType.LOG, "No Liquibase-Packages entry found in MANIFEST.MF. Using fallback of entire 'liquibase' package");
                    liquibasePackages.add("liquibase");
                }
                for (String foundPackage : liquibasePackages) {
                    for (Resource res : this.getResources(foundPackage)) {
                        if (res.exists()) {
                            this.addRootPath(res.getURL());
                            continue;
                        }
                        LogService.getLog(this.getClass()).warning(LogType.LOG, "Resource does not exist: " + res.getDescription());
                    }
                }
            }
            catch (IOException e2) {
                LogService.getLog(this.getClass()).warning(LogType.LOG, "Error initializing SpringLiquibase", e2);
            }
        }

        @Override
        public Set<String> list(String relativeTo, String path, boolean includeFiles, boolean includeDirectories, boolean recursive) throws IOException {
            Resource[] resources;
            if (path == null) {
                return null;
            }
            HashSet<String> returnSet = new HashSet<String>();
            path = path + (recursive ? "**" : Character.valueOf('*'));
            String tempFile = FilenameUtils.concat(FilenameUtils.getFullPath(relativeTo), path);
            for (Resource resource : resources = this.getResources(this.adjustClasspath(tempFile))) {
                String newResourcePath;
                String resourcePath;
                String resourceStr = resource.getURL().toExternalForm();
                if (resourceStr.endsWith(resourcePath = this.convertToPath(resourceStr)) && !resourceStr.equals(resourcePath)) {
                    returnSet.add(resourcePath);
                    continue;
                }
                String newResourceStr = resource.getURL().getFile();
                if ((newResourceStr = newResourceStr.replaceAll("!", "")).endsWith(newResourcePath = this.convertToPath(newResourceStr)) && !newResourceStr.equals(newResourcePath)) {
                    returnSet.add(newResourcePath);
                    continue;
                }
                LogService.getLog(this.getClass()).warning(LogType.LOG, "Not a valid resource entry: " + resourceStr);
            }
            return returnSet;
        }

        @Override
        public Set<InputStream> getResourcesAsStream(String path) throws IOException {
            if (path == null) {
                return null;
            }
            Resource[] resources = this.getResources(this.adjustClasspath(path));
            if (resources == null || resources.length == 0) {
                return null;
            }
            HashSet<InputStream> returnSet = new HashSet<InputStream>();
            for (Resource resource : resources) {
                LogService.getLog(this.getClass()).debug(LogType.LOG, "Opening " + resource.getURL().toExternalForm() + " as " + path);
                URLConnection connection = resource.getURL().openConnection();
                connection.setUseCaches(false);
                returnSet.add(connection.getInputStream());
            }
            return returnSet;
        }

        public Resource getResource(String file) {
            return SpringLiquibase.this.getResourceLoader().getResource(this.adjustClasspath(file));
        }

        private String adjustClasspath(String file) {
            if (file == null) {
                return null;
            }
            return this.isPrefixPresent(this.parentFile) && !this.isPrefixPresent(file) ? "classpath:" + file : file;
        }

        private Resource[] getResources(String foundPackage) throws IOException {
            return ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)SpringLiquibase.this.getResourceLoader()).getResources(foundPackage);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<String> getPackagesFromManifest(Resource manifest) throws IOException {
            HashSet<String> manifestPackages = new HashSet<String>();
            if (!manifest.exists()) {
                return manifestPackages;
            }
            try (InputStream inputStream = null;){
                inputStream = manifest.getInputStream();
                Manifest manifestObj = new Manifest(inputStream);
                Attributes attributes = manifestObj.getAttributes("Liquibase-Package");
                if (attributes == null) {
                    HashSet<String> hashSet = manifestPackages;
                    return hashSet;
                }
                for (Object attr : attributes.values()) {
                    String packages = "\\s*,\\s*";
                    for (String fullPackage : attr.toString().split(packages)) {
                        manifestPackages.add(fullPackage.split("\\.")[0]);
                    }
                }
            }
            return manifestPackages;
        }

        public boolean isPrefixPresent(String file) {
            if (file == null) {
                return false;
            }
            return file.startsWith("classpath") || file.startsWith("file:") || file.startsWith("url:");
        }

        @Override
        public ClassLoader toClassLoader() {
            return SpringLiquibase.this.getResourceLoader().getClassLoader();
        }
    }
}

