/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.processor;

import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.TypeUtils;

public class MapperAnnotatedFormattingMessenger
implements FormattingMessager {
    private FormattingMessager delegateMessager;
    private TypeElement mapperTypeElement;
    private TypeUtils typeUtils;

    public MapperAnnotatedFormattingMessenger(FormattingMessager delegateMessager, TypeElement mapperTypeElement, TypeUtils typeUtils) {
        this.delegateMessager = delegateMessager;
        this.mapperTypeElement = mapperTypeElement;
        this.typeUtils = typeUtils;
    }

    @Override
    public void printMessage(Message msg, Object ... args) {
        this.delegateMessager.printMessage(msg, args);
    }

    @Override
    public void printMessage(Element e, Message msg, Object ... args) {
        this.delegateMessager.printMessage(this.determineDelegationElement(e), this.determineDelegationMessage(e, msg), this.determineDelegationArguments(e, msg, args));
    }

    @Override
    public void printMessage(Element e, AnnotationMirror a, Message msg, Object ... args) {
        this.delegateMessager.printMessage(this.determineDelegationElement(e), a, this.determineDelegationMessage(e, msg), this.determineDelegationArguments(e, msg, args));
    }

    @Override
    public void printMessage(Element e, AnnotationMirror a, AnnotationValue v, Message msg, Object ... args) {
        this.delegateMessager.printMessage(this.determineDelegationElement(e), a, v, this.determineDelegationMessage(e, msg), this.determineDelegationArguments(e, msg, args));
    }

    @Override
    public void note(int level, Message log, Object ... args) {
        this.delegateMessager.note(level, log, args);
    }

    @Override
    public boolean isErroneous() {
        return this.delegateMessager.isErroneous();
    }

    private Object[] determineDelegationArguments(Element e, Message msg, Object[] args) {
        if (this.methodInMapperClass(e)) {
            return args;
        }
        String originalMessage = String.format(msg.getDescription(), args);
        return new Object[]{originalMessage, this.constructMethod(e), e.getEnclosingElement().getSimpleName()};
    }

    private String constructMethod(Element e) {
        if (e instanceof ExecutableElement) {
            ExecutableElement ee = (ExecutableElement)e;
            StringBuilder method = new StringBuilder();
            method.append(this.typeUtils.asElement(ee.getReturnType()).getSimpleName());
            method.append(" ");
            method.append(ee.getSimpleName());
            method.append("(");
            method.append(ee.getParameters().stream().map(this::parameterToString).collect(Collectors.joining(", ")));
            method.append(")");
            return method.toString();
        }
        return e.toString();
    }

    private String parameterToString(VariableElement element) {
        return this.typeUtils.asElement(element.asType()).getSimpleName() + " " + element.getSimpleName();
    }

    private Message determineDelegationMessage(Element e, Message msg) {
        if (this.methodInMapperClass(e)) {
            return msg;
        }
        if (msg.getDiagnosticKind() == Diagnostic.Kind.ERROR) {
            return Message.MESSAGE_MOVED_TO_MAPPER_ERROR;
        }
        return Message.MESSAGE_MOVED_TO_MAPPER_WARNING;
    }

    private Element determineDelegationElement(Element e) {
        return this.methodInMapperClass(e) ? e : this.mapperTypeElement;
    }

    private boolean methodInMapperClass(Element e) {
        return this.mapperTypeElement == null || e.equals(this.mapperTypeElement) || e.getEnclosingElement().equals(this.mapperTypeElement);
    }
}

