/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder.annotation;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.ParamNameResolver;
import org.apache.ibatis.session.Configuration;

public class ProviderSqlSource
implements SqlSource {
    private SqlSourceBuilder sqlSourceParser;
    private Class<?> providerType;
    private Method providerMethod;
    private String[] providerMethodArgumentNames;

    public ProviderSqlSource(Configuration config, Object provider) {
        String providerMethodName;
        try {
            this.sqlSourceParser = new SqlSourceBuilder(config);
            this.providerType = (Class)provider.getClass().getMethod("type", new Class[0]).invoke(provider, new Object[0]);
            providerMethodName = (String)provider.getClass().getMethod("method", new Class[0]).invoke(provider, new Object[0]);
            for (Method m : this.providerType.getMethods()) {
                if (!providerMethodName.equals(m.getName()) || m.getReturnType() != String.class) continue;
                if (this.providerMethod != null) {
                    throw new BuilderException("Error creating SqlSource for SqlProvider. Method '" + providerMethodName + "' is found multiple in SqlProvider '" + this.providerType.getName() + "'. Sql provider method can not overload.");
                }
                this.providerMethod = m;
                this.providerMethodArgumentNames = new ParamNameResolver(config, m).getNames();
            }
        }
        catch (BuilderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuilderException("Error creating SqlSource for SqlProvider.  Cause: " + e, e);
        }
        if (this.providerMethod == null) {
            throw new BuilderException("Error creating SqlSource for SqlProvider. Method '" + providerMethodName + "' not found in SqlProvider '" + this.providerType.getName() + "'.");
        }
    }

    @Override
    public BoundSql getBoundSql(Object parameterObject) {
        SqlSource sqlSource = this.createSqlSource(parameterObject);
        return sqlSource.getBoundSql(parameterObject);
    }

    private SqlSource createSqlSource(Object parameterObject) {
        try {
            String sql;
            Class<?>[] parameterTypes = this.providerMethod.getParameterTypes();
            if (parameterTypes.length == 0) {
                sql = (String)this.providerMethod.invoke(this.providerType.newInstance(), new Object[0]);
            } else if (parameterTypes.length == 1 && (parameterObject == null || parameterTypes[0].isAssignableFrom(parameterObject.getClass()))) {
                sql = (String)this.providerMethod.invoke(this.providerType.newInstance(), parameterObject);
            } else if (parameterObject instanceof Map) {
                Map params = (Map)parameterObject;
                sql = (String)this.providerMethod.invoke(this.providerType.newInstance(), this.extractProviderMethodArguments(params, this.providerMethodArgumentNames));
            } else {
                throw new BuilderException("Error invoking SqlProvider method (" + this.providerType.getName() + "." + this.providerMethod.getName() + "). Cannot invoke a method that holds " + (parameterTypes.length == 1 ? "named argument(@Param)" : "multiple arguments") + " using a specifying parameterObject. In this case, please specify a 'java.util.Map' object.");
            }
            Class parameterType = parameterObject == null ? Object.class : parameterObject.getClass();
            return this.sqlSourceParser.parse(sql, parameterType, new HashMap<String, Object>());
        }
        catch (BuilderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuilderException("Error invoking SqlProvider method (" + this.providerType.getName() + "." + this.providerMethod.getName() + ").  Cause: " + e, e);
        }
    }

    private Object[] extractProviderMethodArguments(Map<String, Object> params, String[] argumentNames) {
        Object[] args = new Object[argumentNames.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = params.get(argumentNames[i]);
        }
        return args;
    }
}

