/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.registry;

import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.objectweb.carol.jndi.ns.JRMPRegistry;
import org.objectweb.carol.jndi.registry.LocalEnumeration;
import org.objectweb.carol.jndi.registry.SimpleNameParser;
import org.objectweb.carol.rmi.exception.NamingExceptionHelper;

public class RegistryWrapperContext
implements Context {
    private Registry registry = JRMPRegistry.getRegistry();
    private static Hashtable environment = null;
    private static final NameParser NAME_PARSER = new SimpleNameParser();

    public RegistryWrapperContext(Hashtable env) {
        environment = env;
        environment.put("java.naming.factory.initial", "org.objectweb.carol.jndi.spi.JRMPContextWrapperFactory");
    }

    public Object lookup(Name name) throws NamingException {
        Remote obj;
        if (name.isEmpty()) {
            return this;
        }
        try {
            obj = this.registry.lookup(name.get(0));
        }
        catch (NotBoundException e) {
            NameNotFoundException nnfe = new NameNotFoundException(name.get(0));
            nnfe.setRootCause(e);
            throw nnfe;
        }
        catch (Exception e) {
            throw NamingExceptionHelper.create("Cannot lookup name '" + name + "' : " + e.getMessage(), e);
        }
        return obj;
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    public void bind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new NamingException("Cannot bind empty name");
        }
        if (!(obj instanceof Remote)) {
            throw new NamingException("Can only bind object which implements Remote interface. This is not the case for object '" + obj + "' with name '" + name + "'.");
        }
        try {
            this.registry.bind(name.get(0), (Remote)obj);
        }
        catch (AlreadyBoundException e) {
            NameAlreadyBoundException ne = new NameAlreadyBoundException(name.get(0));
            ne.setRootCause(e);
            throw ne;
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(new CompositeName(name), obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new NamingException("Cannot rebind empty name");
        }
        if (!(obj instanceof Remote)) {
            throw new NamingException("Can only rebind object which implements Remote interface. This is not the case for object '" + obj + "' with name '" + name + "'.");
        }
        try {
            this.registry.rebind(name.get(0), (Remote)obj);
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(new CompositeName(name), obj);
    }

    public void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new NamingException("Cannot unbind empty name");
        }
        try {
            this.registry.unbind(name.get(0));
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this.bind(newName, this.lookup(oldName));
        this.unbind(oldName);
    }

    public void rename(String oldName, String newName) throws NamingException {
        this.rename(new CompositeName(oldName), new CompositeName(newName));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (!name.isEmpty()) {
            throw new NamingException("Cannot list with a given empty name");
        }
        try {
            String[] names = this.registry.list();
            return new LocalEnumeration(this, names);
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (!name.isEmpty()) {
            throw new NamingException("can not list");
        }
        try {
            String[] names = this.registry.list();
            return new LocalEnumeration(this, names);
        }
        catch (RemoteException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new NamingException("destroySubcontext() method not implemented");
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(new CompositeName(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new NamingException("createSubcontext() method not implemented");
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(new CompositeName(name));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return NAME_PARSER;
    }

    public NameParser getNameParser(String name) throws NamingException {
        return NAME_PARSER;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        return result.addAll(name);
    }

    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(new CompositeName(name), new CompositeName(prefix)).toString();
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return environment.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return environment.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)environment.clone();
    }

    public void close() {
    }

    public String getNameInNamespace() {
        return "";
    }
}

