/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.crypto.tls;

import org.python.bouncycastle.crypto.CipherParameters;
import org.python.bouncycastle.crypto.CryptoException;
import org.python.bouncycastle.crypto.DSA;
import org.python.bouncycastle.crypto.Digest;
import org.python.bouncycastle.crypto.Signer;
import org.python.bouncycastle.crypto.digests.NullDigest;
import org.python.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.python.bouncycastle.crypto.params.ParametersWithRandom;
import org.python.bouncycastle.crypto.signers.DSADigestSigner;
import org.python.bouncycastle.crypto.tls.AbstractTlsSigner;
import org.python.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import org.python.bouncycastle.crypto.tls.TlsUtils;

public abstract class TlsDSASigner
extends AbstractTlsSigner {
    public byte[] generateRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray) throws CryptoException {
        Signer signer = this.makeSigner(signatureAndHashAlgorithm, true, true, new ParametersWithRandom(asymmetricKeyParameter, this.context.getSecureRandom()));
        if (signatureAndHashAlgorithm == null) {
            signer.update(byArray, 16, 20);
        } else {
            signer.update(byArray, 0, byArray.length);
        }
        return signer.generateSignature();
    }

    public boolean verifyRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] byArray, AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray2) throws CryptoException {
        Signer signer = this.makeSigner(signatureAndHashAlgorithm, true, false, asymmetricKeyParameter);
        if (signatureAndHashAlgorithm == null) {
            signer.update(byArray2, 16, 20);
        } else {
            signer.update(byArray2, 0, byArray2.length);
        }
        return signer.verifySignature(byArray);
    }

    public Signer createSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm, AsymmetricKeyParameter asymmetricKeyParameter) {
        return this.makeSigner(signatureAndHashAlgorithm, false, true, new ParametersWithRandom(asymmetricKeyParameter, this.context.getSecureRandom()));
    }

    public Signer createVerifyer(SignatureAndHashAlgorithm signatureAndHashAlgorithm, AsymmetricKeyParameter asymmetricKeyParameter) {
        return this.makeSigner(signatureAndHashAlgorithm, false, false, asymmetricKeyParameter);
    }

    protected Signer makeSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm, boolean bl, boolean bl2, CipherParameters cipherParameters) {
        if (signatureAndHashAlgorithm != null != TlsUtils.isTLSv12(this.context)) {
            throw new IllegalStateException();
        }
        if (signatureAndHashAlgorithm != null && (signatureAndHashAlgorithm.getHash() != 2 || signatureAndHashAlgorithm.getSignature() != this.getSignatureAlgorithm())) {
            throw new IllegalStateException();
        }
        Digest digest = bl ? new NullDigest() : TlsUtils.createHash((short)2);
        DSADigestSigner dSADigestSigner = new DSADigestSigner(this.createDSAImpl(), digest);
        dSADigestSigner.init(bl2, cipherParameters);
        return dSADigestSigner;
    }

    protected abstract short getSignatureAlgorithm();

    protected abstract DSA createDSAImpl();
}

