/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.decoder;

import java.util.LinkedHashMap;
import java.util.List;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class ObjectMapDecoder
implements MultiDecoder<Object> {
    private final Codec codec;
    private final boolean decodeList;
    private int pos;
    private boolean mapDecoded;

    public ObjectMapDecoder(Codec codec, boolean decodeList) {
        this.codec = codec;
        this.decodeList = decodeList;
    }

    @Override
    public Decoder<Object> getDecoder(int paramNum, State state) {
        if (this.mapDecoded) {
            return this.codec.getMapKeyDecoder();
        }
        if (this.pos++ % 2 == 0) {
            return this.codec.getMapKeyDecoder();
        }
        return this.codec.getMapValueDecoder();
    }

    @Override
    public Object decode(List<Object> parts, State state) {
        if (this.decodeList && this.mapDecoded) {
            return parts;
        }
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>(parts.size() / 2);
        for (int i = 0; i < parts.size(); ++i) {
            if (i % 2 == 0) continue;
            result.put(parts.get(i - 1), parts.get(i));
        }
        this.mapDecoded = true;
        return result;
    }
}

