/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class CompositeIterator<T>
implements Iterator<T> {
    private Iterator<Iterator<T>> listIterator;
    private Iterator<T> currentIterator;

    public CompositeIterator(Iterator<Iterator<T>> iterators) {
        this.listIterator = iterators;
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator == null || !this.currentIterator.hasNext()) {
            while (this.listIterator.hasNext()) {
                Iterator<T> iterator = this.listIterator.next();
                this.currentIterator = iterator;
                if (!iterator.hasNext()) continue;
                return true;
            }
            return false;
        }
        return this.currentIterator.hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentIterator.next();
    }

    @Override
    public void remove() {
        if (this.currentIterator == null) {
            throw new IllegalStateException("next() has not yet been called");
        }
        this.currentIterator.remove();
    }
}

