/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.reactivex.Flowable;
import io.reactivex.functions.Action;
import io.reactivex.functions.LongConsumer;
import io.reactivex.processors.ReplayProcessor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.redisson.api.RFuture;

public class ElementsStream {
    public static <V> Flowable<V> takeElements(final Supplier<RFuture<V>> callable) {
        final ReplayProcessor p = ReplayProcessor.create();
        return p.doOnRequest(new LongConsumer(){

            public void accept(long n) throws Exception {
                AtomicLong counter = new AtomicLong(n);
                final AtomicReference futureRef = new AtomicReference();
                ElementsStream.take(callable, p, counter, futureRef);
                p.doOnCancel(new Action(){

                    public void run() throws Exception {
                        ((RFuture)futureRef.get()).cancel(true);
                    }
                });
            }
        });
    }

    private static <V> void take(Supplier<RFuture<V>> factory, ReplayProcessor<V> p, AtomicLong counter, AtomicReference<RFuture<V>> futureRef) {
        RFuture<Object> future = factory.get();
        futureRef.set(future);
        future.onComplete((res, e) -> {
            if (e != null) {
                p.onError(e);
                return;
            }
            p.onNext(res);
            if (counter.decrementAndGet() == 0L) {
                p.onComplete();
            }
            ElementsStream.take(factory, p, counter, futureRef);
        });
    }
}

