/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongConsumer;
import org.redisson.ScanResult;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import reactor.core.publisher.FluxSink;

public abstract class IteratorConsumer<V>
implements LongConsumer {
    private final FluxSink<V> emitter;
    private long nextIterPos;
    private RedisClient client;
    private AtomicLong elementsRead = new AtomicLong();
    private boolean finished;
    private volatile boolean completed;
    private AtomicLong readAmount = new AtomicLong();

    public IteratorConsumer(FluxSink<V> emitter) {
        this.emitter = emitter;
    }

    @Override
    public void accept(long value) {
        this.readAmount.addAndGet(value);
        if (this.completed || this.elementsRead.get() == 0L) {
            this.nextValues(this.emitter);
            this.completed = false;
        }
    }

    protected void nextValues(FluxSink<V> emitter) {
        this.scanIterator(this.client, this.nextIterPos).onComplete((res, e) -> {
            if (e != null) {
                emitter.error(e);
                return;
            }
            if (this.finished) {
                this.client = null;
                this.nextIterPos = 0L;
                return;
            }
            this.client = res.getRedisClient();
            this.nextIterPos = res.getPos();
            for (Object val : res.getValues()) {
                Object v = this.transformValue(val);
                emitter.next(v);
                this.elementsRead.incrementAndGet();
            }
            if (this.elementsRead.get() >= this.readAmount.get()) {
                emitter.complete();
                this.elementsRead.set(0L);
                this.completed = true;
                return;
            }
            if (res.getPos() == 0L && !this.tryAgain()) {
                this.finished = true;
                emitter.complete();
            }
            if (this.finished || this.completed) {
                return;
            }
            this.nextValues(emitter);
        });
    }

    protected Object transformValue(Object value) {
        return value;
    }

    protected abstract boolean tryAgain();

    protected abstract RFuture<ScanResult<Object>> scanIterator(RedisClient var1, long var2);
}

