/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.api.RFuture;
import org.redisson.api.RReliableTopic;
import reactor.core.publisher.Flux;

public class RedissonReliableTopicReactive {
    private final RReliableTopic topic;

    public RedissonReliableTopicReactive(RReliableTopic topic) {
        this.topic = topic;
    }

    public <M> Flux<M> getMessages(Class<M> type) {
        return Flux.create(emitter -> emitter.onRequest(n -> {
            AtomicLong counter = new AtomicLong(n);
            AtomicReference idRef = new AtomicReference();
            RFuture<String> t = this.topic.addListenerAsync(type, (channel, msg) -> {
                emitter.next(msg);
                if (counter.decrementAndGet() == 0L) {
                    this.topic.removeListenerAsync((String)idRef.get());
                    emitter.complete();
                }
            });
            t.onComplete((id, e) -> {
                if (e != null) {
                    emitter.error(e);
                    return;
                }
                idRef.set(id);
                emitter.onDispose(() -> this.topic.removeListenerAsync((String)id));
            });
        }));
    }
}

