/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.processors.ReplayProcessor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.api.RFuture;
import org.redisson.api.RReliableTopic;

public class RedissonReliableTopicRx {
    private final RReliableTopic topic;

    public RedissonReliableTopicRx(RReliableTopic topic) {
        this.topic = topic;
    }

    public <M> Flowable<M> getMessages(Class<M> type) {
        ReplayProcessor p = ReplayProcessor.create();
        return p.doOnRequest(n -> {
            AtomicLong counter = new AtomicLong(n);
            AtomicReference idRef = new AtomicReference();
            RFuture<String> t = this.topic.addListenerAsync(type, (channel, msg) -> {
                p.onNext(msg);
                if (counter.decrementAndGet() == 0L) {
                    this.topic.removeListenerAsync((String)idRef.get());
                    p.onComplete();
                }
            });
            t.onComplete((id, e) -> {
                if (e != null) {
                    p.onError(e);
                    return;
                }
                idRef.set(id);
                p.doOnCancel(() -> this.topic.removeListenerAsync((String)id));
            });
        });
    }
}

