/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.RedissonCountDownLatchEntry;
import org.redisson.RedissonObject;
import org.redisson.api.RCountDownLatch;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.pubsub.CountDownLatchPubSub;

public class RedissonCountDownLatch
extends RedissonObject
implements RCountDownLatch {
    private final CountDownLatchPubSub pubSub;
    private final String id;

    protected RedissonCountDownLatch(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.id = commandExecutor.getServiceManager().getId();
        this.pubSub = commandExecutor.getConnectionManager().getSubscribeService().getCountDownLatchPubSub();
    }

    @Override
    public void await() throws InterruptedException {
        if (this.getCount() == 0L) {
            return;
        }
        CompletableFuture<RedissonCountDownLatchEntry> future = this.subscribe();
        RedissonCountDownLatchEntry entry = this.commandExecutor.getInterrupted(future);
        try {
            while (this.getCount() > 0L) {
                entry.getLatch().await();
            }
        }
        finally {
            this.unsubscribe(entry);
        }
    }

    private CompletableFuture<Void> await(RedissonCountDownLatchEntry entry) {
        CompletableFuture countFuture = this.getCountAsync().toCompletableFuture();
        return ((CompletableFuture)countFuture.whenComplete((r, e) -> {
            if (e != null) {
                this.unsubscribe(entry);
            }
        })).thenCompose(r -> {
            if (r == 0L) {
                this.unsubscribe(entry);
                return CompletableFuture.completedFuture(null);
            }
            CompletableFuture future = new CompletableFuture();
            entry.addListener(() -> this.await(entry).whenComplete((res, e) -> {
                if (e != null) {
                    future.completeExceptionally((Throwable)e);
                    return;
                }
                future.complete(res);
            }));
            return future;
        });
    }

    @Override
    public RFuture<Void> awaitAsync() {
        CompletableFuture countFuture = this.getCountAsync().toCompletableFuture();
        CompletionStage f = ((CompletableFuture)countFuture.thenCompose(r -> this.subscribe())).thenCompose(res -> this.await((RedissonCountDownLatchEntry)res));
        return new CompletableFutureWrapper<Void>((CompletableFuture<Void>)f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        long remainTime = unit.toMillis(time);
        long current = System.currentTimeMillis();
        if (this.getCount() == 0L) {
            return true;
        }
        CompletableFuture<RedissonCountDownLatchEntry> promise = this.subscribe();
        try {
            promise.toCompletableFuture().get(time, unit);
        }
        catch (CancellationException | ExecutionException exception) {
        }
        catch (TimeoutException e) {
            return false;
        }
        try {
            if ((remainTime -= System.currentTimeMillis() - current) <= 0L) {
                boolean bl = false;
                return bl;
            }
            while (this.getCount() > 0L) {
                if (remainTime <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                current = System.currentTimeMillis();
                this.commandExecutor.getNow(promise).getLatch().await(remainTime, TimeUnit.MILLISECONDS);
                remainTime -= System.currentTimeMillis() - current;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unsubscribe(this.commandExecutor.getNow(promise));
        }
    }

    @Override
    public RFuture<Boolean> awaitAsync(long waitTime, TimeUnit unit) {
        AtomicLong time = new AtomicLong(unit.toMillis(waitTime));
        long currentTime = System.currentTimeMillis();
        CompletableFuture countFuture = this.getCountAsync().toCompletableFuture();
        CompletionStage f = countFuture.thenCompose(r -> {
            long el = System.currentTimeMillis() - currentTime;
            time.addAndGet(-el);
            if (time.get() <= 0L) {
                return CompletableFuture.completedFuture(false);
            }
            long current = System.currentTimeMillis();
            CompletableFuture<RedissonCountDownLatchEntry> subscribeFuture = this.subscribe();
            this.pubSub.timeout((CompletableFuture)subscribeFuture, time.get());
            return subscribeFuture.thenCompose(entry -> {
                long elapsed = System.currentTimeMillis() - current;
                time.addAndGet(-elapsed);
                return this.await(time, (RedissonCountDownLatchEntry)entry);
            });
        });
        return new CompletableFutureWrapper<Boolean>((CompletableFuture<Boolean>)f);
    }

    private CompletableFuture<Boolean> await(final AtomicLong time, final RedissonCountDownLatchEntry entry) {
        if (time.get() <= 0L) {
            this.unsubscribe(entry);
            return CompletableFuture.completedFuture(false);
        }
        long curr = System.currentTimeMillis();
        CompletableFuture countFuture = this.getCountAsync().toCompletableFuture();
        return ((CompletableFuture)countFuture.whenComplete((r, e) -> {
            if (e != null) {
                this.unsubscribe(entry);
            }
        })).thenCompose(r -> {
            if (r == 0L) {
                this.unsubscribe(entry);
                return CompletableFuture.completedFuture(true);
            }
            long el = System.currentTimeMillis() - curr;
            time.addAndGet(-el);
            if (time.get() <= 0L) {
                this.unsubscribe(entry);
                return CompletableFuture.completedFuture(false);
            }
            final CompletableFuture future = new CompletableFuture();
            final long current = System.currentTimeMillis();
            AtomicBoolean executed = new AtomicBoolean();
            AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
            final Runnable listener = () -> {
                executed.set(true);
                if (futureRef.get() != null) {
                    ((Timeout)futureRef.get()).cancel();
                }
                long elapsed = System.currentTimeMillis() - current;
                time.addAndGet(-elapsed);
                this.commandExecutor.transfer(this.await(time, entry), future);
            };
            entry.addListener(listener);
            if (!executed.get()) {
                Timeout timeoutFuture = this.commandExecutor.getServiceManager().newTimeout(new TimerTask(){

                    public void run(Timeout timeout) throws Exception {
                        if (entry.removeListener(listener)) {
                            long elapsed = System.currentTimeMillis() - current;
                            time.addAndGet(-elapsed);
                            RedissonCountDownLatch.this.commandExecutor.transfer(RedissonCountDownLatch.this.await(time, entry), future);
                        }
                    }
                }, time.get(), TimeUnit.MILLISECONDS);
                futureRef.set(timeoutFuture);
            }
            return future;
        });
    }

    private CompletableFuture<RedissonCountDownLatchEntry> subscribe() {
        return this.pubSub.subscribe(this.getEntryName(), this.getChannelName());
    }

    private void unsubscribe(RedissonCountDownLatchEntry entry) {
        this.pubSub.unsubscribe(entry, this.getEntryName(), this.getChannelName());
    }

    @Override
    public void countDown() {
        this.get(this.countDownAsync());
    }

    @Override
    public RFuture<Void> countDownAsync() {
        return this.commandExecutor.evalWriteNoRetryAsync(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local v = redis.call('decr', KEYS[1]);if v <= 0 then redis.call('del', KEYS[1]) end;if v == 0 then redis.call('publish', KEYS[2], ARGV[1]) end;", Arrays.asList(this.getRawName(), this.getChannelName()), CountDownLatchPubSub.ZERO_COUNT_MESSAGE);
    }

    private String getEntryName() {
        return this.id + this.getRawName();
    }

    private String getChannelName() {
        return "redisson_countdownlatch__channel__{" + this.getRawName() + "}";
    }

    @Override
    public long getCount() {
        return this.get(this.getCountAsync());
    }

    @Override
    public RFuture<Long> getCountAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.GET_LONG, this.getRawName());
    }

    @Override
    public boolean trySetCount(long count) {
        return this.get(this.trySetCountAsync(count));
    }

    @Override
    public RFuture<Boolean> trySetCountAsync(long count) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('exists', KEYS[1]) == 0 then redis.call('set', KEYS[1], ARGV[2]); redis.call('publish', KEYS[2], ARGV[1]); return 1 else return 0 end", Arrays.asList(this.getRawName(), this.getChannelName()), CountDownLatchPubSub.NEW_COUNT_MESSAGE, count);
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('del', KEYS[1]) == 1 then redis.call('publish', KEYS[2], ARGV[1]); return 1 else return 0 end", Arrays.asList(this.getRawName(), this.getChannelName()), CountDownLatchPubSub.NEW_COUNT_MESSAGE);
    }
}

